/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.common.components.ArmorEffectData;
import io.github.flemmli97.runecraftory.common.components.FoodAttributeData;
import io.github.flemmli97.runecraftory.common.components.ItemAttributeData;
import io.github.flemmli97.runecraftory.common.components.ItemStackHolder;
import io.github.flemmli97.runecraftory.common.components.ListItemStackHolder;
import io.github.flemmli97.runecraftory.common.components.StaffData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.items.ToolItemTier;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class ItemComponentUtils {
    public static int itemLevel(ItemStack stack) {
        return (Integer)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.LEVEL.get(), (Object)1);
    }

    public static ItemStack getLeveledItem(ItemStack stack, int level) {
        if (ItemComponentUtils.shouldHaveLevel(stack)) {
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.LEVEL.get(), (Object)Mth.clamp((int)level, (int)1, (int)10));
        }
        return stack;
    }

    public static void modifyAttribute(ItemStack stack, Consumer<ItemAttributeModifiers.Entry> remove, Consumer<ItemAttributeModifiers.Entry> add) {
        Pair<EquipmentSlot, Map<Holder<Attribute>, Double>> calculated = ItemComponentUtils.getStatsAttributes(stack);
        if (calculated != null) {
            ItemAttributeModifiers defaultMap = (ItemAttributeModifiers)stack.getPrototype().get(DataComponents.ATTRIBUTE_MODIFIERS);
            if (defaultMap != null) {
                defaultMap.modifiers().forEach(entry -> {
                    if (entry.slot().test((EquipmentSlot)calculated.getFirst())) {
                        remove.accept((ItemAttributeModifiers.Entry)entry);
                    }
                });
            }
            ((Map)calculated.getSecond()).forEach((att, d) -> add.accept(new ItemAttributeModifiers.Entry(att, new AttributeModifier(LibConstants.EQUIPMENT_MODIFIERS.get(calculated.getFirst()), d.doubleValue(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)((EquipmentSlot)calculated.getFirst())))));
        }
    }

    public static Pair<EquipmentSlot, Map<Holder<Attribute>, Double>> getStatsAttributes(ItemStack stack) {
        Equipable equipable = Equipable.get((ItemStack)stack);
        if (ItemComponentUtils.shouldHaveStats(stack)) {
            EquipmentSlot slot = equipable != null ? equipable.getEquipmentSlot() : EquipmentSlot.MAINHAND;
            Map<Holder<Attribute>, Double> stats = ItemComponentUtils.statIncrease(stack);
            if (stats.isEmpty()) {
                return null;
            }
            return Pair.of((Object)slot, stats);
        }
        return null;
    }

    public static Map<Holder<Attribute>, Double> statIncrease(ItemStack stack) {
        ItemAttributeData stats = (ItemAttributeData)stack.get((DataComponentType)RuneCraftoryDataComponentTypes.STATS.get());
        if (stats == null) {
            return DataPackHandler.INSTANCE.itemStatManager().get(stack.getItem()).map(ItemStat::itemStats).orElse(Map.of());
        }
        return stats.getTotalStats();
    }

    public static Pair<Map<Holder<Attribute>, Double>, Map<Holder<Attribute>, Double>> foodStats(ItemStack stack) {
        FoodProperties props = DataPackHandler.INSTANCE.foodManager().get(stack.getItem());
        if (props == null) {
            return Pair.of(new TreeMap(RuneCraftoryAttributes.SORTED), new TreeMap(RuneCraftoryAttributes.SORTED));
        }
        FoodAttributeData data = (FoodAttributeData)stack.get((DataComponentType)RuneCraftoryDataComponentTypes.FOOD_BUFF.get());
        if (data == null) {
            return Pair.of(props.effects(), props.effectsMultiplier());
        }
        return Pair.of(data.getFlatStats(), data.getMultiplierStats());
    }

    public static void setElement(ItemElement element, ItemStack stack) {
        ItemElement stackElement = (ItemElement)((Object)stack.get((DataComponentType)RuneCraftoryDataComponentTypes.ELEMENT.get()));
        stack.set((DataComponentType)RuneCraftoryDataComponentTypes.ELEMENT.get(), (Object)(stackElement == null || stackElement == element ? element : ItemElement.NONE));
    }

    public static ItemElement getElement(ItemStack stack) {
        ItemElement stackElement = (ItemElement)((Object)stack.get((DataComponentType)RuneCraftoryDataComponentTypes.ELEMENT.get()));
        if (stackElement != null) {
            return stackElement;
        }
        return ItemComponentUtils.isWeapon(stack) ? DataPackHandler.INSTANCE.itemStatManager().get(stack.getItem()).map(ItemStat::element).orElse(ItemElement.NONE) : ItemElement.NONE;
    }

    public static ItemStack addUpgradeItem(ItemStack stack, ItemStack upgrade, boolean crafting, CraftingType type) {
        int level = ItemComponentUtils.itemLevel(stack);
        if (upgrade.isEmpty() || !ItemComponentUtils.shouldHaveStats(stack) || level >= 10) {
            return ItemStack.EMPTY;
        }
        ItemStat stat = DataPackHandler.INSTANCE.itemStatManager().get(upgrade.getItem()).orElse(null);
        if (ItemComponentUtils.shouldHaveStats(upgrade)) {
            if (!crafting || stack.has((DataComponentType)RuneCraftoryDataComponentTypes.ORIGINAL_ITEM.get())) {
                return stack;
            }
            boolean lightOre = (Boolean)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.LIGHT_ORE.get(), (Object)false);
            if (stack.is(RunecraftoryTags.Items.EQUIPMENT)) {
                boolean sameType;
                if (!upgrade.is(RunecraftoryTags.Items.EQUIPMENT)) {
                    return stack;
                }
                if (lightOre) {
                    return ItemComponentUtils.changeBaseItemTo(stack, upgrade, type);
                }
                Equipable current = Equipable.get((ItemStack)stack);
                Equipable equipable = Equipable.get((ItemStack)upgrade);
                boolean bl = sameType = current == null && equipable == null || current != null && equipable != null && current.getEquipmentSlot() == equipable.getEquipmentSlot();
                if (sameType) {
                    return ItemComponentUtils.changeBaseItemTo(stack, upgrade, type);
                }
            }
            if (stack.is(RunecraftoryTags.Items.UPGRADABLE_HELD)) {
                if (!upgrade.is(RunecraftoryTags.Items.UPGRADABLE_HELD)) {
                    return stack;
                }
                if (lightOre) {
                    return ItemComponentUtils.changeBaseItemTo(stack, upgrade, type);
                }
                for (TagKey tagKey : RunecraftoryTags.Items.WEAPONTAGS) {
                    if (!stack.is(tagKey) || !upgrade.is(tagKey)) continue;
                    return ItemComponentUtils.changeBaseItemTo(stack, upgrade, type);
                }
            }
            if (stat != null) {
                stat.getArmorEffect().ifPresent(effect -> {
                    if (((ArmorEffect)effect.value()).canBeAppliedTo(stack)) {
                        ((ArmorEffectData)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.ARMOR_EFFECT.get(), (Object)ArmorEffectData.DEFAULT)).add((Holder<ArmorEffect>)effect);
                    }
                });
            }
            return stack;
        }
        stack.set((DataComponentType)RuneCraftoryDataComponentTypes.LEVEL.get(), (Object)(!crafting ? level + 1 : level));
        float efficiency = 1.0f;
        if (!crafting) {
            ListItemStackHolder upgrades = (ListItemStackHolder)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.UPGRADES.get(), (Object)ListItemStackHolder.DEFAULT);
            int n = upgrades.matchesItem(upgrade);
            efficiency = n > 0 ? (float)Math.pow(0.5, n) : 1.0f;
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.UPGRADES.get(), (Object)upgrades.add(upgrade));
        } else {
            ListItemStackHolder bonus = (ListItemStackHolder)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.CRAFTING_BONUS.get(), (Object)ListItemStackHolder.DEFAULT);
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.UPGRADES.get(), (Object)bonus.add(upgrade));
        }
        if (upgrade.getItem() == RuneCraftoryItems.GLASS.get() && stack.is(RunecraftoryTags.Items.UPGRADABLE_HELD)) {
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.MAGNIFYING_GLASS.get(), (Object)Unit.INSTANCE);
        }
        if (upgrade.getItem() == RuneCraftoryItems.SCRAP_PLUS.get() && stack.is(RunecraftoryTags.Items.UPGRADABLE_HELD)) {
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.SCRAP_METAL_PLUS.get(), (Object)Unit.INSTANCE);
        }
        boolean hasObjectX = (Boolean)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.OBJECT_X.get(), (Object)false);
        if (upgrade.getItem() == RuneCraftoryItems.OBJECT_X.get()) {
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.OBJECT_X.get(), (Object)(!hasObjectX ? 1 : 0));
        }
        if (type == CraftingType.FORGE && upgrade.getItem() == RuneCraftoryItems.INVIS_STONE.get()) {
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.INVISIBLE.get(), (Object)Unit.INSTANCE);
        }
        if (type == CraftingType.FORGE && upgrade.is(RunecraftoryTags.Items.SCALES)) {
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.DRAGON_SCALE.get(), (Object)Unit.INSTANCE);
        }
        if (crafting && upgrade.getItem() == RuneCraftoryItems.LIGHT_ORE.get() && !stack.has((DataComponentType)RuneCraftoryDataComponentTypes.ORIGINAL_ITEM.get())) {
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.LIGHT_ORE.get(), (Object)true);
        }
        boolean bl = (Boolean)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.DOUBLE_STEEL.get(), (Object)false);
        if (!stack.has((DataComponentType)RuneCraftoryDataComponentTypes.DOUBLE_STEEL.get())) {
            if (upgrade.getItem() == RuneCraftoryItems.STEEL_DOUBLE.get()) {
                stack.set((DataComponentType)RuneCraftoryDataComponentTypes.DOUBLE_STEEL.get(), (Object)true);
            }
        } else if (bl) {
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.DOUBLE_STEEL.get(), (Object)false);
        }
        boolean applyTenSteel = (Boolean)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TENFOLD_STEEL.get(), (Object)false);
        if (!stack.has((DataComponentType)RuneCraftoryDataComponentTypes.TENFOLD_STEEL.get())) {
            if (upgrade.getItem() == RuneCraftoryItems.STEEL_TEN.get()) {
                stack.set((DataComponentType)RuneCraftoryDataComponentTypes.TENFOLD_STEEL.get(), (Object)true);
            }
        } else if (applyTenSteel) {
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.TENFOLD_STEEL.get(), (Object)false);
        }
        if (stat != null) {
            boolean applyUpgradeStat;
            ItemStat base;
            ItemAttributeData stats = (ItemAttributeData)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.STATS.get(), (Object)ItemAttributeData.DEFAULT);
            if (stats.getBaseStats().isEmpty() && (base = (ItemStat)DataPackHandler.INSTANCE.itemStatManager().get(stack.getItem()).orElse(null)) != null && !base.itemStats().isEmpty()) {
                stats = stats.base(base.itemStats());
            }
            boolean bl2 = applyUpgradeStat = !upgrade.is(type.upgradeBlacklist) && (!upgrade.is(RunecraftoryTags.Items.ONE_TIME_UPGRADE) || ((ListItemStackHolder)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.UPGRADES.get(), (Object)ListItemStackHolder.DEFAULT)).matchesItem(upgrade) == 0);
            if (applyUpgradeStat) {
                TagKey<Attribute> blacklist = null;
                if (type == CraftingType.FORGE) {
                    blacklist = RunecraftoryTags.Attributes.WEAPON_ONLY;
                }
                if (type == CraftingType.ACCESSORY_WORKBENCH) {
                    blacklist = RunecraftoryTags.Attributes.ARMOR_ONLY;
                }
                HashMap<Holder<Attribute>, Double> upgradeStats = new HashMap<Holder<Attribute>, Double>();
                for (Map.Entry<Holder<Attribute>, Double> entry : stat.itemStats().entrySet()) {
                    if (blacklist != null && entry.getKey().is(blacklist)) continue;
                    double amount = entry.getValue() * (double)efficiency;
                    if (hasObjectX) {
                        amount *= -1.0;
                    }
                    if (bl) {
                        amount *= 2.0;
                    }
                    if (applyTenSteel) {
                        amount *= 8.0;
                    }
                    upgradeStats.put(entry.getKey(), amount);
                }
                stats = stats.add(upgradeStats);
            }
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.STATS.get(), (Object)stats);
            if (ItemComponentUtils.isWeapon(stack)) {
                ItemComponentUtils.setElement(stat.element(), stack);
            }
            if (stack.getItem() instanceof ItemStaffBase) {
                stack.update((DataComponentType)RuneCraftoryDataComponentTypes.STAFF.get(), (Object)StaffData.DEFAULT, data -> {
                    if (stat.getTier1Spell().isPresent()) {
                        data = data.setTier1Spell(stat.getTier1Spell().get());
                    }
                    if (stat.getTier2Spell().isPresent()) {
                        data = data.setTier2Spell(stat.getTier2Spell().get());
                    }
                    if (stat.getTier3Spell().isPresent()) {
                        data = data.setTier3Spell(stat.getTier3Spell().get());
                    }
                    return data;
                });
            }
            if (stat.getArmorEffect().isPresent() && ((ArmorEffect)stat.getArmorEffect().get().value()).canBeAppliedTo(stack)) {
                stack.update((DataComponentType)RuneCraftoryDataComponentTypes.ARMOR_EFFECT.get(), (Object)ArmorEffectData.DEFAULT, data -> data.add(stat.getArmorEffect().get()));
            }
        }
        return stack;
    }

    private static ItemStack changeBaseItemTo(ItemStack stack, ItemStack toApply, CraftingType crafting) {
        ItemStat stat = DataPackHandler.INSTANCE.itemStatManager().get(toApply.getItem()).orElse(null);
        if (stat != null) {
            ItemAttributeData stats = (ItemAttributeData)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.STATS.get(), (Object)ItemAttributeData.DEFAULT);
            ItemStat base = DataPackHandler.INSTANCE.itemStatManager().get(stack.getItem()).orElse(null);
            if (base != null) {
                HashMap<Holder<Attribute>, Double> baseStats = new HashMap<Holder<Attribute>, Double>();
                Map origin = DataPackHandler.INSTANCE.itemStatManager().get(stack.getItem()).map(ItemStat::itemStats).orElse(Map.of());
                for (Map.Entry<Holder<Attribute>, Double> entry : base.itemStats().entrySet()) {
                    if (entry.getKey().is(RunecraftoryTags.Attributes.NON_INHERITABLE)) {
                        if (!origin.containsKey(entry.getKey())) continue;
                        baseStats.put(entry.getKey(), (Double)origin.get(entry.getKey()));
                        continue;
                    }
                    baseStats.put(entry.getKey(), entry.getValue());
                }
                stack.set((DataComponentType)RuneCraftoryDataComponentTypes.STATS.get(), (Object)stats.base(baseStats));
            }
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.ELEMENT.get(), (Object)stat.element());
            if (stack.getItem() instanceof ItemStaffBase) {
                stack.update((DataComponentType)RuneCraftoryDataComponentTypes.STAFF.get(), (Object)StaffData.DEFAULT, data -> {
                    if (stat.getTier1Spell().isPresent()) {
                        data = data.setTier1Spell(stat.getTier1Spell().get());
                    }
                    if (stat.getTier2Spell().isPresent()) {
                        data = data.setTier2Spell(stat.getTier2Spell().get());
                    }
                    if (stat.getTier3Spell().isPresent()) {
                        data = data.setTier3Spell(stat.getTier3Spell().get());
                    }
                    return data;
                });
            }
            if (stat.getArmorEffect().isPresent() && ((ArmorEffect)stat.getArmorEffect().get().value()).canBeAppliedTo(stack)) {
                stack.update((DataComponentType)RuneCraftoryDataComponentTypes.ARMOR_EFFECT.get(), (Object)ArmorEffectData.DEFAULT, data -> data.add(stat.getArmorEffect().get()));
            }
        }
        stack.set((DataComponentType)RuneCraftoryDataComponentTypes.ORIGINAL_ITEM.get(), (Object)new ItemStackHolder(toApply));
        ListItemStackHolder bonus = (ListItemStackHolder)toApply.get((DataComponentType)RuneCraftoryDataComponentTypes.CRAFTING_BONUS.get());
        if (bonus != null) {
            bonus.forEach(added -> ItemComponentUtils.addUpgradeItem(stack, added, true, crafting));
        }
        return stack;
    }

    public static ItemStack addFoodBonusItem(ItemStack stack, ItemStack stackToAdd) {
        ListItemStackHolder bonus = (ListItemStackHolder)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.CRAFTING_BONUS.get(), (Object)ListItemStackHolder.DEFAULT);
        stack.set((DataComponentType)RuneCraftoryDataComponentTypes.UPGRADES.get(), (Object)bonus.add(stackToAdd));
        FoodProperties props = DataPackHandler.INSTANCE.foodManager().get(stackToAdd.getItem());
        boolean hasObjectX = (Boolean)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.OBJECT_X.get(), (Object)false);
        if (stackToAdd.getItem() == RuneCraftoryItems.OBJECT_X.get()) {
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.OBJECT_X.get(), (Object)(!hasObjectX ? 1 : 0));
        }
        if (props != null) {
            FoodAttributeData stats = (FoodAttributeData)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.FOOD_BUFF.get(), (Object)FoodAttributeData.DEFAULT);
            HashMap<Holder<Attribute>, Double> flatStats = new HashMap<Holder<Attribute>, Double>();
            for (Map.Entry<Holder<Attribute>, Double> entry : props.cookingBonus().entrySet()) {
                double amount = entry.getValue();
                if (hasObjectX) {
                    amount *= -1.0;
                }
                flatStats.put(entry.getKey(), amount);
            }
            stats = stats.add(flatStats);
            HashMap<Holder<Attribute>, Double> multStats = new HashMap<Holder<Attribute>, Double>();
            for (Map.Entry<Holder<Attribute>, Double> entry : props.cookingBonusPercent().entrySet()) {
                double amount = entry.getValue();
                if (hasObjectX) {
                    amount *= -1.0;
                }
                multStats.put(entry.getKey(), amount);
            }
            stats = stats.addMultiplier(multStats);
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.FOOD_BUFF.get(), (Object)stats);
        }
        return stack;
    }

    public static boolean shouldHaveStats(ItemStack stack) {
        return stack.is(RunecraftoryTags.Items.UPGRADABLE_HELD) || stack.is(RunecraftoryTags.Items.EQUIPMENT);
    }

    public static boolean shouldHaveLevel(ItemStack stack) {
        return ItemComponentUtils.shouldHaveStats(stack) || stack.is(RunecraftoryTags.Items.SPELLS);
    }

    public static boolean isWeapon(ItemStack stack) {
        return stack.is(RunecraftoryTags.Items.UPGRADABLE_HELD);
    }

    public static boolean usedLightOre(ItemStack stack) {
        if (ItemComponentUtils.shouldHaveStats(stack)) {
            if (((ItemStackHolder)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.ORIGINAL_ITEM.get(), (Object)ItemStackHolder.DEFAULT)).isEmpty()) {
                return false;
            }
            return stack.has((DataComponentType)RuneCraftoryDataComponentTypes.LIGHT_ORE.get());
        }
        return false;
    }

    public static int getChargeTime(LivingEntity entity) {
        return Mth.ceil((double)EntityUtils.tryGetAttribute(entity, (Holder<Attribute>)RuneCraftoryAttributes.CHARGE_TIME.asHolder()));
    }

    public static int getChargeTime(LivingEntity entity, ToolItemTier toolTier) {
        int time = Mth.ceil((double)EntityUtils.tryGetAttribute(entity, (Holder<Attribute>)RuneCraftoryAttributes.CHARGE_TIME.asHolder()));
        if (toolTier == ToolItemTier.PLATINUM) {
            time = (int)((float)time * GeneralConfig.platinumChargeTime);
        }
        return time;
    }

    public static float getShieldEfficiency(LivingEntity entity) {
        return ItemComponentUtils.getShieldEfficiency(entity.getMainHandItem());
    }

    public static float getShieldEfficiency(ItemStack stack) {
        float eff = ((Float)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.SHIELD_EFFICIENCY.get(), (Object)Float.valueOf(1.0f))).floatValue();
        if (eff < 1.0f && stack.has((DataComponentType)RuneCraftoryDataComponentTypes.DRAGON_SCALE.get())) {
            eff = Mth.clamp((float)(eff + 0.5f), (float)0.5f, (float)0.75f);
        }
        return eff;
    }
}

