/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TeleportUtils {
    public static void safeDimensionTeleport(Mob entity, ServerLevel newLevel, BlockPos target) {
        BlockPos safe = null;
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = TeleportUtils.randomIntInclusive(entity.getRandom(), -3, 3);
            BlockPos pos = TeleportUtils.isSafePos(entity, (Level)newLevel, target.offset(x, y = TeleportUtils.randomIntInclusive(entity.getRandom(), -1, 2), z = TeleportUtils.randomIntInclusive(entity.getRandom(), -3, 3)), s -> true);
            if (pos == null) continue;
            safe = pos;
            break;
        }
        if (safe == null) {
            return;
        }
        float yaw = entity.getYRot();
        float pitch = entity.getXRot();
        entity.unRide();
        Mob old = entity;
        entity = (Mob)old.getType().create((Level)newLevel);
        if (entity == null) {
            return;
        }
        entity.restoreFrom((Entity)old);
        entity.moveTo((double)safe.getX(), (double)safe.getY(), (double)safe.getZ(), yaw, pitch);
        old.setRemoved(Entity.RemovalReason.CHANGED_DIMENSION);
        newLevel.addDuringTeleport((Entity)entity);
        newLevel.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)RuneCraftorySounds.GENERIC_TELEPORT.get(), SoundSource.MASTER, 1.0f, 1.0f);
        for (int i = 0; i < 32; ++i) {
            newLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, entity.getX(), entity.getY() + newLevel.random.nextDouble() * 2.0, entity.getZ(), 0, newLevel.random.nextGaussian(), 0.0, newLevel.random.nextGaussian(), 1.0);
        }
    }

    public static void tryTeleportAround(Mob entity, Entity target) {
        BlockPos blockPos = target.blockPosition();
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = TeleportUtils.randomIntInclusive(entity.getRandom(), -3, 3);
            BlockPos pos = blockPos.offset(x, y = TeleportUtils.randomIntInclusive(entity.getRandom(), -1, 2), z = TeleportUtils.randomIntInclusive(entity.getRandom(), -3, 3));
            if (!TeleportUtils.validTeleportPlace(entity, pos, s -> true)) continue;
            entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, entity.getYRot(), entity.getXRot());
            entity.getNavigation().stop();
            return;
        }
    }

    public static void tryTeleportAround(Mob entity, BlockPos target) {
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = TeleportUtils.randomIntInclusive(entity.getRandom(), -3, 3);
            BlockPos pos = target.offset(x, y = TeleportUtils.randomIntInclusive(entity.getRandom(), -1, 2), z = TeleportUtils.randomIntInclusive(entity.getRandom(), -3, 3));
            if (!TeleportUtils.validTeleportPlace(entity, pos, s -> true)) continue;
            entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, entity.getYRot(), entity.getXRot());
            entity.getNavigation().stop();
            return;
        }
    }

    public static boolean validTeleportPlace(Mob entity, BlockPos pos, Predicate<BlockState> validPos) {
        return TeleportUtils.isSafePos(entity, pos, validPos) != null;
    }

    public static BlockPos isSafePos(Mob entity, BlockPos pos, Predicate<BlockState> validPos) {
        return TeleportUtils.isSafePos(entity, entity.level(), pos, validPos);
    }

    public static BlockPos isSafePos(Mob entity, Level level, BlockPos pos, Predicate<BlockState> validPos) {
        PathType blockPathTypes = entity.getNavigation().getNodeEvaluator().getPathType(new PathfindingContext((CollisionGetter)entity.level(), entity), pos.getX(), pos.getY(), pos.getZ());
        if (blockPathTypes == PathType.OPEN ? !entity.isNoGravity() : blockPathTypes != PathType.WALKABLE) {
            return null;
        }
        BlockState blockState = level.getBlockState(pos.below());
        if (!validPos.test(blockState)) {
            return null;
        }
        for (VoxelShape voxelShape : level.getBlockCollisions((Entity)entity, entity.getBoundingBox().move((double)pos.getX() + 0.5 - entity.getX(), (double)pos.getY() - entity.getY(), (double)pos.getZ() + 0.5 - entity.getZ()))) {
            if (voxelShape.isEmpty()) continue;
            return null;
        }
        return pos;
    }

    private static int randomIntInclusive(RandomSource random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }
}

