/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.data;

import io.github.flemmli97.runecraftory.api.calendar.DayOfWeek;
import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.runecraftory.api.calendar.Weather;
import io.github.flemmli97.runecraftory.client.ClientCalendarHolder;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.network.S2CCalendar;
import io.github.flemmli97.runecraftory.common.utils.StreamCodecUtils;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.data.RunecraftorySavedData;
import io.github.flemmli97.runecraftory.integration.sereneseasons.SeasonsAccess;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Calendar {
    @Nullable
    private final RunecraftorySavedData handler;
    private Date current = new Date(1, 1, DayOfWeek.MONDAY, Season.SPRING);
    private Weather[] todaysForecast = new Weather[]{Weather.CLEAR};
    private Weather currentWeather = Weather.CLEAR;
    private Weather[] nextForecast = new Weather[]{Weather.CLEAR};
    private int updateDelay;

    public Calendar(@Nullable RunecraftorySavedData handler) {
        this.handler = handler;
    }

    public static Calendar get(Level level) {
        if (level.isClientSide()) {
            return ClientCalendarHolder.CLIENT_CALENDAR;
        }
        return RunecraftorySavedData.get(level.getServer()).getCalendar();
    }

    public static boolean canUpdateWeather(Level level) {
        return GeneralConfig.modifyWeather && level.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT);
    }

    public static boolean shouldUpdateWeather(Level level, Weather currentWeather) {
        if (currentWeather == Weather.RUNEY || currentWeather == Weather.STORM) {
            return WorldUtils.dayTime(level) == 1;
        }
        long time = WorldUtils.dayTime(level);
        return time % 3000L == 1L;
    }

    public Season currentSeason() {
        return this.date().season();
    }

    public Date date() {
        return this.current;
    }

    public void setDateDayAndSeason(MinecraftServer server, int dayOfYear, int date, DayOfWeek day, Season season) {
        this.current = new Date(dayOfYear, date, day, season);
        LoaderNetwork.INSTANCE.sendToAll((CustomPacketPayload)new S2CCalendar(this), server);
        this.setDirty();
    }

    public void tick(ServerLevel level, boolean isUpdateTime) {
        SeasonsAccess.SeasonData seasons = SeasonsAccess.getDate((Level)level);
        if (seasons != null) {
            boolean changed;
            boolean bl = changed = this.current.dayOfYear() != seasons.dayOfYear() || this.current.season() != seasons.season();
            if (changed) {
                int diff;
                for (diff = seasons.dayOfYear() - this.current.dayOfYear(); diff < 0; diff += seasons.daysPerYear()) {
                }
                DayOfWeek day = DayOfWeek.values()[Math.floorMod(this.current.day().ordinal() + diff, DayOfWeek.values().length)];
                this.current = new Date(seasons.dayOfYear(), seasons.dayOfSeason(), day, seasons.season());
                LoaderNetwork.INSTANCE.sendToAll((CustomPacketPayload)new S2CCalendar(this), level.getServer());
                this.setDirty();
            }
        } else if (isUpdateTime) {
            this.increaseDay(level);
            this.createDailyWeather(level);
        }
        boolean doWeather = Calendar.canUpdateWeather((Level)level);
        if (doWeather && (isUpdateTime || Calendar.shouldUpdateWeather((Level)level, this.currentWeather()))) {
            this.updateWeatherTo(level, this.getCurrentWeatherFor(level));
        }
    }

    private void increaseDay(ServerLevel level) {
        int date = WorldUtils.day((Level)level);
        DayOfWeek day = DayOfWeek.values()[Math.floorMod(date, DayOfWeek.values().length)];
        Season season = Season.values()[Math.floorMod(date / 30, Season.values().length)];
        this.setDateDayAndSeason(level.getServer(), date % 120 + 1, date % 30 + 1, day, season);
        LoaderNetwork.INSTANCE.sendToAll((CustomPacketPayload)new S2CCalendar(this), level.getServer());
        this.setDirty();
    }

    public void updateWeatherTo(ServerLevel level, Weather weather) {
        this.setWeather(level.getServer(), weather);
        this.setMCWeather(level);
        this.updateDelay = 100;
        this.setDirty();
    }

    private void createDailyWeather(ServerLevel level) {
        Weather[] nextWeather = new Weather[8];
        Season season = this.currentSeason();
        int rainCount = 0;
        for (int i = 0; i < nextWeather.length; ++i) {
            float rainAdd;
            float chance = level.random.nextFloat();
            if (i != 0) {
                if (nextWeather[0].wholeDay) {
                    nextWeather[i] = nextWeather[0];
                    return;
                }
            } else {
                float stormAdd;
                float f = stormAdd = season == Season.SUMMER || season == Season.WINTER ? 0.04f : 0.0f;
                if (chance < 0.03f) {
                    nextWeather[i] = Weather.RUNEY;
                } else if (chance < 0.015f + stormAdd) {
                    nextWeather[i] = Weather.STORM;
                }
                if (nextWeather[i] != null) {
                    return;
                }
            }
            float f = rainAdd = rainCount > 0 ? 0.5f - (float)(rainCount - 1) * 0.2f : 0.0f;
            if (i < 3) {
                rainAdd = (float)((double)rainAdd + (season == Season.SUMMER ? 0.1 : 0.05));
            }
            if (chance < 0.1f + rainAdd) {
                nextWeather[i] = Weather.RAIN;
                ++rainCount;
                continue;
            }
            nextWeather[i] = Weather.CLEAR;
        }
        this.updateWeathers(nextWeather);
    }

    private void setMCWeather(ServerLevel level) {
        this.currentWeather().setWeather.accept(level);
    }

    private boolean isCorrectWeather(ServerLevel level) {
        return switch (this.currentWeather()) {
            default -> throw new MatchException(null, null);
            case Weather.RAIN -> level.isRaining();
            case Weather.CLEAR, Weather.RUNEY, Weather.CLOUDY -> {
                if (!level.isRaining() && !level.isThundering()) {
                    yield true;
                }
                yield false;
            }
            case Weather.STORM -> level.isRaining() && level.isThundering();
        };
    }

    public Weather currentWeather() {
        return this.currentWeather;
    }

    public Weather getCurrentWeatherFor(ServerLevel level) {
        int i = WorldUtils.dayTime((Level)level) / 3000;
        if (i >= 0 && i < this.todaysForecast.length) {
            return this.todaysForecast[i];
        }
        return Weather.CLEAR;
    }

    public Weather[] todaysForecast() {
        return this.todaysForecast;
    }

    public Weather[] tomorrowsForecast() {
        return this.nextForecast;
    }

    public void setWeather(MinecraftServer server, Weather weather) {
        this.currentWeather = weather;
        LoaderNetwork.INSTANCE.sendToAll((CustomPacketPayload)new S2CCalendar(this), server);
    }

    public void updateWeathers(Weather[] nextDays) {
        this.todaysForecast = this.nextForecast;
        this.nextForecast = nextDays;
    }

    public void updateDirect(Date date, Weather weather) {
        this.current = date;
        this.currentWeather = weather;
    }

    private void setDirty() {
        if (this.handler != null) {
            this.handler.setDirty();
        }
    }

    public void read(CompoundTag nbt) {
        this.current = new Date(nbt.getInt("DayOfYear"), nbt.getInt("Date"), DayOfWeek.valueOf(nbt.getString("Day")), Season.valueOf(nbt.getString("Season")));
        this.currentWeather = Weather.valueOf(nbt.getString("Weather"));
        ListTag list = nbt.getList("Forecast", 8);
        this.todaysForecast = (Weather[])list.stream().map(t -> Weather.valueOf(t.getAsString())).limit(8L).toArray(Weather[]::new);
        ListTag next = nbt.getList("NextForecast", 8);
        this.nextForecast = (Weather[])next.stream().map(t -> Weather.valueOf(t.getAsString())).limit(8L).toArray(Weather[]::new);
    }

    public CompoundTag write(CompoundTag nbt) {
        nbt.putInt("DayOfYear", this.current.dayOfYear());
        nbt.putInt("Date", this.current.date());
        nbt.putString("Day", this.current.day().toString());
        nbt.putString("Season", this.current.season().toString());
        nbt.putString("Weather", this.currentWeather.toString());
        ListTag list = new ListTag();
        Arrays.stream(this.todaysForecast).forEach(w -> list.add((Object)StringTag.valueOf((String)w.toString())));
        nbt.put("Forecast", (Tag)list);
        ListTag next = new ListTag();
        Arrays.stream(this.nextForecast).forEach(w -> next.add((Object)StringTag.valueOf((String)w.toString())));
        nbt.put("NextForecast", (Tag)next);
        return nbt;
    }

    public record Date(int dayOfYear, int date, DayOfWeek day, Season season) {
        public static final StreamCodec<ByteBuf, Date> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Date::dayOfYear, (StreamCodec)ByteBufCodecs.INT, Date::date, StreamCodecUtils.ofEnum(DayOfWeek.class), Date::day, StreamCodecUtils.ofEnum(Season.class), Date::season, Date::new);
    }
}

