/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.data.farming;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.api.calendar.Weather;
import io.github.flemmli97.runecraftory.common.blocks.GiantCropBlock;
import io.github.flemmli97.runecraftory.common.blocks.util.GrowableCrop;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CFarmlandRemovePacket;
import io.github.flemmli97.runecraftory.common.network.S2CFarmlandUpdatePacket;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandData;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;

public class FarmlandHandler
extends SavedData {
    private static final String IDENTIFIER = "FarmlandData";
    private static final SavedData.Factory<FarmlandHandler> FACTORY = new SavedData.Factory(FarmlandHandler::new, FarmlandHandler::new, DataFixTypes.LEVEL);
    private static final int CHUNK_SECTION_SIZE = 4096;
    private final Map<ResourceKey<Level>, Long2ObjectMap<FarmlandData>> farmland = new HashMap<ResourceKey<Level>, Long2ObjectMap<FarmlandData>>();
    private final Map<ResourceKey<Level>, Long2ObjectMap<Set<FarmlandData>>> farmlandChunks = new HashMap<ResourceKey<Level>, Long2ObjectMap<Set<FarmlandData>>>();
    private final Map<ResourceKey<Level>, Long2ObjectMap<Set<FarmlandData>>> scheduledUpdates = new HashMap<ResourceKey<Level>, Long2ObjectMap<Set<FarmlandData>>>();
    private final Map<ResourceKey<Level>, Long2ObjectMap<Set<BlockPos>>> scheduledRemoveUpdates = new HashMap<ResourceKey<Level>, Long2ObjectMap<Set<BlockPos>>>();
    private final Map<ResourceKey<Level>, Set<PendingGiantCrops>> pendingGiantGrowth = new HashMap<ResourceKey<Level>, Set<PendingGiantCrops>>();
    private final Map<ResourceKey<Level>, Map<UUID, IrrigationPOI>> irrigationPOI = new HashMap<ResourceKey<Level>, Map<UUID, IrrigationPOI>>();
    private int lastUpdateDay;

    private FarmlandHandler() {
    }

    private FarmlandHandler(CompoundTag tag, HolderLookup.Provider provider) {
        this.load(tag);
    }

    public static FarmlandHandler get(MinecraftServer server) {
        return (FarmlandHandler)server.overworld().getDataStorage().computeIfAbsent(FACTORY, IDENTIFIER);
    }

    public static boolean isFarmBlock(BlockState state) {
        return state.is(RunecraftoryTags.Blocks.FARMLAND) && state.hasProperty((Property)FarmBlock.MOISTURE);
    }

    public static void waterLand(ServerLevel level, BlockPos pos, BlockState state) {
        level.sendParticles((ParticleOptions)ParticleTypes.FISHING, (double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, 4, 0.0, 0.01, 0.0, 0.1);
        level.setBlock(pos, (BlockState)state.setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7)), 3);
        level.playSound(null, pos, (SoundEvent)RuneCraftorySounds.GENERIC_FARM_LAND_WATER.get(), SoundSource.BLOCKS, 1.0f, 1.1f);
        BlockPos up = pos.above();
        BlockState crop = level.getBlockState(up);
        Block block = crop.getBlock();
        if (block instanceof GrowableCrop) {
            GrowableCrop blockCrop = (GrowableCrop)block;
            blockCrop.onWater((Level)level, up, crop);
        }
    }

    public static boolean canRainingAt(Level level, BlockPos position) {
        if (!level.canSeeSky(position)) {
            return false;
        }
        if (level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, position).getY() > position.getY()) {
            return false;
        }
        Biome biome = (Biome)level.getBiome(position).value();
        return biome.getPrecipitationAt(position) == Biome.Precipitation.RAIN && biome.warmEnoughToRain(position);
    }

    public static void sendChangesTo(ServerLevel level, ChunkPos pos, List<FarmlandData> data) {
        LoaderNetwork.INSTANCE.sendToTracking((CustomPacketPayload)new S2CFarmlandUpdatePacket(pos.toLong(), data), level, pos);
    }

    public static void onFarmRemoveChange(ServerLevel level, ChunkPos pos, List<BlockPos> data) {
        LoaderNetwork.INSTANCE.sendToTracking((CustomPacketPayload)new S2CFarmlandRemovePacket(pos.toLong(), data), level, pos);
    }

    public static void unloadChunk(ServerLevel level, ChunkPos pos) {
        LoaderNetwork.INSTANCE.sendToTracking((CustomPacketPayload)new S2CFarmlandRemovePacket(pos.toLong()), level, pos);
    }

    public static boolean isNearWater(LevelReader level, BlockPos pos) {
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, 0, -4), (BlockPos)pos.offset(4, 1, 4))) {
            if (!level.getFluidState(blockPos).is(FluidTags.WATER)) continue;
            return true;
        }
        return false;
    }

    public void onFarmlandPlace(ServerLevel level, BlockPos pos) {
        FarmlandData data = (FarmlandData)this.farmland.computeIfAbsent((ResourceKey<Level>)level.dimension(), old -> new Long2ObjectOpenHashMap()).computeIfAbsent(pos.asLong(), old -> new FarmlandData(pos));
        ((Set)this.farmlandChunks.computeIfAbsent((ResourceKey<Level>)level.dimension(), old -> new Long2ObjectOpenHashMap()).computeIfAbsent(new ChunkPos(pos).toLong(), old -> new HashSet())).add(data);
        data.updateFarmBlock(true);
        data.onLoad(level, false);
        this.scheduleUpdate(level, data);
        this.setDirty();
    }

    public void onFarmlandRemove(ServerLevel level, BlockPos pos) {
        FarmlandData data;
        Long2ObjectMap<FarmlandData> farms = this.farmland.get(level.dimension());
        if (farms != null && (data = (FarmlandData)farms.get(pos.asLong())) != null) {
            data.updateFarmBlock(false);
            this.scheduleRemoveUpdate(level, data);
            if (data.shouldBeRemoved()) {
                farms.remove(pos.asLong());
                ((Set)this.farmlandChunks.get(level.dimension()).get(new ChunkPos(pos).toLong())).remove(data);
            }
            this.setDirty();
        }
    }

    public void onChunkLoad(ServerLevel level, ChunkPos pos) {
        Set farms;
        Long2ObjectMap<Set<FarmlandData>> chunkFarms = this.farmlandChunks.get(level.dimension());
        if (chunkFarms != null && (farms = (Set)chunkFarms.get(pos.toLong())) != null) {
            farms.forEach(d -> {
                d.onLoad(level, true);
                this.scheduleUpdate(level, (FarmlandData)d);
            });
            this.setDirty();
        }
    }

    public void onChunkUnLoad(ServerLevel level, ChunkPos pos) {
        Long2ObjectMap<Set<FarmlandData>> chunkFarms = this.farmlandChunks.get(level.dimension());
        if (chunkFarms != null) {
            Set farms = (Set)chunkFarms.get(pos.toLong());
            if (farms != null) {
                farms.forEach(d -> d.onUnload(level));
                this.setDirty();
            }
            FarmlandHandler.unloadChunk(level, pos);
        }
    }

    public Optional<FarmlandData> getData(ServerLevel level, BlockPos pos) {
        Long2ObjectMap<FarmlandData> farms = this.farmland.get(level.dimension());
        if (farms != null) {
            return Optional.ofNullable((FarmlandData)farms.get(pos.asLong()));
        }
        return Optional.empty();
    }

    public void scheduleUpdate(ServerLevel level, FarmlandData data) {
        ((Set)this.scheduledUpdates.computeIfAbsent((ResourceKey<Level>)level.dimension(), key -> new Long2ObjectOpenHashMap()).computeIfAbsent(new ChunkPos(data.pos).toLong(), key -> new HashSet())).add(data);
    }

    public void scheduleRemoveUpdate(ServerLevel level, FarmlandData data) {
        ((Set)this.scheduledRemoveUpdates.computeIfAbsent((ResourceKey<Level>)level.dimension(), key -> new Long2ObjectOpenHashMap()).computeIfAbsent(new ChunkPos(data.pos).toLong(), key -> new HashSet())).add(data.pos);
    }

    public void scheduleGiantCropMerge(ServerLevel level, BlockPos pos, BlockState state) {
        Set set = this.pendingGiantGrowth.computeIfAbsent((ResourceKey<Level>)level.dimension(), key -> new HashSet());
        ArrayList<PendingGiantCrops> overlap = new ArrayList<PendingGiantCrops>();
        for (PendingGiantCrops pending : set) {
            if (pending.contains(pos)) {
                overlap.add(pending);
            }
            if (overlap.size() <= 1) continue;
            ((PendingGiantCrops)overlap.get(0)).add(pos, state);
            ((PendingGiantCrops)overlap.get(0)).combine((PendingGiantCrops)overlap.get(1));
            break;
        }
        if (!overlap.isEmpty()) {
            if (overlap.size() == 1) {
                ((PendingGiantCrops)overlap.get(0)).add(pos, state);
            } else {
                set.remove(overlap.get(1));
            }
            return;
        }
        PendingGiantCrops newData = new PendingGiantCrops();
        newData.add(pos, state);
        set.add(newData);
    }

    public void sendChangesTo(ServerPlayer player, ChunkPos pos) {
        Set farms;
        Long2ObjectMap<Set<FarmlandData>> chunkFarms = this.farmlandChunks.get(player.level().dimension());
        if (chunkFarms != null && (farms = (Set)chunkFarms.get(pos.toLong())) != null) {
            LoaderNetwork.INSTANCE.sendToTracking((CustomPacketPayload)new S2CFarmlandUpdatePacket(pos.toLong(), new ArrayList<FarmlandData>(farms)), (ServerLevel)player.level(), pos);
        }
    }

    public void addIrrigationPOI(ServerLevel level, UUID id, BlockPos pos) {
        MonsterCropIrrigation poi = new MonsterCropIrrigation(level.getGameTime(), pos);
        this.irrigationPOI.computeIfAbsent((ResourceKey<Level>)level.dimension(), old -> new HashMap()).put(id, poi);
        this.setDirty();
    }

    public void removeIrrigationPOI(ServerLevel level, UUID id) {
        Map<UUID, IrrigationPOI> map = this.irrigationPOI.get(level.dimension());
        if (map != null) {
            map.remove(id);
            this.setDirty();
        }
    }

    public boolean hasWater(ServerLevel level, BlockPos pos) {
        if (!GeneralConfig.unloadedFarmlandCheckWater || !GeneralConfig.disableFarmlandRandomtick && FarmlandHandler.isNearWater((LevelReader)level, pos)) {
            return true;
        }
        Map<UUID, IrrigationPOI> map = this.irrigationPOI.get(level.dimension());
        if (map != null) {
            for (IrrigationPOI poi : map.values()) {
                if (level.getGameTime() - poi.getStartTime() <= 1200L || !poi.isInside(pos)) continue;
                return true;
            }
        }
        return false;
    }

    public void tick(ServerLevel level) {
        if (WorldUtils.canUpdateDaily((Level)level, this.lastUpdateDay)) {
            ArrayList<ResourceKey> empty = new ArrayList<ResourceKey>();
            this.farmlandChunks.forEach((dim, m) -> {
                ServerLevel actualLevel = level.dimension().equals(dim) ? level : level.getServer().getLevel(dim);
                ArrayList<FarmlandData> removed = new ArrayList<FarmlandData>();
                LongArraySet toRemove = new LongArraySet();
                for (Long2ObjectMap.Entry entry : m.long2ObjectEntrySet()) {
                    if (entry.getValue() == null) {
                        toRemove.add(entry.getLongKey());
                        continue;
                    }
                    ((Set)entry.getValue()).removeIf(d -> {
                        d.tick(actualLevel, false);
                        boolean remove = d.shouldBeRemoved();
                        if (remove) {
                            removed.add((FarmlandData)d);
                        }
                        return remove;
                    });
                    if (!((Set)entry.getValue()).isEmpty()) continue;
                    toRemove.add(entry.getLongKey());
                }
                toRemove.forEach(arg_0 -> ((Long2ObjectMap)m).remove(arg_0));
                if (m.isEmpty()) {
                    empty.add((ResourceKey)dim);
                } else {
                    removed.forEach(d -> {
                        Long2ObjectMap<FarmlandData> land = this.farmland.get(dim);
                        if (land != null) {
                            land.remove(d.pos.asLong());
                        }
                    });
                }
            });
            empty.forEach(dim -> {
                this.farmland.remove(dim);
                this.farmlandChunks.remove(dim);
            });
            this.lastUpdateDay = WorldUtils.day((Level)level);
        }
        this.farmlandChunks.forEach((dim, m) -> {
            ServerLevel actualLevel;
            ServerLevel serverLevel = actualLevel = level.dimension().equals(dim) ? level : level.getServer().getLevel(dim);
            if (actualLevel != null) {
                this.randomTick(actualLevel, (Long2ObjectMap<Set<FarmlandData>>)m);
            }
        });
        this.scheduledUpdates.forEach((dim, m) -> {
            ServerLevel actualLevel;
            ServerLevel serverLevel = actualLevel = level.dimension().equals(dim) ? level : level.getServer().getLevel(dim);
            if (actualLevel != null) {
                m.forEach((l, data) -> FarmlandHandler.sendChangesTo(actualLevel, new ChunkPos(l.longValue()), new ArrayList<FarmlandData>((Collection<FarmlandData>)data)));
            }
        });
        this.scheduledUpdates.clear();
        this.scheduledRemoveUpdates.forEach((dim, m) -> {
            ServerLevel actualLevel;
            ServerLevel serverLevel = actualLevel = level.dimension().equals(dim) ? level : level.getServer().getLevel(dim);
            if (actualLevel != null) {
                m.forEach((l, data) -> FarmlandHandler.onFarmRemoveChange(actualLevel, new ChunkPos(l.longValue()), new ArrayList<BlockPos>((Collection<BlockPos>)data)));
            }
        });
        this.scheduledRemoveUpdates.clear();
        this.pendingGiantGrowth.forEach((dim, m) -> {
            ServerLevel actualLevel;
            ServerLevel serverLevel = actualLevel = level.dimension().equals(dim) ? level : level.getServer().getLevel(dim);
            if (actualLevel != null) {
                m.forEach(data -> data.tryMerge(actualLevel));
            }
        });
        this.pendingGiantGrowth.clear();
        this.setDirty();
    }

    private void randomTick(ServerLevel level, Long2ObjectMap<Set<FarmlandData>> m) {
        Weather weather = Calendar.get((Level)level).currentWeather();
        Consumer<FarmlandData> cons = null;
        int day = WorldUtils.day((Level)level);
        if (weather == Weather.STORM) {
            cons = d -> d.onStorming(level, day);
        } else if (level.isRaining()) {
            cons = d -> d.onWatering(level, day);
        }
        if (cons == null) {
            return;
        }
        int randomTickSpeed = level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
        Consumer<FarmlandData> finalCons = cons;
        m.forEach((packedChunk, data) -> {
            ArrayList list;
            if (data != null && !(list = new ArrayList(data)).isEmpty()) {
                int size = list.size();
                int chance = Mth.ceil((float)(4096.0f / (float)size));
                for (int l = 0; l < randomTickSpeed; ++l) {
                    if (level.random.nextInt(chance) != 0) continue;
                    finalCons.accept((FarmlandData)list.get(level.random.nextInt(size)));
                }
            }
        });
    }

    public void load(CompoundTag compoundTag) {
        this.lastUpdateDay = compoundTag.getInt("LastUpdateDay");
        CompoundTag farmTag = compoundTag.getCompound("Farms");
        farmTag.getAllKeys().forEach(levelKey -> {
            CompoundTag levelTag = farmTag.getCompound(levelKey);
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)levelKey));
            levelTag.getAllKeys().forEach(l -> {
                long packedPos = Long.parseLong(l);
                FarmlandData data = FarmlandData.fromTag(levelTag.getCompound(l), BlockPos.of((long)packedPos));
                this.addDataOnRead((ResourceKey<Level>)key, data);
            });
        });
        CompoundTag irrigationTag = compoundTag.getCompound("Irrigation");
        irrigationTag.getAllKeys().forEach(levelKey -> {
            CompoundTag t = irrigationTag.getCompound(levelKey);
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)levelKey));
            t.getAllKeys().forEach(uuidKey -> {
                UUID uuid = UUID.fromString(uuidKey);
                this.irrigationPOI.computeIfAbsent((ResourceKey<Level>)key, old -> new HashMap()).put(uuid, IrrigationPOI.load(t.getCompound(uuidKey)));
            });
        });
    }

    private void addDataOnRead(ResourceKey<Level> key, FarmlandData data) {
        this.farmland.computeIfAbsent(key, old -> new Long2ObjectOpenHashMap()).put(data.pos.asLong(), (Object)data);
        ((Set)this.farmlandChunks.computeIfAbsent(key, old -> new Long2ObjectOpenHashMap()).computeIfAbsent(new ChunkPos(data.pos).toLong(), old -> new HashSet())).add(data);
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        compoundTag.putInt("LastUpdateDay", this.lastUpdateDay);
        CompoundTag farmTag = new CompoundTag();
        this.farmland.forEach((key, map) -> {
            CompoundTag levelTag = new CompoundTag();
            map.forEach((l, data) -> levelTag.put(l.toString(), (Tag)data.save()));
            farmTag.put(key.location().toString(), (Tag)levelTag);
        });
        compoundTag.put("Farms", (Tag)farmTag);
        CompoundTag irrigationTag = new CompoundTag();
        this.irrigationPOI.forEach((key, map) -> {
            CompoundTag t = new CompoundTag();
            map.forEach((uuid, poi) -> t.put(uuid.toString(), (Tag)poi.save()));
            farmTag.put(key.location().toString(), (Tag)t);
        });
        compoundTag.put("Irrigation", (Tag)irrigationTag);
        return compoundTag;
    }

    public static class PendingGiantCrops {
        private static final PositionDirection[] OFFSETS = new PositionDirection[]{new PositionDirection(new BlockPos(1, 0, 0), Direction.WEST), new PositionDirection(new BlockPos(1, 0, 1), Direction.NORTH), new PositionDirection(new BlockPos(0, 0, 1), Direction.EAST)};
        private AABB inner;
        private AABB outer;
        private final Long2ObjectMap<BlockState> crops = new Long2ObjectOpenHashMap();

        public boolean contains(BlockPos pos) {
            return this.outer != null && this.outer.contains((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        }

        public void add(BlockPos pos, BlockState state) {
            this.crops.put(pos.asLong(), (Object)state);
            this.inner = this.inner == null ? new AABB(pos) : this.inner.minmax(new AABB(pos));
            this.outer = this.inner.inflate(1.0, 0.0, 1.0);
        }

        public void combine(PendingGiantCrops other) {
            this.inner = this.inner.minmax(other.inner);
            this.outer = this.inner.inflate(1.0, 0.0, 1.0);
            this.crops.putAll(other.crops);
        }

        public void tryMerge(ServerLevel level) {
            int minX = Mth.floor((double)this.inner.minX);
            int minZ = Mth.floor((double)this.inner.minZ);
            int y = Mth.floor((double)this.inner.minY);
            int maxX = Mth.floor((double)(this.inner.maxX - 1.0));
            int maxZ = Mth.floor((double)(this.inner.maxZ - 1.0));
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    BlockState s = (BlockState)this.crops.get(BlockPos.asLong((int)x, (int)y, (int)z));
                    if (s == null) continue;
                    BlockPos p = new BlockPos(x, y, z);
                    ArrayList<Pair> list = new ArrayList<Pair>();
                    if (s.getBlock() instanceof GiantCropBlock) {
                        s = (BlockState)s.setValue(GiantCropBlock.DIRECTION, (Comparable)Direction.SOUTH);
                    }
                    for (PositionDirection offset : OFFSETS) {
                        BlockPos newPos = p.offset((Vec3i)offset.pos());
                        BlockState s2 = (BlockState)this.crops.get(newPos.asLong());
                        if (s2 == null || !s2.is(s.getBlock())) continue;
                        if (s2.getBlock() instanceof GiantCropBlock) {
                            s2 = (BlockState)s2.setValue(GiantCropBlock.DIRECTION, (Comparable)offset.direction());
                        }
                        list.add(Pair.of((Object)newPos, (Object)s2));
                    }
                    list.add(Pair.of((Object)p, (Object)s));
                    if (list.size() != 4) continue;
                    for (Pair pair : list) {
                        this.crops.remove(((BlockPos)pair.getFirst()).asLong());
                        level.setBlock((BlockPos)pair.getFirst(), (BlockState)pair.getSecond(), 3);
                    }
                }
            }
        }
    }

    public record MonsterCropIrrigation(long startTime, BlockPos pos) implements IrrigationPOI
    {
        public static final String ID = "MonsterIrrigation";

        public MonsterCropIrrigation(CompoundTag tag) {
            this(tag.getLong("Start"), (BlockPos)BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("Pos")).getOrThrow());
        }

        @Override
        public long getStartTime() {
            return this.startTime;
        }

        @Override
        public boolean isInside(BlockPos pos) {
            int radius = MobConfig.farmRadius;
            int dX = this.pos.getX() - pos.getX();
            int dY = this.pos.getY() - pos.getY();
            int dZ = this.pos.getZ() - pos.getZ();
            return Math.abs(dY) < 2 && Math.abs(dX) < radius && Math.abs(dZ) < radius;
        }

        @Override
        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.putString("ID", ID);
            tag.putLong("Start", this.getStartTime());
            tag.put("Pos", (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.pos).getOrThrow());
            return tag;
        }
    }

    public static interface IrrigationPOI {
        public static IrrigationPOI load(CompoundTag tag) {
            String id = tag.getString("ID");
            if (id.equals("MonsterIrrigation")) {
                return new MonsterCropIrrigation(tag);
            }
            throw new IllegalStateException("Couldn't parse!");
        }

        public long getStartTime();

        public boolean isInside(BlockPos var1);

        public CompoundTag save();
    }

    record PositionDirection(BlockPos pos, Direction direction) {
    }
}

