/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.integration.top;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.player.XpLevelHolder;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.world.data.BarnData;
import java.util.UUID;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.UsernameCache;

public class EntityProbeProvider
implements IProbeInfoEntityProvider {
    public static final ResourceLocation ID = RuneCraftory.modRes("entity_provider");

    public String getID() {
        return String.format("%s/%s", ID.getNamespace(), ID.getPath());
    }

    public void addProbeEntityInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, Entity entity, IProbeHitEntityData iProbeHitEntityData) {
        BaseMonster monster;
        block11: {
            IBaseMob mob;
            block12: {
                if (!(entity instanceof IBaseMob)) break block11;
                mob = (IBaseMob)entity;
                if (probeMode == ProbeMode.DEBUG || player.getMainHandItem().getItem() == RuneCraftoryItems.DEBUG.get() || player.isCreative()) break block12;
                if (!(entity instanceof OwnableEntity)) break block11;
                OwnableEntity ownable = (OwnableEntity)entity;
                if (!player.getUUID().equals(ownable.getOwnerUUID())) break block11;
            }
            XpLevelHolder entityLevel = mob.xpLevel();
            probeInfo.progress((int)entityLevel.getXp(), LevelCalc.xpAmountForLevelUp(entityLevel.getLevel()), probeInfo.defaultProgressStyle().width(150).height(12).color(-16777216, -15955563, -15955563, -7631989).alignment(ElementAlignment.ALIGN_CENTER).prefix((Component)Component.translatable((String)"runecraftory.tooltip.item.level", (Object[])new Object[]{mob.xpLevel().getLevel()})).numberFormat(NumberFormat.NONE));
        }
        if (entity instanceof BaseMonster && (monster = (BaseMonster)entity).getOwnerUUID() != null) {
            String username = UsernameCache.getLastKnownUsername((UUID)monster.getOwnerUUID());
            if (username == null) {
                probeInfo.text(CompoundText.create().warning((Component)Component.translatable((String)"runecraftory.dependency.tooltips.owner.none")));
            } else {
                probeInfo.text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text((Component)Component.translatable((String)"runecraftory.dependency.tooltips.owner", (Object[])new Object[]{username})));
            }
            if (player.getUUID().equals(monster.getOwnerUUID())) {
                EntityProbeProvider.withText(probeInfo, "runecraftory.dependency.tooltips.friendpoints", (Component)Component.literal((String)("" + monster.friendPoints(player))), ChatFormatting.YELLOW);
                BarnData barn = monster.getAssignedBarn();
                if (barn != null) {
                    EntityProbeProvider.withText(probeInfo, "runecraftory.dependency.tooltips.barn", (Component)Component.literal((String)String.format("[%s, %s, %s]", barn.pos.pos().getX(), barn.pos.pos().getY(), barn.pos.pos().getZ())), ChatFormatting.GREEN);
                } else {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text((Component)Component.translatable((String)"runecraftory.dependency.tooltips.barn.no")));
                }
                EntityProbeProvider.withText(probeInfo, "runecraftory.dependency.tooltips.behaviour", (Component)Component.literal((String)String.valueOf((Object)monster.behaviourState())), ChatFormatting.YELLOW);
            }
        }
        if (entity instanceof NPCEntity) {
            NPCEntity npc = (NPCEntity)entity;
            if (npc.followEntity() != null) {
                EntityProbeProvider.withText(probeInfo, "runecraftory.dependency.tooltips.npc.follow", npc.followEntity().getDisplayName(), ChatFormatting.YELLOW);
            }
            EntityProbeProvider.withText(probeInfo, "runecraftory.dependency.tooltips.friendpoints", (Component)Component.literal((String)("" + npc.friendPoints(player))), ChatFormatting.YELLOW);
        }
    }

    private static void withText(IProbeInfo info, String main, Component other, ChatFormatting formatting) {
        info.text(CompoundText.create().info((Component)Component.translatable((String)main, (Object[])new Object[]{Component.literal((String)("\u00a7" + formatting.getChar())).append(other)})));
    }
}

