/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.jade;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.player.XpLevelHolder;
import io.github.flemmli97.runecraftory.common.blocks.MonsterBarnBlock;
import io.github.flemmli97.runecraftory.common.blocks.TreeBaseBlock;
import io.github.flemmli97.runecraftory.common.blocks.entity.MonsterBarnBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.entity.TreeBlockEntity;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.world.data.BarnData;
import io.github.flemmli97.tenshilib.common.entity.MultiPartEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.ui.ProgressElement;
import snownee.jade.impl.ui.SimpleProgressStyle;

@WailaPlugin
public class JadePlugin
implements IWailaPlugin {
    private static final ResourceLocation ID = RuneCraftory.modRes("jade_entity_plugin");
    private static final ResourceLocation BARN_BLOCK_PLUGIN = RuneCraftory.modRes("jade_barn_block_plugin");
    private static final ResourceLocation TREE_BLOCK_PLUGIN = RuneCraftory.modRes("jade_tree_block_plugin");

    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)new IServerDataProvider<BlockAccessor>(this){

            public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
                MonsterBarnBlockEntity barn;
                BarnData data;
                BlockEntity blockEntity = accessor.getBlockEntity();
                if (blockEntity instanceof MonsterBarnBlockEntity && (data = (barn = (MonsterBarnBlockEntity)blockEntity).getBarnData()) != null) {
                    compoundTag.putBoolean("Roof", data.hasRoof());
                    compoundTag.putInt("RoofHeight", data.roofHeight());
                    compoundTag.putInt("Size", data.getSize());
                    compoundTag.putInt("Used", data.usedCapacity());
                    compoundTag.putInt("Capacity", data.getCapacity());
                }
            }

            public ResourceLocation getUid() {
                return BARN_BLOCK_PLUGIN;
            }
        }, MonsterBarnBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)new IServerDataProvider<BlockAccessor>(this){

            public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
                BlockEntity blockEntity = accessor.getBlockEntity();
                if (blockEntity instanceof TreeBlockEntity) {
                    TreeBlockEntity tree = (TreeBlockEntity)blockEntity;
                    compoundTag.putInt("Health", tree.getHealth());
                }
            }

            public ResourceLocation getUid() {
                return TREE_BLOCK_PLUGIN;
            }
        }, TreeBaseBlock.class);
        registration.registerEntityDataProvider((IServerDataProvider)new IServerDataProvider<EntityAccessor>(this){

            public void appendServerData(CompoundTag compoundTag, EntityAccessor accessor) {
                BaseMonster monster;
                Player player;
                Entity entity;
                block11: {
                    IBaseMob mob;
                    block12: {
                        entity = accessor.getEntity();
                        player = accessor.getPlayer();
                        if (!(entity instanceof IBaseMob)) break block11;
                        mob = (IBaseMob)entity;
                        if (player.getMainHandItem().getItem() == RuneCraftoryItems.DEBUG.get() || player.isCreative()) break block12;
                        if (!(entity instanceof OwnableEntity)) break block11;
                        OwnableEntity ownable = (OwnableEntity)entity;
                        if (!player.getUUID().equals(ownable.getOwnerUUID())) break block11;
                    }
                    XpLevelHolder entityLevel = mob.xpLevel();
                    compoundTag.putFloat("RunecraftoryLevelPerc", entityLevel.getProgress());
                    compoundTag.putInt("RunecraftoryLevel", entityLevel.getLevel());
                }
                if (entity instanceof BaseMonster && (monster = (BaseMonster)entity).getOwnerUUID() != null) {
                    String username = player.getServer().getProfileCache().get(monster.getOwnerUUID()).map(GameProfile::getName).orElse(null);
                    if (username == null) {
                        compoundTag.putBoolean("HasUsername", false);
                    } else {
                        compoundTag.putBoolean("HasUsername", true);
                        compoundTag.putString("Username", username);
                    }
                    if (player.getUUID().equals(monster.getOwnerUUID())) {
                        compoundTag.putInt("FP", monster.friendPoints(player));
                        BarnData barn = monster.getAssignedBarn();
                        if (barn != null) {
                            compoundTag.putBoolean("HasBarn", true);
                            compoundTag.put("Barn", (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)barn.pos.pos()).getOrThrow());
                        } else {
                            compoundTag.putBoolean("HasBarn", false);
                        }
                        compoundTag.putString("Behaviour", monster.behaviourState().toString());
                    }
                }
                if (entity instanceof NPCEntity) {
                    NPCEntity npc = (NPCEntity)entity;
                    if (npc.followEntity() != null) {
                        compoundTag.put("NPCFollow", (Tag)ComponentSerialization.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)npc.followEntity().getDisplayName()).getOrThrow());
                    }
                    compoundTag.putInt("FP", npc.friendPoints(player));
                }
            }

            public ResourceLocation getUid() {
                return ID;
            }
        }, Mob.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
                CompoundTag tag = blockAccessor.getServerData();
                if (blockAccessor.getBlockEntity() instanceof MonsterBarnBlockEntity) {
                    MutableComponent sizeText;
                    int size = tag.getInt("Size");
                    MutableComponent mutableComponent = sizeText = size > 1 ? Component.literal((String)("" + size)).withStyle(ChatFormatting.GREEN) : Component.literal((String)("" + size)).withStyle(ChatFormatting.DARK_RED);
                    if (!tag.getBoolean("Roof")) {
                        iTooltip.add((Component)Component.translatable((String)"runecraftory.dependency.tooltips.barn.1", (Object[])new Object[]{sizeText}));
                    } else {
                        iTooltip.add((Component)Component.translatable((String)"runecraftory.dependency.tooltips.barn.1.alt", (Object[])new Object[]{Component.translatable((String)("" + tag.getInt("RoofHeight"))).withStyle(ChatFormatting.YELLOW), sizeText}));
                    }
                    iTooltip.add((Component)Component.translatable((String)"runecraftory.dependency.tooltips.barn.2", (Object[])new Object[]{tag.getInt("Used"), tag.getInt("Capacity")}));
                }
            }

            public ResourceLocation getUid() {
                return BARN_BLOCK_PLUGIN;
            }
        }, MonsterBarnBlock.class);
        registration.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
                CompoundTag tag = blockAccessor.getServerData();
                if (blockAccessor.getBlockEntity() instanceof TreeBlockEntity) {
                    iTooltip.add((Component)Component.translatable((String)"runecraftory.dependency.tooltips.tree", (Object[])new Object[]{tag.getInt("Health")}));
                }
            }

            public ResourceLocation getUid() {
                return TREE_BLOCK_PLUGIN;
            }
        }, TreeBaseBlock.class);
        registration.addRayTraceCallback((hitResult, accessor, origin) -> {
            MultiPartEntity entity;
            EntityAccessor entityAccessor;
            Entity patt0$temp;
            if (accessor instanceof EntityAccessor && (patt0$temp = (entityAccessor = (EntityAccessor)accessor).getEntity()) instanceof MultiPartEntity && BuiltInRegistries.ENTITY_TYPE.getKey((Object)(entity = (MultiPartEntity)patt0$temp).getType()).getNamespace().equals("runecraftory")) {
                accessor = registration.entityAccessor().from(entityAccessor).entity((Entity)entity.getOwner()).build();
                return accessor;
            }
            return accessor;
        });
        registration.registerEntityComponent((IComponentProvider)new IEntityComponentProvider(this){

            public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
                BaseMonster monster;
                Entity lvl2;
                CompoundTag tag = entityAccessor.getServerData();
                if (tag.contains("RunecraftoryLevel")) {
                    float prog = tag.getFloat("RunecraftoryLevelPerc");
                    int lvl2 = tag.getInt("RunecraftoryLevel");
                    iTooltip.add((IElement)new ProgressElement(prog, (Component)Component.translatable((String)"runecraftory.tooltip.item.level", (Object[])new Object[]{lvl2}).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW}), new SimpleProgressStyle().color(-12674274, -10965189), BoxStyle.getNestedBox(), true));
                }
                if ((lvl2 = entityAccessor.getEntity()) instanceof BaseMonster && (monster = (BaseMonster)lvl2).getOwnerUUID() != null) {
                    if (!tag.getBoolean("HasUsername")) {
                        iTooltip.add((Component)Component.translatable((String)"runecraftory.dependency.tooltips.owner.none").withStyle(ChatFormatting.YELLOW));
                    } else {
                        String username = tag.getString("Username");
                        iTooltip.add((Component)Component.translatable((String)"runecraftory.dependency.tooltips.owner", (Object[])new Object[]{username}).withStyle(ChatFormatting.GOLD));
                    }
                    if (entityAccessor.getPlayer().getUUID().equals(monster.getOwnerUUID())) {
                        JadePlugin.withText(iTooltip, "runecraftory.dependency.tooltips.friendpoints", (Component)Component.literal((String)("" + tag.getInt("FP"))), ChatFormatting.YELLOW, new ChatFormatting[0]);
                        if (tag.getBoolean("HasBarn")) {
                            BlockPos pos = (BlockPos)BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("Barn")).getOrThrow();
                            JadePlugin.withText(iTooltip, "runecraftory.dependency.tooltips.barn", (Component)Component.literal((String)String.format("[%s, %s, %s]", pos.getX(), pos.getY(), pos.getZ())), ChatFormatting.GREEN, new ChatFormatting[0]);
                        } else {
                            iTooltip.add((Component)Component.translatable((String)"runecraftory.dependency.tooltips.barn.no").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
                        }
                        JadePlugin.withText(iTooltip, "runecraftory.dependency.tooltips.behaviour", (Component)Component.literal((String)tag.getString("Behaviour")), ChatFormatting.YELLOW, new ChatFormatting[0]);
                    }
                }
                if (entityAccessor.getEntity() instanceof NPCEntity) {
                    if (tag.contains("NPCFollow")) {
                        JadePlugin.withText(iTooltip, "runecraftory.dependency.tooltips.npc.follow", (Component)ComponentSerialization.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("NPCFollow")).getOrThrow(), ChatFormatting.YELLOW, new ChatFormatting[0]);
                    }
                    JadePlugin.withText(iTooltip, "runecraftory.dependency.tooltips.friendpoints", (Component)Component.literal((String)("" + tag.getInt("FP"))), ChatFormatting.YELLOW, new ChatFormatting[0]);
                }
            }

            public ResourceLocation getUid() {
                return ID;
            }
        }, Mob.class);
    }

    private static void withText(ITooltip tooltip, String key, Component other, ChatFormatting formatting, ChatFormatting ... main) {
        Component component;
        Object[] objectArray = new Object[1];
        if (other instanceof MutableComponent) {
            MutableComponent mut = (MutableComponent)other;
            component = mut.withStyle(formatting);
        } else {
            component = other;
        }
        objectArray[0] = component;
        tooltip.add((Component)Component.translatable((String)key, (Object[])objectArray).withStyle(main));
    }
}

