/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixinhelper;

import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryArmorEffects;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixin.CropBlockAccessor;
import io.github.flemmli97.runecraftory.mixinhelper.PrevEntityPosition;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class MixinUtils {
    public static boolean playerPose(Player player) {
        PlayerData data = Platform.INSTANCE.getPlayerData(player);
        Pose pose = data.getWeaponHandler().getCurrentAction().getPose((LivingEntity)player, data.getWeaponHandler());
        if (pose != null) {
            if (player.getPose() != pose) {
                player.setPose(pose);
            }
            return true;
        }
        return false;
    }

    public static void onPlayerThrowItem(Player player, ItemEntity entity) {
        if (!player.isDeadOrDying()) {
            entity.setThrower((Entity)player);
            PrevEntityPosition pos = (PrevEntityPosition)player;
            double dX = player.getX() - pos.runecraftory$getOldPlayerX();
            double dZ = player.getZ() - pos.runecraftory$getOldPlayerZ();
            double spd = dX * dX + dZ * dZ;
            if (spd > 0.01) {
                double scale = ArmorEffect.hasArmorEffect((LivingEntity)player, (Holder<ArmorEffect>)RuneCraftoryArmorEffects.THROWING_RING.asHolder()) ? 2.5 : 1.7;
                entity.setDeltaMovement(entity.getDeltaMovement().scale(scale));
            }
        }
    }

    public static boolean handleEntityCollision(ItemEntity entity) {
        if (entity.isInWater() || entity.isInLava() || entity.getOwner() == null || entity.level().isClientSide) {
            return true;
        }
        HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)entity, t -> MixinUtils.canHitEntity(entity, t));
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            return true;
        }
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            EntityHitResult result = (EntityHitResult)hitResult;
            Entity entity2 = result.getEntity();
            if (entity2 instanceof IBaseMob) {
                Player thrower;
                IBaseMob mob = (IBaseMob)entity2;
                ItemStack stack = entity.getItem();
                Entity e = entity.getOwner();
                if (e instanceof Player && mob.onGivingItem(thrower = (Player)e, stack) && stack.isEmpty()) {
                    entity.discard();
                }
            }
            return true;
        }
        return false;
    }

    protected static boolean canHitEntity(ItemEntity entity, Entity target) {
        Entity owner;
        if (target.isSpectator() || !target.isAlive() || !target.isPickable() || (owner = entity.getOwner()) == null) {
            return false;
        }
        return !target.getUUID().equals(owner.getUUID());
    }

    public static void onBlockStateChange(ServerLevel level, BlockPos pos, BlockState blockState, BlockState newState) {
        if (FarmlandHandler.isFarmBlock(newState)) {
            if (!FarmlandHandler.isFarmBlock(blockState) || FarmlandHandler.get(level.getServer()).getData(level, pos).isEmpty()) {
                FarmlandHandler.get(level.getServer()).onFarmlandPlace(level, pos);
            }
        } else if (FarmlandHandler.isFarmBlock(blockState)) {
            FarmlandHandler.get(level.getServer()).onFarmlandRemove(level, pos);
        } else {
            Block block = blockState.getBlock();
            if (block instanceof CropBlock) {
                CropBlock pre = (CropBlock)block;
                Block block2 = newState.getBlock();
                if (!(block2 instanceof CropBlock)) {
                    FarmlandHandler.get(level.getServer()).getData(level, pos.below()).ifPresent(d -> d.onCropRemove(level, pos, newState));
                } else {
                    CropBlock post = (CropBlock)block2;
                    if ((Integer)blockState.getValue((Property)((CropBlockAccessor)pre).cropAgeProperty()) > (Integer)newState.getValue((Property)((CropBlockAccessor)post).cropAgeProperty())) {
                        FarmlandHandler.get(level.getServer()).getData(level, pos.below()).ifPresent(d -> d.onRegrowableHarvest(level, pos, newState));
                    }
                }
            }
        }
    }

    public static void recheckFarmland(ServerLevel level, BlockState state, BlockPos pos) {
        if (FarmlandHandler.get(level.getServer()).getData(level, pos).map(d -> !d.isFarmBlock()).orElse(true).booleanValue()) {
            FarmlandHandler.get(level.getServer()).onFarmlandPlace(level, pos);
        }
    }

    public static void triggerArmorStepEffect(LivingEntity living) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            ItemStack stack = living.getItemBySlot(slot);
            ArmorEffect.runArmorEffectFor(stack, effect -> effect.onStep(living, stack));
        }
    }
}

