/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.neoforge.data;

import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.SoundDefinition;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;

public class SoundGen
extends SoundDefinitionsProvider {
    public SoundGen(PackOutput packOutput, ExistingFileHelper helper) {
        super(packOutput, "runecraftory", helper);
    }

    public void registerSounds() {
        for (RegistryEntrySupplier sup : RuneCraftorySounds.SOUND_EVENTS.getEntries()) {
            if (RuneCraftorySounds.BGM.stream().anyMatch(h -> h.sound().equals((Object)sup))) continue;
            RuneCraftorySounds.SoundHolder data = RuneCraftorySounds.SOUND_DATA.get(sup.getID());
            if (data != null) {
                this.add((SoundEvent)sup.get(), data.location(), data.amount(), data.pitch());
                continue;
            }
            this.add((SoundEvent)sup.get());
        }
        for (RuneCraftorySounds.BGMHolder bgm : RuneCraftorySounds.BGM) {
            this.addBgmWith((SoundEvent)bgm.sound().get(), bgm.bgm().location());
        }
    }

    private void add(SoundEvent event) {
        this.add(event, event.getLocation(), 1, 1.0f);
    }

    private void add(SoundEvent event, ResourceLocation path, int num, float pitch) {
        SoundDefinition def = SoundGen.definition().subtitle(event.getLocation().toString());
        if (num <= 1) {
            def.with(SoundDefinition.Sound.sound((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)path.getNamespace(), (String)path.getPath().replace(".", "/")), (SoundDefinition.SoundType)SoundDefinition.SoundType.SOUND).pitch(pitch));
        } else {
            for (int i = 0; i < num; ++i) {
                def.with(SoundDefinition.Sound.sound((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)path.getNamespace(), (String)(path.getPath().replace(".", "/") + (i + 1))), (SoundDefinition.SoundType)SoundDefinition.SoundType.SOUND).pitch(pitch));
            }
        }
        this.add(event, def);
    }

    private void addBgmWith(SoundEvent event) {
        this.addBgmWith(event, ResourceLocation.fromNamespaceAndPath((String)event.getLocation().getNamespace(), (String)event.getLocation().getPath().replace(".", "/")));
    }

    private void addBgmWith(SoundEvent event, ResourceLocation sound) {
        this.add(event, SoundGen.definition().subtitle(event.getLocation().toString()).with(SoundDefinition.Sound.sound((ResourceLocation)sound, (SoundDefinition.SoundType)SoundDefinition.SoundType.SOUND).stream()));
    }
}

