/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.platform;

import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.creativetab.SubTab;
import io.github.flemmli97.tenshilib.loader.LoaderInitializer;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.function.TriFunction;

public interface Platform {
    public static final Platform INSTANCE = (Platform)LoaderInitializer.getImplInstance(Platform.class, (String[])new String[]{"io.github.flemmli97.runecraftory.fabric.platform.PlatformImpl", "io.github.flemmli97.runecraftory.neoforge.platform.PlatformImpl"});

    public PlayerData getPlayerData(Player var1);

    public EntityData getEntityData(LivingEntity var1);

    public void openGuiMenu(ServerPlayer var1, MenuProvider var2);

    default public void openGuiMenu(ServerPlayer player, MenuProvider provider, BlockPos pos) {
        this.openGuiMenu(player, provider, (RegistryFriendlyByteBuf b) -> BlockPos.STREAM_CODEC.encode(b, (Object)pos));
    }

    public void openGuiMenu(ServerPlayer var1, MenuProvider var2, Consumer<RegistryFriendlyByteBuf> var3);

    public boolean canEquip(ItemStack var1, EquipmentSlot var2, LivingEntity var3);

    public SoundType getSoundType(BlockState var1, Level var2, BlockPos var3, Entity var4);

    public <T extends AbstractContainerMenu> MenuType<T> menuType(BiFunction<Integer, Inventory, T> var1);

    public <T extends AbstractContainerMenu, D> MenuType<T> menuType(TriFunction<Integer, Inventory, D, T> var1, StreamCodec<RegistryFriendlyByteBuf, D> var2);

    public CreativeModeTab.Builder tabBuilder(List<SubTab> var1);

    public boolean matchingInventory(BlockEntity var1, Predicate<ItemStack> var2);

    public ItemStack findMatchingItem(BlockEntity var1, Predicate<ItemStack> var2, int var3);

    public ItemStack insertInto(BlockEntity var1, ItemStack var2);

    public void cropGrowEventPost(Level var1, BlockPos var2, BlockState var3);

    public void craftingEvent(Player var1, ItemStack var2, Container var3);

    public void destroyItem(Player var1, ItemStack var2, InteractionHand var3);

    public boolean entityTickPre(LivingEntity var1);

    public boolean checkSpawnPosition(Mob var1, ServerLevel var2, MobSpawnType var3);
}

