/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.action;

import com.google.common.collect.ImmutableList;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import java.util.ArrayList;
import java.util.List;

public class PlayerModelAnimations {
    private static final List<AnimatedAction> ALL = new ArrayList<AnimatedAction>();
    public static final List<AnimatedAction> SHORT_SWORD = PlayerModelAnimations.addTo(6, "short_sword", (count, builder) -> switch (count) {
        case 2 -> builder.apply(0.52).marker("attack", new double[]{0.32}).marker("step", new double[]{0.24}).marker("done", new double[]{0.4}).build();
        case 3 -> builder.apply(0.52).marker("attack", new double[]{0.4}).marker("step", new double[]{0.24}).marker("done", new double[]{0.4}).build();
        case 4 -> builder.apply(0.48).marker("attack", new double[]{0.28}).marker("step", new double[]{0.28}).marker("done", new double[]{0.36}).build();
        case 5 -> builder.apply(0.48).marker("attack", new double[]{0.36}).marker("step", new double[]{0.16}).marker("done", new double[]{0.36}).build();
        case 6 -> builder.apply(1.68).marker("spin_start", new double[]{0.28}).marker("spin_end", new double[]{1.04}).marker("reset", new double[]{0.48, 0.72}).build();
        default -> builder.apply(0.52).marker("attack", new double[]{0.36}).marker("step", new double[]{0.28}).marker("done", new double[]{0.4}).build();
    });
    public static final AnimatedAction SHORT_SWORD_USE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)0.8, (String)"short_sword_use").marker("attack", new double[]{0.4}).build());
    public static final List<AnimatedAction> LONG_SWORD = PlayerModelAnimations.addTo(4, "long_sword", (count, builder) -> switch (count) {
        case 2 -> builder.apply(0.76).marker("attack", new double[]{0.56}).marker("step", new double[]{0.44}).marker("done", new double[]{0.64}).build();
        case 3 -> builder.apply(0.76).marker("attack", new double[]{0.64}).marker("step", new double[]{0.36}).marker("done", new double[]{0.64}).build();
        case 4 -> builder.apply(1.64).marker("spin_start", new double[]{0.2}).marker("spin_end", new double[]{1.56}).marker("reset", new double[]{0.72}).build();
        default -> builder.apply(0.76).marker("attack", new double[]{0.52}).marker("done", new double[]{0.64}).build();
    });
    public static final AnimatedAction LONG_SWORD_USE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)0.72, (String)"long_sword_use").marker("attack", new double[]{0.44}).build());
    public static final List<AnimatedAction> SPEAR = PlayerModelAnimations.addTo(5, "spear", (count, builder) -> switch (count) {
        case 2 -> builder.apply(0.6).marker("attack", new double[]{0.36}).marker("step", new double[]{0.36}).marker("done", new double[]{0.48}).build();
        case 5 -> builder.apply(2.24).marker("spin_start", new double[]{0.2}).marker("spin_end", new double[]{1.32}).marker("reset", new double[]{0.56, 0.92}).marker("leap", new double[]{1.48}).marker("leap_end", new double[]{1.84}).marker("slam", new double[]{1.96}).build();
        default -> builder.apply(0.6).marker("attack", new double[]{0.44}).marker("step", new double[]{0.48}).marker("done", new double[]{0.48}).build();
    });
    public static final AnimatedAction SPEAR_USE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.28, (String)"spear_use").marker("attack", new double[]{0.36}).marker("end_continue", new double[]{0.52}).marker("final", new double[]{1.04}).marker("chain_offset", new double[]{0.25}).build());
    public static final List<AnimatedAction> HAMMER_AXE = PlayerModelAnimations.addTo(3, "hammer_axe", (count, builder) -> count == 3 ? builder.apply(1.64).marker("spin_start", new double[]{0.44}).marker("spin_middle", new double[]{0.96}).marker("spin_end", new double[]{1.52}).marker("reset", new double[]{0.96}).marker("leap", new double[]{0.32}).build() : builder.apply(0.92).marker("attack", new double[]{0.8}).marker("done", new double[]{0.8}).build());
    public static final AnimatedAction HAMME_AXE_USE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.12, (String)"hammer_axe_use").marker("attack", new double[]{0.76}).marker("jump", new double[]{0.36}).build());
    public static final List<AnimatedAction> DUAL_BLADES = PlayerModelAnimations.addTo(8, "dual_blades", (count, builder) -> switch (count) {
        case 2, 3, 4 -> builder.apply(0.44).marker("attack", new double[]{0.32}).marker("step", new double[]{0.28}).marker("done", new double[]{0.32}).build();
        case 5 -> builder.apply(0.44).marker("spin_start", new double[]{0.08}).marker("spin_end", new double[]{0.32}).marker("step", new double[]{0.24}).marker("done", new double[]{0.32}).build();
        case 6 -> builder.apply(0.44).marker("spin_start", new double[]{0.05}).marker("spin_end", new double[]{0.32}).marker("reset", new double[]{0.16}).marker("step", new double[]{0.24}).marker("done", new double[]{0.32}).build();
        case 7 -> builder.apply(0.52).marker("leap", new double[]{0.12}).marker("down", new double[]{0.24}).marker("attack", new double[]{0.28}).marker("done", new double[]{0.4}).build();
        case 8 -> builder.apply(1.72).marker("spin_start", new double[]{0.28}).marker("spin_end", new double[]{1.28}).marker("reset", new double[]{0.6, 0.84, 1.08}).marker("last", new double[]{1.08}).build();
        default -> builder.apply(0.44).marker("attack", new double[]{0.32}).marker("step", new double[]{0.24}).marker("done", new double[]{0.32}).build();
    });
    public static final AnimatedAction DUAL_BLADES_USE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)0.76, (String)"dual_blades_use").marker("attack", new double[]{0.36}).build());
    public static final List<AnimatedAction> GLOVES = PlayerModelAnimations.addTo(5, "glove", (count, builder) -> switch (count) {
        case 4 -> builder.apply(0.76).marker("jump", new double[]{0.24}).marker("down", new double[]{0.4}).marker("attack", new double[]{0.56}).build();
        case 5 -> builder.apply(1.32).marker("leap", new double[]{0.16}).marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{0.88}).build();
        default -> builder.apply(0.48).marker("attack", new double[]{0.36}).marker("step", new double[]{0.28}).marker("done", new double[]{0.36}).build();
    });
    public static final AnimatedAction GLOVES_USE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.68, (String)"glove_use").marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{1.4}).marker("reset", new double[]{0.44, 0.6, 0.76, 0.92, 1.08, 1.24, 1.32}).build());
    public static final List<AnimatedAction> STAFF = PlayerModelAnimations.addTo(2, "staff", (count, builder) -> count == 2 ? builder.apply(0.72).marker("attack", new double[]{0.52}).build() : builder.apply(0.84).marker("attack", new double[]{0.72}).marker("done", new double[]{0.72}).build());
    public static final AnimatedAction STAFF_USE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)0.88, (String)"staff_use").marker("attack", new double[]{0.52}).build());
    public static final AnimatedAction WATER_LASER_ONE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)2.92, (String)"water_laser_one").marker("attack", new double[]{0.52}).marker("continue", new double[]{0.67}).build());
    public static final AnimatedAction WATER_LASER_TWO = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.72, (String)"water_laser_two").marker("attack", new double[]{0.52}).marker("continue", new double[]{0.67}).build());
    public static final AnimatedAction WATER_LASER_THREE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.12, (String)"water_laser_three").marker("attack", new double[]{0.52}).marker("continue", new double[]{0.67}).build());
    public static final AnimatedAction WATER_LASER_END = PlayerModelAnimations.addTo(AnimatedAction.builder((double)0.28, (String)"water_laser_end").build());
    public static final AnimatedAction POWER_WAVE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)0.72, (String)"power_wave").marker("attack", new double[]{0.32}).marker("step", new double[]{0.32}).build());
    public static final List<AnimatedAction> DASH_SLASH = PlayerModelAnimations.addTo(2, "dash_slash", (count, builder) -> count == 2 ? builder.apply(0.64).marker("attack", new double[]{0.44}).build() : builder.apply(0.96).marker("move_start", new double[]{0.28}).marker("sound", new double[]{0.44}).marker("attack_start", new double[]{0.32}).marker("attack_end", new double[]{0.8}).build());
    public static final List<AnimatedAction> RUSH_ATTACK = PlayerModelAnimations.addTo(2, "rush_attack", (count, builder) -> count == 2 ? builder.apply(0.72).marker("attack_start", new double[]{0.2}).marker("attack_end", new double[]{0.52}).marker("leap", new double[]{0.16}).build() : builder.apply(1.96).marker("attack", new double[]{0.4, 0.56, 1.08}).marker("chain_1_start", new double[]{0.4}).marker("chain_1_end", new double[]{0.84}).marker("chain_2_start", new double[]{1.32}).marker("chain_2_end", new double[]{1.6}).marker("step", new double[]{0.36, 0.56}).marker("jump", new double[]{0.96}).build());
    public static final AnimatedAction ROUND_BREAK = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.12, (String)"round_break").marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{0.88}).build());
    public static final AnimatedAction MIND_THRUST = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.08, (String)"mind_thrust").marker("attack", new double[]{0.84}).marker("step", new double[]{0.72}).build());
    public static final AnimatedAction BUFF = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.08, (String)"self_buff").marker("attack", new double[]{0.64}).build());
    public static final AnimatedAction TWIN_ATTACK = PlayerModelAnimations.addTo(AnimatedAction.builder((double)0.68, (String)"twin_attack").marker("attack", new double[]{0.4}).build());
    public static final List<AnimatedAction> STORM = PlayerModelAnimations.addTo(5, "storm", (count, builder) -> switch (count) {
        case 2 -> builder.apply(0.56).marker("attack", new double[]{0.44}).marker("move", new double[]{0.32}).marker("done", new double[]{0.44}).build();
        case 3 -> builder.apply(0.52).marker("attack", new double[]{0.24}).marker("move", new double[]{0.24}).marker("done", new double[]{0.32}).build();
        case 4 -> builder.apply(0.56).marker("attack", new double[]{0.44}).marker("up", new double[]{0.08}).marker("down", new double[]{0.24}).marker("done", new double[]{0.44}).build();
        case 5 -> builder.apply(0.72).marker("attack", new double[]{0.44}).marker("up", new double[]{0.08}).marker("down", new double[]{0.36}).build();
        default -> builder.apply(0.56).marker("attack", new double[]{0.44}).marker("move", new double[]{0.12}).marker("done", new double[]{0.44}).build();
    });
    public static final AnimatedAction GUST = PlayerModelAnimations.addTo(AnimatedAction.builder((double)0.92, (String)"gust").marker("attack", new double[]{0.6}).marker("jump", new double[]{0.12}).build());
    public static final AnimatedAction RAIL_STRIKE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.56, (String)"rail_strike").marker("attack_start", new double[]{0.4}).marker("attack_end", new double[]{1.12}).marker("move_1", new double[]{0.2}).marker("move_2", new double[]{0.72}).marker("move_end", new double[]{1.24}).marker("reset", new double[]{0.56, 0.84, 1.0}).build());
    public static final List<AnimatedAction> WIND_SLASH = PlayerModelAnimations.addTo(2, "wind_slash", (count, builder) -> count == 2 ? builder.apply(1.44).marker("spin_start", new double[]{0.0}).marker("spin_end", new double[]{1.08}).marker("reset", new double[]{0.56}).build() : builder.apply(1.76).marker("spin_start", new double[]{0.36}).marker("spin_end", new double[]{1.4}).marker("reset", new double[]{0.88}).marker("chain_start", new double[]{1.08}).marker("leap", new double[]{0.28}).build());
    public static final AnimatedAction FLASH_STRIKE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.6, (String)"flash_strike").marker("attack_start", new double[]{0.32}).marker("attack_end", new double[]{1.04}).marker("reset", new double[]{0.56, 0.8}).marker("move_1", new double[]{0.36}).marker("move_2", new double[]{0.48}).marker("move_end", new double[]{1.16}).build());
    public static final AnimatedAction DELTA_STRIKE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.32, (String)"delta_strike").marker("attack", new double[]{0.36, 0.6, 1.12}).marker("step", new double[]{0.32, 1.04}).build());
    public static final AnimatedAction NAIVE_BLADE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)0.84, (String)"naive_blade").marker("prepared", new double[]{0.12}).build());
    public static final AnimatedAction NAIVE_BLADE_SUCCESS = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.36, (String)"naive_blade_success").marker("attack_1", new double[]{0.2}).marker("attack_2", new double[]{1.04}).marker("jump", new double[]{0.64}).build());
    public static final AnimatedAction HURRICANE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)2.08, (String)"hurricane").marker("attack", new double[]{0.32}).marker("attack_start", new double[]{0.52}).marker("attack_end", new double[]{1.64}).marker("reset", new double[]{0.88, 1.24}).build());
    public static final AnimatedAction REAPER_SLASH = PlayerModelAnimations.addTo(AnimatedAction.builder((double)0.92, (String)"reaper_slash").marker("attack_start", new double[]{0.28}).marker("attack_middle", new double[]{0.48}).marker("attack_end", new double[]{0.68}).build());
    public static final AnimatedAction MILLION_STRIKE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.04, (String)"million_strike").marker("attack", new double[]{0.48, 0.58, 0.68, 0.78}).marker("attack_crit", new double[]{0.78}).build());
    public static final AnimatedAction AXEL_DISASTER = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.44, (String)"axel_disaster").marker("move_1", new double[]{0.28}).marker("move_2", new double[]{0.44}).marker("move_3", new double[]{1.04}).marker("move_done", new double[]{1.24}).marker("attack_start", new double[]{0.44}).marker("attack_end", new double[]{1.08}).marker("move_start", new double[]{0.32}).marker("move_end", new double[]{1.2}).build());
    public static final AnimatedAction STARDUST_UPPER = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.76, (String)"stardust_upper").marker("attack_start_1", new double[]{0.16}).marker("attack_end_1", new double[]{0.84}).marker("attack_start_2", new double[]{0.84}).marker("attack_end_2", new double[]{1.52}).build());
    public static final AnimatedAction GRAND_IMPACT = PlayerModelAnimations.addTo(AnimatedAction.builder((double)3.32, (String)"grand_impact").marker("attack_1", new double[]{0.76}).marker("attack_2", new double[]{1.52}).marker("combo_end", new double[]{1.0}).build());
    public static final AnimatedAction TORNADO_SWING = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.6, (String)"tornado_swing").marker("attack_start_1", new double[]{0.2}).marker("attack_end_1", new double[]{1.04}).marker("attack_start_2", new double[]{1.04}).marker("attack_end_2", new double[]{1.4}).marker("chain_offset", new double[]{0.28}).build());
    public static final AnimatedAction GIGA_SWING = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.08, (String)"giga_swing").marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{0.52}).build());
    public static final AnimatedAction UPPER_CUT = PlayerModelAnimations.addTo(AnimatedAction.builder((double)0.8, (String)"upper_cut").marker("attack", new double[]{0.36}).build());
    public static final AnimatedAction DOUBLE_KICK = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.04, (String)"double_kick").marker("attack_start", new double[]{0.2}).marker("attack_end", new double[]{0.76}).marker("reset", new double[]{0.52}).marker("step", new double[]{0.44}).build());
    public static final AnimatedAction STRAIGHT_PUNCH = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.16, (String)"straight_punch").marker("attack", new double[]{0.92}).build());
    public static final AnimatedAction NEKO_DAMASHI = PlayerModelAnimations.addTo(AnimatedAction.builder((double)0.76, (String)"neko_damashi").marker("attack", new double[]{0.52}).build());
    public static final AnimatedAction RUSH_PUNCH = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.16, (String)"rush_punch").marker("attack", new double[]{0.52, 0.68, 0.84, 1.0}).marker("attack_crit", new double[]{1.16}).build());
    public static final AnimatedAction CYCLONE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)1.44, (String)"cyclone").marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{1.24}).marker("reset", new double[]{0.44, 0.64, 0.88, 1.08}).build());
    public static final AnimatedAction RAPID_MOVE = PlayerModelAnimations.addTo(AnimatedAction.builder((double)0.8, (String)"rapid_move").marker("attack", new double[]{0.72}).build());

    public static List<AnimatedAction> getAll() {
        return ImmutableList.copyOf(ALL);
    }

    private static List<AnimatedAction> addTo(int amount, String baseName, DependendAnimationValue values) {
        ImmutableList.Builder list = new ImmutableList.Builder();
        int i = 1;
        while (i <= amount) {
            int indx = i++;
            AnimatedAction anim = values.apply(indx, length -> AnimatedAction.builder((double)length, (String)(baseName + "_" + indx)));
            ALL.add(anim);
            list.add((Object)anim);
        }
        return list.build();
    }

    private static AnimatedAction addTo(AnimatedAction anim) {
        ALL.add(anim);
        return anim;
    }

    static interface DependendAnimationBuilder {
        public AnimatedAction.Builder apply(double var1);
    }

    static interface DependendAnimationValue {
        public AnimatedAction apply(int var1, DependendAnimationBuilder var2);
    }
}

