/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CropProperties {
    public static final Codec<CropProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("growth").forGetter(d -> d.growth), (App)Codec.INT.fieldOf("max_drops").forGetter(d -> d.maxDrops), (App)Codec.BOOL.fieldOf("regrowable").forGetter(d -> d.regrowable), (App)Registry.f_122824_.m_194605_().optionalFieldOf("giant_crop").forGetter(d -> d.giantVersion == Blocks.f_50016_ ? Optional.empty() : Optional.of(d.giantVersion)), (App)Codec.list((Codec)CodecUtils.stringEnumCodec(EnumSeason.class, (Enum)EnumSeason.SPRING)).fieldOf("best_season").forGetter(d -> List.copyOf(d.bestSeason)), (App)Codec.list((Codec)CodecUtils.stringEnumCodec(EnumSeason.class, (Enum)EnumSeason.SPRING)).fieldOf("bad_season").forGetter(d -> List.copyOf(d.badSeason))).apply((Applicative)instance, (growth, drops, regrowable, giant, best, bad) -> new CropProperties((int)growth, (int)drops, (boolean)regrowable, giant.orElse(Blocks.f_50016_), (Collection<EnumSeason>)best, (Collection<EnumSeason>)bad)));
    public static final CropProperties DEFAULT_PROP = new CropProperties();
    private final EnumSet<EnumSeason> bestSeason = EnumSet.noneOf(EnumSeason.class);
    private final EnumSet<EnumSeason> badSeason = EnumSet.noneOf(EnumSeason.class);
    private int growth = 3;
    private int maxDrops = 2;
    private boolean regrowable;
    private Block giantVersion = Blocks.f_50016_;
    private transient List<Component> translationTexts;
    private transient ResourceLocation id;

    private CropProperties() {
    }

    public CropProperties(int growth, int maxDrops, boolean regrowable, Block giantVersion, Collection<EnumSeason> bestSeason, Collection<EnumSeason> badSeason) {
        this.growth = growth;
        this.maxDrops = maxDrops;
        this.giantVersion = giantVersion;
        this.regrowable = regrowable;
        this.bestSeason.addAll(bestSeason);
        this.badSeason.addAll(badSeason);
    }

    public static CropProperties fromPacket(FriendlyByteBuf buffer) {
        int i;
        CropProperties prop = new CropProperties();
        prop.id = buffer.m_130281_();
        prop.growth = buffer.readInt();
        prop.maxDrops = buffer.readInt();
        prop.regrowable = buffer.readBoolean();
        int size = buffer.readInt();
        for (i = 0; i < size; ++i) {
            prop.bestSeason.add((EnumSeason)buffer.m_130066_(EnumSeason.class));
        }
        size = buffer.readInt();
        for (i = 0; i < size; ++i) {
            prop.badSeason.add((EnumSeason)buffer.m_130066_(EnumSeason.class));
        }
        return prop;
    }

    public void setID(ResourceLocation id) {
        if (this.id == null) {
            this.id = id;
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Set<EnumSeason> bestSeasons() {
        return this.bestSeason;
    }

    public Set<EnumSeason> badSeasons() {
        return this.badSeason;
    }

    public int growth() {
        return this.growth;
    }

    public int maxDrops() {
        return this.maxDrops;
    }

    public boolean regrowable() {
        return this.regrowable;
    }

    public Block getGiantVersion() {
        return this.giantVersion;
    }

    public float seasonMultiplier(EnumSeason season) {
        if (this.bestSeason.contains((Object)season)) {
            return 1.5f;
        }
        if (this.badSeason.contains((Object)season)) {
            return 0.6666667f;
        }
        return 1.0f;
    }

    public void toPacket(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.id);
        buffer.writeInt(this.growth);
        buffer.writeInt(this.maxDrops);
        buffer.writeBoolean(this.regrowable);
        buffer.writeInt(this.bestSeason.size());
        this.bestSeason.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130068_(arg_0));
        buffer.writeInt(this.badSeason.size());
        this.badSeason.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130068_(arg_0));
    }

    public List<Component> texts() {
        if (this.translationTexts == null) {
            this.translationTexts = new ArrayList<Component>();
            if (!this.bestSeason.isEmpty()) {
                MutableComponent season = new TranslatableComponent("runecraftory.tooltip.season.best").m_130946_(": ");
                int i = 0;
                for (EnumSeason seas : this.bestSeasons()) {
                    season.m_130946_(i != 0 ? "/" : "").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TranslatableComponent(seas.translationKey()).m_130940_(seas.getColor()));
                    ++i;
                }
                this.translationTexts.add((Component)season);
            }
            EnumSet<EnumSeason> badSeasons = EnumSet.copyOf(this.badSeason);
            badSeasons.removeAll(this.bestSeasons());
            if (!badSeasons.isEmpty()) {
                MutableComponent season = new TranslatableComponent("runecraftory.tooltip.season.bad").m_130946_(": ");
                int i = 0;
                for (EnumSeason seas : badSeasons) {
                    season.m_130946_(i != 0 ? "/" : "").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TranslatableComponent(seas.translationKey()).m_130940_(seas.getColor()));
                    ++i;
                }
                this.translationTexts.add((Component)season);
            }
            MutableComponent growth = new TranslatableComponent("runecraftory.tooltip.growth", new Object[]{this.growth()}).m_130940_(ChatFormatting.GOLD);
            MutableComponent harvest = new TranslatableComponent("runecraftory.tooltip.harvested", new Object[]{this.maxDrops()}).m_130940_(ChatFormatting.GOLD);
            this.translationTexts.add((Component)growth.m_130946_("  ").m_7220_((Component)harvest));
        }
        return this.translationTexts;
    }

    public String toString() {
        String s = "[BestSeasons:" + String.valueOf(this.bestSeason) + ";BadSeasons:" + String.valueOf(this.badSeason) + ";Growth:" + this.growth + ";Drops:" + this.maxDrops + ";Regrowable:" + this.regrowable + "]";
        if (this.id != null) {
            s = String.valueOf(this.id) + ":" + s;
        }
        return s;
    }

    public static class Builder {
        private final EnumSet<EnumSeason> bestSeason = EnumSet.noneOf(EnumSeason.class);
        private final EnumSet<EnumSeason> badSeason = EnumSet.noneOf(EnumSeason.class);
        private final int growth;
        private final int maxDrops;
        private final boolean regrowable;
        private Block giantVersion = Blocks.f_50016_;

        public Builder(int growth, int maxDrops, boolean regrowable) {
            this.growth = growth;
            this.maxDrops = maxDrops;
            this.regrowable = regrowable;
        }

        public Builder addGoodSeason(EnumSeason season) {
            this.bestSeason.add(season);
            return this;
        }

        public Builder addBadSeason(EnumSeason season) {
            this.badSeason.add(season);
            return this;
        }

        public Builder withGiantVersion(Block giantVersion) {
            this.giantVersion = giantVersion;
            return this;
        }

        public CropProperties build() {
            return new CropProperties(this.growth, this.maxDrops, this.regrowable, this.giantVersion, this.bestSeason, this.badSeason);
        }
    }
}

