/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.datapack.EntityRideActionCosts;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.tenshilib.common.utils.SearchUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.NotNull;

public class EntityProperties {
    public static final EntityProperties DEFAULT_PROP = new Builder().putAttributes(() -> Attributes.f_22276_, 20.0).putAttributes(() -> Attributes.f_22281_, 1.0).xp(5).money(5).tamingChance(0.3f).build();
    public static final Codec<EntityProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Registry.f_122866_.m_194605_(), (Codec)Codec.DOUBLE).fieldOf("base_values").forGetter(d -> d.baseValues), (App)Codec.unboundedMap((Codec)Registry.f_122866_.m_194605_(), (Codec)Codec.DOUBLE).fieldOf("level_gains").forGetter(d -> d.levelGains), (App)CodecHelper.ENTITY_PREDICATE_CODEC.optionalFieldOf("spawner_predicate").forGetter(d -> Optional.ofNullable(d.spawnerPredicate == EntityPredicate.f_36550_ ? null : d.spawnerPredicate)), (App)Codec.BOOL.fieldOf("needs_roof").forGetter(d -> d.needsRoof), (App)OnKilledIncrease.CODEC.listOf().optionalFieldOf("level_increase_on_kill").forGetter(d -> d.levelIncreaseOnKill.isEmpty() ? Optional.empty() : Optional.of(d.levelIncreaseOnKill)), (App)EntityRideActionCosts.CODEC.fieldOf("ride_action_costs").forGetter(d -> d.rideActionCosts), (App)Codec.BOOL.fieldOf("rideable").forGetter(d -> d.rideable), (App)Codec.BOOL.fieldOf("flying").forGetter(d -> d.flying), (App)ExtraCodecs.f_144629_.fieldOf("size").forGetter(d -> d.size), (App)ExtraCodecs.f_144629_.fieldOf("min_level").forGetter(d -> d.minLevel), (App)ExtraCodecs.f_144628_.fieldOf("xp").forGetter(d -> d.xp), (App)ExtraCodecs.f_144628_.fieldOf("money").forGetter(d -> d.money), (App)Codec.FLOAT.fieldOf("taming_chance").forGetter(d -> Float.valueOf(d.tamingChance))).apply((Applicative)instance, (baseValues, levelGains, spawnerPredicate, needsRoof, levelIncreaseOnKill, rideActionCosts, rideable, flying, size, minLevel, xp, money, tamingChance) -> new EntityProperties((int)minLevel, (int)xp, (int)money, tamingChance.floatValue(), (boolean)rideable, (boolean)flying, (int)size, (boolean)needsRoof, (EntityRideActionCosts)rideActionCosts, (Map<Attribute, Double>)baseValues, (Map<Attribute, Double>)levelGains, levelIncreaseOnKill.orElse(List.of()), spawnerPredicate.orElse(EntityPredicate.f_36550_))));
    public final int minLevel;
    public final int xp;
    public final int money;
    public final float tamingChance;
    public final boolean rideable;
    public final boolean flying;
    public final int size;
    public final boolean needsRoof;
    public final EntityRideActionCosts rideActionCosts;
    private final Map<Attribute, Double> baseValues;
    private final Map<Attribute, Double> levelGains;
    private final List<OnKilledIncrease> levelIncreaseOnKill;
    public final EntityPredicate spawnerPredicate;

    private EntityProperties(int minLevel, int xp, int money, float tamingChance, boolean rideable, boolean flying, int size, boolean needsRoof, EntityRideActionCosts rideActionCosts, Map<Attribute, Double> baseValues, Map<Attribute, Double> levelGains, List<OnKilledIncrease> levelIncreaseOnKill, EntityPredicate spawnerPredicate) {
        this.minLevel = Math.max(1, minLevel);
        this.xp = xp;
        this.money = money;
        this.tamingChance = tamingChance;
        this.rideable = rideable;
        this.flying = flying;
        this.size = size;
        this.needsRoof = needsRoof;
        this.rideActionCosts = rideActionCosts;
        this.baseValues = baseValues;
        this.levelGains = levelGains;
        this.levelIncreaseOnKill = levelIncreaseOnKill.stream().sorted().toList();
        this.spawnerPredicate = spawnerPredicate;
    }

    public Map<Attribute, Double> getBaseValues() {
        return ImmutableMap.copyOf(this.baseValues);
    }

    public Map<Attribute, Double> getAttributeGains() {
        return ImmutableMap.copyOf(this.levelGains);
    }

    public int levelIncreaseFromKill(int killed, ServerPlayer player) {
        return ((OnKilledIncrease)SearchUtils.searchInfFunc(this.levelIncreaseOnKill.stream().filter(c -> c.condition.m_36611_(player, (Entity)player)).toList(), p -> Integer.compare(p.minKilled(), killed), (Object)OnKilledIncrease.DEFAULT)).increase();
    }

    private record OnKilledIncrease(int minKilled, int increase, EntityPredicate condition) implements Comparable<OnKilledIncrease>
    {
        private static final OnKilledIncrease DEFAULT = new OnKilledIncrease(0, 0, null);
        public static final Codec<OnKilledIncrease> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("min_killed").forGetter(d -> d.minKilled), (App)Codec.INT.fieldOf("increase").forGetter(d -> d.increase), (App)CodecHelper.ENTITY_PREDICATE_CODEC.optionalFieldOf("predicate").forGetter(d -> Optional.ofNullable(d.condition == EntityPredicate.f_36550_ ? null : d.condition))).apply((Applicative)inst, (minKilled, increase, predicate) -> new OnKilledIncrease((int)minKilled, (int)increase, predicate.orElse(EntityPredicate.f_36550_))));

        @Override
        public int compareTo(@NotNull OnKilledIncrease o) {
            return Integer.compare(this.minKilled, o.minKilled);
        }
    }

    public static class Builder {
        private final Map<Supplier<Attribute>, Double> baseValues = new LinkedHashMap<Supplier<Attribute>, Double>();
        private final Map<Supplier<Attribute>, Double> gains = new LinkedHashMap<Supplier<Attribute>, Double>();
        private int xp;
        private int money;
        private float taming;
        private boolean rideable;
        private boolean flying;
        private int size = 1;
        private boolean needsRoof = true;
        private int minLevel = 1;
        private EntityRideActionCosts rideActionCosts = EntityRideActionCosts.DEFAULT;
        private final List<OnKilledIncrease> levelIncreaseOnKill = new ArrayList<OnKilledIncrease>();
        private EntityPredicate spawnerPredicate = EntityPredicate.f_36550_;

        public Builder putAttributes(Supplier<Attribute> att, double val) {
            this.baseValues.put(att, val);
            return this;
        }

        public Builder putLevelGains(Supplier<Attribute> att, double val) {
            this.gains.put(att, val);
            return this;
        }

        public Builder xp(int xp) {
            this.xp = xp;
            return this;
        }

        public Builder money(int money) {
            this.money = money;
            return this;
        }

        public Builder tamingChance(float chance) {
            this.taming = chance;
            return this;
        }

        public Builder setRideable() {
            this.rideable = true;
            return this;
        }

        public Builder setFlying() {
            this.flying = true;
            return this;
        }

        public Builder setBarnOccupancy(int size) {
            this.size = Math.max(1, size);
            return this;
        }

        public Builder doesntNeedBarnRoof() {
            this.needsRoof = false;
            return this;
        }

        public Builder setMinLevel(int minLevel) {
            this.minLevel = minLevel;
            return this;
        }

        public Builder withLevelIncrease(int minKilled, int increase) {
            this.levelIncreaseOnKill.add(new OnKilledIncrease(minKilled, increase, EntityPredicate.f_36550_));
            return this;
        }

        public Builder withLevelIncrease(int minKilled, int increase, EntityPredicate.Builder pred) {
            this.levelIncreaseOnKill.add(new OnKilledIncrease(minKilled, increase, pred.m_36662_()));
            return this;
        }

        public Builder withRideActionCosts(EntityRideActionCosts.Builder costs) {
            this.rideActionCosts = costs.build();
            return this;
        }

        public Builder withSpawnerPredicate(EntityPredicate.Builder builder) {
            this.spawnerPredicate = builder.m_36662_();
            return this;
        }

        public EntityProperties build() {
            return new EntityProperties(this.minLevel, this.xp, this.money, this.taming, this.rideable, this.flying, this.size, this.needsRoof, this.rideActionCosts, this.baseValues.entrySet().stream().collect(Collectors.toMap(e -> (Attribute)((Supplier)e.getKey()).get(), Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)), this.gains.entrySet().stream().collect(Collectors.toMap(e -> (Attribute)((Supplier)e.getKey()).get(), Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)), this.levelIncreaseOnKill, this.spawnerPredicate);
        }
    }
}

