/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.datapack.SimpleEffect;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.common.utils.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public class FoodProperties {
    public static final Codec<FoodProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Registry.f_122866_.m_194605_(), (Codec)Codec.DOUBLE).fieldOf("cooking_bonus_percent").forGetter(d -> d.cookingBonusPercent), (App)SimpleEffect.CODEC.listOf().fieldOf("potion_apply").forGetter(d -> Arrays.asList(d.potionApply)), (App)Registry.f_122823_.m_194605_().listOf().fieldOf("potion_remove").forGetter(d -> Arrays.asList(d.potionRemove)), (App)Codec.INT.fieldOf("duration").forGetter(d -> d.duration), (App)Codec.unboundedMap((Codec)Registry.f_122866_.m_194605_(), (Codec)Codec.DOUBLE).fieldOf("effects").forGetter(d -> d.effects), (App)Codec.unboundedMap((Codec)Registry.f_122866_.m_194605_(), (Codec)Codec.DOUBLE).fieldOf("effects_percentage").forGetter(d -> d.effectsPercentage), (App)Codec.unboundedMap((Codec)Registry.f_122866_.m_194605_(), (Codec)Codec.DOUBLE).fieldOf("cooking_bonus").forGetter(d -> d.cookingBonus)).apply((Applicative)instance, (cookingPercent, potion, remove, duration, effects, effPercent, cooking) -> new FoodProperties((int)duration, (Map<Attribute, Double>)effects, (Map<Attribute, Double>)effPercent, (Map<Attribute, Double>)cooking, (Map<Attribute, Double>)cookingPercent, (List<SimpleEffect>)potion, (List<MobEffect>)remove)));
    private final Map<Attribute, Double> effects = new TreeMap<Attribute, Double>(ModAttributes.SORTED);
    private final Map<Attribute, Double> effectsPercentage = new TreeMap<Attribute, Double>(ModAttributes.SORTED);
    private final Map<Attribute, Double> cookingBonus = new TreeMap<Attribute, Double>(ModAttributes.SORTED);
    private final Map<Attribute, Double> cookingBonusPercent = new TreeMap<Attribute, Double>(ModAttributes.SORTED);
    private int duration;
    private SimpleEffect[] potionApply = new SimpleEffect[0];
    private MobEffect[] potionRemove = new MobEffect[0];
    private ResourceLocation id;

    private FoodProperties() {
    }

    public FoodProperties(int duration, Map<Attribute, Double> effects, Map<Attribute, Double> effectsPercentage, Map<Attribute, Double> cookingBonus, Map<Attribute, Double> cookingBonusPercent, List<SimpleEffect> potionApply, List<MobEffect> potionRemove) {
        this.duration = duration;
        this.effects.putAll(effects);
        this.effectsPercentage.putAll(effectsPercentage);
        this.cookingBonus.putAll(cookingBonus);
        this.cookingBonusPercent.putAll(cookingBonusPercent);
        this.potionApply = potionApply.toArray(new SimpleEffect[0]);
        this.potionRemove = potionRemove.toArray(new MobEffect[0]);
    }

    public static FoodProperties fromPacket(FriendlyByteBuf buffer) {
        int i;
        FoodProperties prop = new FoodProperties();
        prop.id = buffer.m_130281_();
        prop.duration = buffer.readInt();
        int size = buffer.readInt();
        for (i = 0; i < size; ++i) {
            prop.effects.put((Attribute)Registry.f_122866_.m_7745_(buffer.m_130281_()), buffer.readDouble());
        }
        size = buffer.readInt();
        for (i = 0; i < size; ++i) {
            prop.effectsPercentage.put((Attribute)Registry.f_122866_.m_7745_(buffer.m_130281_()), buffer.readDouble());
        }
        size = buffer.readInt();
        prop.potionRemove = new MobEffect[size];
        for (i = 0; i < size; ++i) {
            prop.potionRemove[i] = (MobEffect)Registry.f_122823_.m_7745_(buffer.m_130281_());
        }
        size = buffer.readInt();
        prop.potionApply = new SimpleEffect[size];
        for (i = 0; i < size; ++i) {
            prop.potionApply[i] = new SimpleEffect((MobEffect)Registry.f_122823_.m_7745_(buffer.m_130281_()), buffer.readInt(), buffer.readInt());
        }
        return prop;
    }

    public void setID(ResourceLocation id) {
        if (this.id == null) {
            this.id = id;
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public int getHPGain() {
        return this.effects.getOrDefault(ModAttributes.HEALTHGAIN.get(), 0.0).intValue();
    }

    public int getHpPercentGain() {
        return this.effects.getOrDefault(ModAttributes.HEALTHGAIN.get(), 0.0).intValue();
    }

    public int getRPRegen() {
        return this.effects.getOrDefault(ModAttributes.RPGAIN.get(), 0.0).intValue();
    }

    public int getRpPercentRegen() {
        return this.effectsPercentage.getOrDefault(ModAttributes.RPGAIN.get(), 0.0).intValue();
    }

    public int duration() {
        return this.duration;
    }

    public Map<Attribute, Double> effects() {
        return new LinkedHashMap<Attribute, Double>(this.effects);
    }

    public Map<Attribute, Double> effectsMultiplier() {
        return new LinkedHashMap<Attribute, Double>(this.effectsPercentage);
    }

    public Map<Attribute, Double> cookingBonus() {
        return new LinkedHashMap<Attribute, Double>(this.cookingBonus);
    }

    public Map<Attribute, Double> cookingBonusPercent() {
        return new LinkedHashMap<Attribute, Double>(this.cookingBonusPercent);
    }

    public List<MobEffect> potionHeals() {
        return ImmutableList.copyOf((Object[])this.potionRemove);
    }

    public List<SimpleEffect> potionApply() {
        return ImmutableList.copyOf((Object[])this.potionApply);
    }

    public void toPacket(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.id);
        buffer.writeInt(this.duration);
        buffer.writeInt(this.effects.size());
        this.effects.forEach((att, val) -> {
            buffer.m_130085_(Registry.f_122866_.m_7981_(att));
            buffer.writeDouble(val.doubleValue());
        });
        buffer.writeInt(this.effectsPercentage.size());
        this.effectsPercentage.forEach((att, val) -> {
            buffer.m_130085_(Registry.f_122866_.m_7981_(att));
            buffer.writeDouble(val.doubleValue());
        });
        buffer.writeInt(this.potionRemove.length);
        for (MobEffect mobEffect : this.potionRemove) {
            buffer.m_130085_(Registry.f_122823_.m_7981_((Object)mobEffect));
        }
        buffer.writeInt(this.potionApply.length);
        for (SimpleEffect simpleEffect : this.potionApply) {
            buffer.m_130085_(Registry.f_122823_.m_7981_((Object)simpleEffect.getPotion()));
            buffer.writeInt(simpleEffect.getDuration());
            buffer.writeInt(simpleEffect.getAmplifier());
        }
    }

    public List<Component> texts(ItemStack stack) {
        MutableComponent comp;
        ArrayList<Component> translationTexts = new ArrayList<Component>();
        translationTexts.add((Component)new TranslatableComponent("runecraftory.tooltip.item.eaten").m_130940_(ChatFormatting.GRAY));
        TextComponent hprp = new TextComponent("");
        Pair<Map<Attribute, Double>, Map<Attribute, Double>> foodStats = ItemNBT.foodStats(stack);
        Map effects = (Map)foodStats.getFirst();
        Map effectsPercent = (Map)foodStats.getSecond();
        TextComponent hpIncrease = new TextComponent("");
        TextComponent rpIncrease = new TextComponent("");
        ArrayList<MutableComponent> attributes = new ArrayList<MutableComponent>();
        for (Map.Entry entry : effects.entrySet()) {
            if ((Double)entry.getValue() == 0.0) continue;
            comp = new TextComponent(" ").m_7220_((Component)new TranslatableComponent(((Attribute)entry.getKey()).m_22087_())).m_7220_((Component)new TextComponent(": " + this.format((Double)entry.getValue())));
            if (entry.getKey() == ModAttributes.HEALTHGAIN.get() || entry.getKey() == ModAttributes.RPGAIN.get()) {
                hprp.m_7220_((Component)comp);
                continue;
            }
            if (entry.getKey() == ModAttributes.RPINCREASE.get()) {
                rpIncrease.m_7220_((Component)comp);
                continue;
            }
            if (entry.getKey() == Attributes.f_22276_) {
                hpIncrease.m_7220_((Component)comp);
                continue;
            }
            attributes.add(comp.m_130940_(ChatFormatting.AQUA));
        }
        for (Map.Entry entry : effectsPercent.entrySet()) {
            if ((Double)entry.getValue() == 0.0) continue;
            comp = new TextComponent(" ").m_7220_((Component)new TranslatableComponent(((Attribute)entry.getKey()).m_22087_())).m_7220_((Component)new TextComponent(": " + this.format((Double)entry.getValue()) + "%"));
            if (entry.getKey() == ModAttributes.HEALTHGAIN.get() || entry.getKey() == ModAttributes.RPGAIN.get()) {
                hprp.m_7220_((Component)comp);
                continue;
            }
            if (entry.getKey() == ModAttributes.RPINCREASE.get()) {
                rpIncrease.m_7220_((Component)comp);
                continue;
            }
            if (entry.getKey() == Attributes.f_22276_) {
                hpIncrease.m_7220_((Component)comp);
                continue;
            }
            attributes.add(comp.m_130940_(ChatFormatting.AQUA));
        }
        if (!hprp.m_7360_().isEmpty()) {
            translationTexts.add((Component)hprp.m_130940_(ChatFormatting.AQUA));
        }
        if (!hpIncrease.m_7360_().isEmpty()) {
            translationTexts.add((Component)hpIncrease.m_130940_(ChatFormatting.AQUA));
        }
        if (!rpIncrease.m_7360_().isEmpty()) {
            translationTexts.add((Component)rpIncrease.m_130940_(ChatFormatting.AQUA));
        }
        translationTexts.addAll(attributes);
        if (translationTexts.size() == 1) {
            return Collections.emptyList();
        }
        return translationTexts;
    }

    private String format(double n) {
        return n >= 0.0 ? "+" + (int)n : "" + (int)n;
    }

    public String toString() {
        String s = "[Duration:" + this.duration + "]{effects:[" + String.valueOf(this.effects) + "], potions:[" + ArrayUtils.arrayToString((Object[])this.potionRemove, null) + "]";
        if (this.id != null) {
            s = String.valueOf(this.id) + ":" + s;
        }
        return s;
    }

    public static class Builder {
        private final Map<Attribute, Double> effects = new HashMap<Attribute, Double>();
        private final Map<Attribute, Double> effectsPercentage = new HashMap<Attribute, Double>();
        private final Map<Attribute, Double> cookingBonus = new HashMap<Attribute, Double>();
        private final Map<Attribute, Double> cookingBonusPercent = new HashMap<Attribute, Double>();
        private final List<SimpleEffect> potionApply = new ArrayList<SimpleEffect>();
        private final List<MobEffect> potionRemove = new ArrayList<MobEffect>();
        private final int duration;

        public Builder(int duration) {
            this.duration = duration;
        }

        public Builder setHPRegen(int hpRegen, int hpRegenPercent) {
            if (hpRegen != 0) {
                this.effects.put((Attribute)ModAttributes.HEALTHGAIN.get(), Double.valueOf(hpRegen));
            }
            if (hpRegenPercent != 0) {
                this.effectsPercentage.put((Attribute)ModAttributes.HEALTHGAIN.get(), Double.valueOf(hpRegenPercent));
            }
            return this;
        }

        public Builder setRPRegen(int rpRegen, int rpRegenPercent) {
            if (rpRegen != 0) {
                this.effects.put((Attribute)ModAttributes.RPGAIN.get(), Double.valueOf(rpRegen));
            }
            if (rpRegenPercent != 0) {
                this.effectsPercentage.put((Attribute)ModAttributes.RPGAIN.get(), Double.valueOf(rpRegenPercent));
            }
            return this;
        }

        public Builder setRPIncrease(int increase, int percentIncrease) {
            if (increase != 0) {
                this.effects.put((Attribute)ModAttributes.RPINCREASE.get(), Double.valueOf(increase));
            }
            if (percentIncrease != 0) {
                this.effectsPercentage.put((Attribute)ModAttributes.RPINCREASE.get(), Double.valueOf(percentIncrease));
            }
            return this;
        }

        public Builder addEffect(Attribute att, double value) {
            this.effects.put(att, value);
            return this;
        }

        public Builder addEffectPercentage(Attribute att, double value) {
            this.effectsPercentage.put(att, value);
            return this;
        }

        public Builder addCookingBonus(Attribute att, double value) {
            this.cookingBonus.put(att, value);
            return this;
        }

        public Builder addCookingBonusPercent(Attribute att, double value) {
            this.cookingBonusPercent.put(att, value);
            return this;
        }

        public Builder addPotion(MobEffect effect, int duration, int amplifier) {
            this.potionApply.add(new SimpleEffect(effect, duration, amplifier));
            return this;
        }

        public Builder curePotion(MobEffect effect) {
            this.potionRemove.add(effect);
            return this;
        }

        public FoodProperties build() {
            return new FoodProperties(this.duration, this.effects, this.effectsPercentage, this.cookingBonus, this.cookingBonusPercent, this.potionApply, this.potionRemove);
        }
    }
}

