/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.Biome;

public record GateSpawnData(ResourceLocation entity, int minDistanceFromSpawn, int minGateLevel, boolean canSpawnInWater, Map<TagKey<Biome>, Integer> biomes, Map<ResourceLocation, Integer> structures, EntityPredicate gatePredicate, EntityPredicate playerPredicate) {
    public static final Codec<GateSpawnData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)TagKey.m_203877_((ResourceKey)Registry.f_122885_), (Codec)ExtraCodecs.f_144629_).fieldOf("biomes").forGetter(GateSpawnData::biomes), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)ExtraCodecs.f_144629_).fieldOf("structures").forGetter(GateSpawnData::structures), (App)CodecHelper.ENTITY_PREDICATE_CODEC.optionalFieldOf("gate_predicate").forGetter(d -> Optional.ofNullable(d.gatePredicate == EntityPredicate.f_36550_ ? null : d.gatePredicate)), (App)CodecHelper.ENTITY_PREDICATE_CODEC.optionalFieldOf("player_predicate").forGetter(d -> Optional.ofNullable(d.playerPredicate == EntityPredicate.f_36550_ ? null : d.playerPredicate)), (App)ResourceLocation.f_135803_.fieldOf("entity").forGetter(GateSpawnData::entity), (App)ExtraCodecs.f_144628_.fieldOf("min_distance_from_spawn").orElse((Object)0).forGetter(GateSpawnData::minDistanceFromSpawn), (App)ExtraCodecs.f_144628_.fieldOf("min_gate_level").orElse((Object)0).forGetter(GateSpawnData::minGateLevel), (App)Codec.BOOL.fieldOf("allow_underwater").forGetter(GateSpawnData::canSpawnInWater)).apply((Applicative)instance, (biomes, structures, gatePredicate, playerPredicate, entity, dist, lvl, underwater) -> new GateSpawnData((ResourceLocation)entity, (int)dist, (int)lvl, (boolean)underwater, (Map<TagKey<Biome>, Integer>)biomes, (Map<ResourceLocation, Integer>)structures, gatePredicate.orElse(EntityPredicate.f_36550_), playerPredicate.orElse(EntityPredicate.f_36550_))));

    public static class Builder {
        private final Map<TagKey<Biome>, Integer> biomes = new LinkedHashMap<TagKey<Biome>, Integer>();
        private final Map<ResourceLocation, Integer> structures = new LinkedHashMap<ResourceLocation, Integer>();
        private final int minDistanceFromSpawn;
        private final int minGateLevel;
        private boolean allowUnderwater;
        private EntityPredicate gatePredicate;
        private EntityPredicate playerPredicate;

        public Builder(int minDistanceFromSpawn, int minGateLevel) {
            this.minDistanceFromSpawn = minDistanceFromSpawn;
            this.minGateLevel = minGateLevel;
        }

        @SafeVarargs
        public final Builder addToBiomeTag(int weight, TagKey<Biome> ... biomes) {
            for (TagKey<Biome> tag : biomes) {
                this.biomes.put(tag, weight);
            }
            return this;
        }

        public Builder addToStructures(int weight, ResourceLocation ... structures) {
            for (ResourceLocation s : structures) {
                this.structures.put(s, weight);
            }
            return this;
        }

        public Builder canSpawnUnderwater() {
            this.allowUnderwater = true;
            return this;
        }

        public Builder withGatePredicate(EntityPredicate.Builder builder) {
            this.gatePredicate = builder.m_36662_();
            return this;
        }

        public Builder withPlayerPredicate(EntityPredicate.Builder builder) {
            this.playerPredicate = builder.m_36662_();
            return this;
        }

        public GateSpawnData build(ResourceLocation name) {
            return new GateSpawnData(name, this.minDistanceFromSpawn, this.minGateLevel, this.allowUnderwater, this.biomes, this.structures, this.gatePredicate, this.playerPredicate);
        }
    }
}

