/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.lib.LibAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModArmorEffects;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import io.github.flemmli97.tenshilib.common.utils.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemStat {
    public static boolean SHOW_STATS_CUSTOM = true;
    public static final Codec<ItemStat> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.registryCodec(ModSpells.SPELL_REGISTRY_KEY).optionalFieldOf("tier_3_Spell").forGetter(s -> Optional.ofNullable(s.getTier3Spell())), (App)CodecUtils.registryCodec(ModArmorEffects.ARMOR_EFFECT_KEY).optionalFieldOf("armor_effect").forGetter(s -> Optional.ofNullable(s.getArmorEffect())), (App)CodecUtils.stringEnumCodec(EnumElement.class, (Enum)EnumElement.NONE).orElse((Object)EnumElement.NONE).fieldOf("element").forGetter(ItemStat::element), (App)CodecUtils.registryCodec(ModSpells.SPELL_REGISTRY_KEY).optionalFieldOf("tier_1_Spell").forGetter(s -> Optional.ofNullable(s.getTier1Spell())), (App)CodecUtils.registryCodec(ModSpells.SPELL_REGISTRY_KEY).optionalFieldOf("tier_2_Spell").forGetter(s -> Optional.ofNullable(s.getTier2Spell())), (App)Codec.unboundedMap((Codec)Registry.f_122866_.m_194605_(), (Codec)Codec.DOUBLE).fieldOf("item_stats").forGetter(ItemStat::itemStats), (App)Codec.unboundedMap((Codec)Registry.f_122866_.m_194605_(), (Codec)Codec.DOUBLE).fieldOf("monster_bonus").forGetter(ItemStat::getMonsterGiftIncrease), (App)ExtraCodecs.f_144628_.fieldOf("buy_price").forGetter(ItemStat::getBuy), (App)ExtraCodecs.f_144628_.fieldOf("sell_price").forGetter(ItemStat::getSell), (App)ExtraCodecs.f_144628_.fieldOf("upgrade_difficulty").forGetter(ItemStat::getDiff)).apply((Applicative)instance, (spell3, armorEffect, element, spell, spell2, atts, monster, buy, sell, upgrade) -> new ItemStat((int)buy, (int)sell, (int)upgrade, (EnumElement)((Object)((Object)element)), spell.orElse(null), spell2.orElse(null), spell3.orElse(null), armorEffect.orElse(null), (Map<Attribute, Double>)atts, (Map<Attribute, Double>)monster)));
    private static final Set<ResourceLocation> PERCENT_ATTRIBUTES = Sets.newHashSet((Object[])new ResourceLocation[]{LibAttributes.PARA, LibAttributes.POISON, LibAttributes.SEAL, LibAttributes.SLEEP, LibAttributes.FATIGUE, LibAttributes.COLD, LibAttributes.CRIT, LibAttributes.STUN, LibAttributes.FAINT, LibAttributes.DRAIN, LibAttributes.KNOCK, LibAttributes.RES_WATER, LibAttributes.RES_EARTH, LibAttributes.RES_WIND, LibAttributes.RES_FIRE, LibAttributes.RES_DARK, LibAttributes.RES_LIGHT, LibAttributes.RES_LOVE, LibAttributes.RES_PARA, LibAttributes.RES_POISON, LibAttributes.RES_SEAL, LibAttributes.RES_SLEEP, LibAttributes.RES_FATIGUE, LibAttributes.RES_COLD, LibAttributes.RES_CRIT, LibAttributes.RES_STUN, LibAttributes.RES_FAINT, LibAttributes.RES_DRAIN, LibAttributes.RES_KNOCK});
    private static final Set<ResourceLocation> IGNORED = Sets.newHashSet((Object[])new ResourceLocation[]{LibAttributes.ATTACK_SPEED, LibAttributes.ATTACK_RANGE, LibAttributes.HEALTH_GAIN, LibAttributes.RP_GAIN});
    private final Map<Attribute, Double> itemStats;
    private Map<Attribute, Double> monsterGiftIncrease = Map.of();
    private int buyPrice;
    private int sellPrice;
    private int upgradeDifficulty;
    private EnumElement element = EnumElement.NONE;
    private Spell tier1Spell;
    private Spell tier2Spell;
    private Spell tier3Spell;
    private ArmorEffect armorEffect;
    private transient ResourceLocation id;

    private ItemStat() {
        this.itemStats = new HashMap<Attribute, Double>();
    }

    private ItemStat(int buyPrice, int sellPrice, int upgradeDifficulty, EnumElement element, Spell tier1Spell, Spell tier2Spell, Spell tier3Spell, ArmorEffect effect, Map<Attribute, Double> itemStats, Map<Attribute, Double> monsterGiftIncrease) {
        this.itemStats = itemStats;
        this.buyPrice = buyPrice;
        this.sellPrice = sellPrice;
        this.upgradeDifficulty = upgradeDifficulty;
        this.element = element;
        this.tier1Spell = tier1Spell;
        this.tier2Spell = tier2Spell;
        this.tier3Spell = tier3Spell;
        this.armorEffect = effect;
        this.monsterGiftIncrease = ImmutableSortedMap.copyOf(monsterGiftIncrease, ModAttributes.SORTED);
    }

    public static ItemStat fromPacket(FriendlyByteBuf buffer) {
        ItemStat stat = new ItemStat();
        stat.id = buffer.m_130281_();
        stat.buyPrice = buffer.readInt();
        stat.sellPrice = buffer.readInt();
        stat.upgradeDifficulty = buffer.readInt();
        stat.element = (EnumElement)buffer.m_130066_(EnumElement.class);
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            stat.itemStats.put((Attribute)Registry.f_122866_.m_7745_(buffer.m_130281_()), buffer.readDouble());
        }
        size = buffer.readInt();
        ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder(ModAttributes.SORTED);
        for (int i = 0; i < size; ++i) {
            builder.put((Object)((Attribute)Registry.f_122866_.m_7745_(buffer.m_130281_())), (Object)buffer.readDouble());
        }
        stat.monsterGiftIncrease = builder.build();
        if (buffer.readBoolean()) {
            stat.tier1Spell = (Spell)((Object)ModSpells.SPELL_REGISTRY.get().getFromId(buffer.m_130281_()));
        }
        if (buffer.readBoolean()) {
            stat.tier2Spell = (Spell)((Object)ModSpells.SPELL_REGISTRY.get().getFromId(buffer.m_130281_()));
        }
        if (buffer.readBoolean()) {
            stat.tier3Spell = (Spell)((Object)ModSpells.SPELL_REGISTRY.get().getFromId(buffer.m_130281_()));
        }
        if (buffer.readBoolean()) {
            stat.armorEffect = (ArmorEffect)((Object)ModArmorEffects.ARMOR_EFFECT_REGISTRY.get().getFromId(buffer.m_130281_()));
        }
        return stat;
    }

    public void setID(ResourceLocation id) {
        if (this.id == null) {
            this.id = id;
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public int getBuy() {
        return this.buyPrice;
    }

    public int getSell() {
        return this.sellPrice;
    }

    public int getDiff() {
        return this.upgradeDifficulty;
    }

    public EnumElement element() {
        return this.element;
    }

    public Map<Attribute, Double> itemStats() {
        TreeMap<Attribute, Double> map = new TreeMap<Attribute, Double>(ModAttributes.SORTED);
        map.putAll(this.itemStats);
        return map;
    }

    public Map<Attribute, Double> getMonsterGiftIncrease() {
        return this.monsterGiftIncrease;
    }

    @Nullable
    public Spell getTier1Spell() {
        return this.tier1Spell;
    }

    @Nullable
    public Spell getTier2Spell() {
        return this.tier2Spell;
    }

    @Nullable
    public Spell getTier3Spell() {
        return this.tier3Spell;
    }

    @Nullable
    public ArmorEffect getArmorEffect() {
        return this.armorEffect;
    }

    public void toPacket(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.id);
        buffer.writeInt(this.buyPrice);
        buffer.writeInt(this.sellPrice);
        buffer.writeInt(this.upgradeDifficulty);
        buffer.m_130068_((Enum)this.element);
        buffer.writeInt(this.itemStats.size());
        this.itemStats.forEach((att, val) -> {
            buffer.m_130085_(Registry.f_122866_.m_7981_(att));
            buffer.writeDouble(val.doubleValue());
        });
        buffer.writeInt(this.monsterGiftIncrease.size());
        this.monsterGiftIncrease.forEach((att, val) -> {
            buffer.m_130085_(Registry.f_122866_.m_7981_(att));
            buffer.writeDouble(val.doubleValue());
        });
        buffer.writeBoolean(this.tier1Spell != null);
        if (this.tier1Spell != null) {
            buffer.m_130085_(this.tier1Spell.getRegistryName());
        }
        buffer.writeBoolean(this.tier2Spell != null);
        if (this.tier2Spell != null) {
            buffer.m_130085_(this.tier2Spell.getRegistryName());
        }
        buffer.writeBoolean(this.tier3Spell != null);
        if (this.tier3Spell != null) {
            buffer.m_130085_(this.tier3Spell.getRegistryName());
        }
        buffer.writeBoolean(this.armorEffect != null);
        if (this.armorEffect != null) {
            buffer.m_130085_(this.armorEffect.getRegistryName());
        }
    }

    public List<Component> texts(ItemStack stack, boolean showStat) {
        AttributeMapDisplay stats;
        List<Component> statsTooltip;
        boolean shouldHaveStats;
        TranslatableComponent price;
        ArrayList<Component> list = new ArrayList<Component>();
        TranslatableComponent translatableComponent = price = ItemNBT.shouldHaveLevel(stack) ? new TranslatableComponent("runecraftory.tooltip.item.level", new Object[]{ItemNBT.itemLevel(stack)}) : null;
        if (ItemUtils.getBuyPrice(stack, this) > 0) {
            if (price == null) {
                price = new TranslatableComponent("runecraftory.tooltip.item.buy", new Object[]{ItemUtils.getBuyPrice(stack, this)});
            } else {
                price.m_130946_(" ").m_7220_((Component)new TranslatableComponent("runecraftory.tooltip.item.buy", new Object[]{ItemUtils.getBuyPrice(stack, this)})).m_130946_(" ");
            }
        }
        if (ItemUtils.getSellPrice(stack, this) > 0) {
            if (price == null) {
                price = new TranslatableComponent("runecraftory.tooltip.item.sell", new Object[]{ItemUtils.getSellPrice(stack, this)});
            } else {
                price.m_130946_(" ").m_7220_((Component)new TranslatableComponent("runecraftory.tooltip.item.sell", new Object[]{ItemUtils.getSellPrice(stack, this)}));
            }
        }
        if (price != null) {
            list.add((Component)price.m_130940_(ChatFormatting.YELLOW));
        }
        if (!(shouldHaveStats = ItemNBT.shouldHaveStats(stack)) && this.getDiff() > 0) {
            list.add((Component)new TranslatableComponent("runecraftory.tooltip.item.difficulty", new Object[]{this.getDiff()}).m_130940_(ChatFormatting.YELLOW));
        }
        if (showStat && !(statsTooltip = (stats = ItemStat.getStatsAttributeMap(stack)).components()).isEmpty()) {
            String prefix = shouldHaveStats ? "runecraftory.tooltip.item.equipped" : "runecraftory.tooltip.item.upgrade";
            list.add((Component)new TranslatableComponent(prefix).m_130940_(ChatFormatting.GRAY));
            list.addAll(statsTooltip);
        }
        return list;
    }

    private static AttributeMapDisplay getStatsAttributeMap(ItemStack stack) {
        if (!ItemNBT.shouldHaveStats(stack)) {
            return DataPackHandler.INSTANCE.itemStatManager().get(stack.m_41720_()).map(s -> new AttributeMapDisplay(s.itemStats, null)).orElse(new AttributeMapDisplay(null, null));
        }
        if (!SHOW_STATS_CUSTOM) {
            return new AttributeMapDisplay(null, null);
        }
        TreeMap<Attribute, AttributeValues> map = new TreeMap<Attribute, AttributeValues>(ModAttributes.SORTED);
        Multimap multimap = stack.m_41638_(ItemUtils.slotOf(stack));
        multimap.forEach((att, mod) -> map.compute((Attribute)att, (key, old) -> old == null ? AttributeValues.of(mod) : old.add((AttributeModifier)mod)));
        return new AttributeMapDisplay(null, map);
    }

    public String toString() {
        String s = "[Buy:" + this.buyPrice + ";Sell:" + this.sellPrice + ";UpgradeDifficulty:" + this.upgradeDifficulty + ";DefaultElement:" + String.valueOf((Object)this.element) + "];{stats:[" + MapUtils.toString(this.itemStats, reg -> Registry.f_122866_.m_7981_(reg).toString(), Object::toString) + "]}";
        if (this.id != null) {
            s = String.valueOf(this.id) + ":" + s;
        }
        return s;
    }

    record AttributeMapDisplay(Map<Attribute, Double> flat, Map<Attribute, AttributeValues> ext) {
        private List<Component> components() {
            ArrayList<Component> list;
            block5: {
                block4: {
                    list = new ArrayList<Component>();
                    if (this.flat == null) break block4;
                    for (Map.Entry<Attribute, Double> entry : this.flat.entrySet()) {
                        double d;
                        String num;
                        ResourceLocation key = Registry.f_122866_.m_7981_((Object)entry.getKey());
                        if (IGNORED.contains(key) || (num = AttributeMapDisplay.format(key, d = entry.getKey().equals(Attributes.f_22278_) ? entry.getValue() * 10.0 : entry.getValue(), false)) == null) continue;
                        MutableComponent comp = new TextComponent(" ").m_7220_((Component)new TranslatableComponent(entry.getKey().m_22087_())).m_7220_((Component)new TextComponent(": " + num));
                        list.add((Component)comp.m_130940_(ChatFormatting.BLUE));
                    }
                    break block5;
                }
                if (this.ext == null) break block5;
                for (Map.Entry<Attribute, AttributeValues> entry : this.ext.entrySet()) {
                    String num;
                    MutableComponent comp;
                    ResourceLocation key = Registry.f_122866_.m_7981_((Object)entry.getKey());
                    if (IGNORED.contains(key)) continue;
                    if (entry.getValue().flat != 0.0) {
                        double d = entry.getKey().equals(Attributes.f_22278_) ? entry.getValue().flat * 10.0 : entry.getValue().flat;
                        String num2 = AttributeMapDisplay.format(key, d, false);
                        if (num2 == null) continue;
                        MutableComponent comp2 = new TextComponent(" ").m_7220_((Component)new TranslatableComponent(entry.getKey().m_22087_())).m_7220_((Component)new TextComponent(": " + num2));
                        list.add((Component)comp2.m_130940_(ChatFormatting.BLUE));
                    }
                    if (entry.getValue().multBase != 0.0) {
                        String num3 = AttributeMapDisplay.format(key, entry.getValue().multBase, true);
                        if (num3 == null) continue;
                        comp = new TextComponent(" ").m_7220_((Component)new TranslatableComponent(entry.getKey().m_22087_())).m_7220_((Component)new TextComponent(": " + num3));
                        list.add((Component)comp.m_130940_(ChatFormatting.BLUE));
                    }
                    if (entry.getValue().multTotal == 0.0 || (num = AttributeMapDisplay.format(key, entry.getValue().multTotal, true)) == null) continue;
                    comp = new TextComponent(" ").m_7220_((Component)new TranslatableComponent(entry.getKey().m_22087_())).m_7220_((Component)new TextComponent(": " + num));
                    list.add((Component)comp.m_130940_(ChatFormatting.BLUE));
                }
            }
            return list;
        }

        private static String format(ResourceLocation att, double n, boolean percentage) {
            double val;
            String sign;
            String string = n > 0.0 ? (percentage ? "x" : "+") : (sign = "");
            if (att.equals((Object)LibAttributes.MOVEMENT_SPEED)) {
                double val2;
                double d = val2 = percentage ? n : (double)((int)(n * 100.0)) / 100.0;
                if (val2 == 0.0) {
                    return null;
                }
                return sign + ItemStack.f_41584_.format(val2);
            }
            boolean percSign = PERCENT_ATTRIBUTES.contains(att);
            double d = val = percentage ? n : (double)((float)((int)(n * 2.0)) * 0.5f);
            if (val == 0.0) {
                return null;
            }
            return sign + ItemStack.f_41584_.format(val) + (percSign ? "%" : "");
        }
    }

    private static class AttributeValues {
        private double flat;
        private double multBase;
        private double multTotal;

        private AttributeValues(double flat, double multBase, double multTotal) {
            this.flat = flat;
            this.multBase = multBase;
            this.multTotal = multTotal;
        }

        private static AttributeValues of(AttributeModifier mod) {
            return switch (mod.m_22217_()) {
                default -> throw new IncompatibleClassChangeError();
                case AttributeModifier.Operation.ADDITION -> new AttributeValues(mod.m_22218_(), 0.0, 0.0);
                case AttributeModifier.Operation.MULTIPLY_BASE -> new AttributeValues(0.0, mod.m_22218_(), 0.0);
                case AttributeModifier.Operation.MULTIPLY_TOTAL -> new AttributeValues(0.0, 0.0, mod.m_22218_());
            };
        }

        private AttributeValues add(AttributeModifier mod) {
            switch (mod.m_22217_()) {
                case ADDITION: {
                    this.flat += mod.m_22218_();
                    break;
                }
                case MULTIPLY_BASE: {
                    this.multBase += mod.m_22218_();
                    break;
                }
                case MULTIPLY_TOTAL: {
                    this.multTotal += mod.m_22218_();
                }
            }
            return this;
        }
    }

    public static class Builder {
        private final Map<Attribute, Double> itemStats = new HashMap<Attribute, Double>();
        private final Map<Attribute, Double> monsterGiftIncrease = new HashMap<Attribute, Double>();
        public final int buyPrice;
        public final int sellPrice;
        public final int upgradeDifficulty;
        private EnumElement element = EnumElement.NONE;
        private Spell tier1Spell;
        private Spell tier2Spell;
        private Spell tier3Spell;
        private ArmorEffect armorEffect;

        public Builder(int buy, int sell, int upgrade) {
            this.buyPrice = buy;
            this.sellPrice = sell;
            this.upgradeDifficulty = upgrade;
        }

        public Builder setElement(EnumElement element) {
            this.element = element;
            return this;
        }

        public Builder addAttribute(Attribute att, double value) {
            this.itemStats.put(att, value);
            return this;
        }

        public Builder addMonsterStat(Attribute att, double value) {
            this.monsterGiftIncrease.put(att, value);
            return this;
        }

        public Builder setSpell(Spell tier1, Spell tier2, Spell tier3) {
            this.tier1Spell = tier1;
            this.tier2Spell = tier2;
            this.tier3Spell = tier3;
            return this;
        }

        public Builder withArmorEffect(ArmorEffect effect) {
            this.armorEffect = effect;
            return this;
        }

        public ItemStat build() {
            return new ItemStat(this.buyPrice, this.sellPrice, this.upgradeDifficulty, this.element, this.tier1Spell, this.tier2Spell, this.tier3Spell, this.armorEffect, this.itemStats, this.monsterGiftIncrease);
        }
    }
}

