/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.npc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.api.datapack.npc.ConversationSet;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCSchedule;
import io.github.flemmli97.runecraftory.common.entities.npc.QuestConversationContext;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.Nullable;

public record NPCData(@Nullable String name, @Nullable String surname, Gender gender, List<NPCJob> profession, @Nullable List<NPCLookId> look, @Nullable Pair<EnumSeason, Integer> birthday, int weight, String neutralGiftResponse, Map<ConversationContext, ResourceLocation> interactions, QuestHandler questHandler, Map<String, Gift> giftItems, @Nullable NPCSchedule.Schedule schedule, @Nullable Map<Attribute, Double> baseStats, @Nullable Map<Attribute, Double> statIncrease, int baseLevel, @Nullable List<ResourceLocation> combatActions, int unique, RelationShipState relationShipState, List<ResourceLocation> possibleChildren) {
    public static final Map<Attribute, Double> DEFAULT_GAIN = Map.of(Attributes.f_22276_, 3.0, Attributes.f_22281_, 1.0, (Attribute)ModAttributes.DEFENCE.get(), 0.5, (Attribute)ModAttributes.MAGIC.get(), 1.0, (Attribute)ModAttributes.MAGIC_DEFENCE.get(), 0.5);
    public static final NPCData DEFAULT_DATA = new NPCData(null, null, Gender.UNDEFINED, List.of(), null, null, 1, "runecraftory.npc.default.gift.neutral", Map.of(), new QuestHandler(Map.of(), Set.of()), Map.of(), null, null, null, 1, null, 0, RelationShipState.DEFAULT, List.of());
    public static final Codec<NPCData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)NPCData.filledMap(Codec.unboundedMap((Codec)ResourceLocation.f_135803_.flatComapMap(ConversationContext::get, ctx -> DataResult.success((Object)ctx.key())), (Codec)ResourceLocation.f_135803_)).fieldOf("interactions").forGetter(d -> d.interactions), (App)QuestHandler.CODEC.fieldOf("quest_handler").forGetter(d -> d.questHandler), (App)NPCSchedule.Schedule.CODEC.optionalFieldOf("schedule").forGetter(d -> Optional.ofNullable(d.schedule)), (App)NPCCombat.CODEC.optionalFieldOf("combat").forGetter(d -> {
        NPCCombat combat = new NPCCombat(d.baseStats, d.statIncrease, d.baseLevel, d.combatActions);
        if (combat.isNone()) {
            return Optional.empty();
        }
        return Optional.of(combat);
    }), (App)RelationStruct.CODEC.fieldOf("relation").forGetter(d -> new RelationStruct(d.relationShipState, d.possibleChildren)), (App)Codec.STRING.fieldOf("neutral_gift_response").forGetter(d -> d.neutralGiftResponse), (App)Codec.unboundedMap((Codec)Codec.STRING, Gift.CODEC).fieldOf("gift_items").forGetter(d -> d.giftItems), (App)NPCLookId.CODEC.listOf().optionalFieldOf("look").forGetter(d -> Optional.ofNullable(d.look == null || d.look.isEmpty() ? null : d.look)), (App)WorldUtils.DATE.optionalFieldOf("birthday").forGetter(d -> Optional.ofNullable(d.birthday)), (App)ExtraCodecs.f_144629_.fieldOf("weight").forGetter(d -> d.weight), (App)ExtraCodecs.f_144628_.optionalFieldOf("unique").forGetter(d -> d.unique == 0 ? Optional.empty() : Optional.of(d.unique)), (App)Codec.STRING.optionalFieldOf("name").forGetter(d -> Optional.ofNullable(d.name)), (App)Codec.STRING.optionalFieldOf("surname").forGetter(d -> Optional.ofNullable(d.surname)), (App)CodecUtils.stringEnumCodec(Gender.class, (Enum)Gender.UNDEFINED).fieldOf("gender").forGetter(d -> d.gender), (App)ModNPCJobs.CODEC.listOf().optionalFieldOf("profession").forGetter(d -> d.profession.isEmpty() ? Optional.empty() : Optional.of(d.profession))).apply((Applicative)inst, (interactions, questHandler, schedule, combat, relation, neutralGift, giftItems, look, birthday, weight, unique, name, surname, gender, profession) -> new NPCData(name.orElse(null), surname.orElse(null), (Gender)((Object)((Object)gender)), profession.orElse(List.of()), look.orElse(null), (Pair<EnumSeason, Integer>)((Pair)birthday.orElse(null)), (int)weight, (String)neutralGift, (Map<ConversationContext, ResourceLocation>)interactions, (QuestHandler)questHandler, (Map<String, Gift>)giftItems, schedule.orElse(null), combat.map(d -> d.baseStats).orElse(null), combat.map(d -> d.statIncrease).orElse(null), combat.map(d -> d.baseLevel).orElse(1), combat.map(d -> d.npcAction).orElse(null), unique.orElse(0), relation.relationShipState, relation.possibleChildren)));

    public static <T> Codec<Map<ConversationContext, T>> filledMap(Codec<Map<ConversationContext, T>> codec) {
        Function<Map, DataResult> check = map -> {
            ArrayList<ResourceLocation> missing = new ArrayList<ResourceLocation>();
            for (ConversationContext e : ConversationContext.getRegistered()) {
                if (map.containsKey(e)) continue;
                missing.add(e.key());
            }
            if (!missing.isEmpty()) {
                return DataResult.error((String)("Conversation map is missing conversation for contexts: " + String.valueOf(missing)), (Object)map);
            }
            return DataResult.success((Object)map);
        };
        return codec.flatXmap(check, DataResult::success);
    }

    public ConversationSet getConversation(ConversationContext convCtx) {
        ResourceLocation conversationId = this.interactions().get(convCtx);
        ConversationSet fallback = new ConversationSet("runecraftory.npc.conversation.context.missing", convCtx.key(), Map.of());
        if (conversationId == null) {
            return fallback;
        }
        fallback = new ConversationSet("runecraftory.npc.conversation.missing", convCtx.key(), Map.of());
        return DataPackHandler.INSTANCE.npcConversationManager().get(conversationId, fallback);
    }

    public ConversationSet getFromQuest(ResourceLocation quest, QuestConversationContext ctx, int state) {
        QuestResponses responses = this.questHandler().responses().get(quest);
        ConversationSet fallback = new ConversationSet("runecraftory.npc.default.quest.response.missing", quest, Map.of());
        if (responses == null) {
            return fallback;
        }
        ResourceLocation conversationId = switch (ctx) {
            default -> throw new IncompatibleClassChangeError();
            case QuestConversationContext.NOT_STARTED -> {
                if (state <= 0) {
                    yield responses.startID;
                }
                yield new ResourceLocation(responses.startID.m_135827_(), responses.startID.m_135815_() + "_" + state);
            }
            case QuestConversationContext.IN_PROGRESS -> {
                if (state == 0) {
                    yield responses.activeID;
                }
                yield new ResourceLocation(responses.activeID.m_135827_(), responses.activeID.m_135815_() + "_" + state);
            }
            case QuestConversationContext.COMPLETED -> responses.endID;
        };
        fallback = new ConversationSet("npc.conversation.missing", conversationId, Map.of());
        return DataPackHandler.INSTANCE.npcConversationManager().get(conversationId, fallback);
    }

    public static enum Gender {
        UNDEFINED,
        MALE,
        FEMALE;

    }

    public record QuestHandler(Map<ResourceLocation, QuestResponses> responses, Set<ResourceLocation> requiredQuests) {
        public static final Codec<QuestHandler> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, QuestResponses.CODEC).fieldOf("responses").forGetter(d -> d.responses), (App)ResourceLocation.f_135803_.listOf().fieldOf("required_quests").forGetter(d -> List.copyOf(d.requiredQuests))).apply((Applicative)inst, (responses, required) -> new QuestHandler((Map<ResourceLocation, QuestResponses>)responses, Set.copyOf(required))));
    }

    public static enum RelationShipState {
        DEFAULT,
        NON_ROMANCEABLE,
        NO_ROMANCE_NPC,
        NO_ROMANCE;

    }

    public record QuestResponses(ResourceLocation startID, ResourceLocation activeID, ResourceLocation endID) {
        public static final Codec<QuestResponses> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.f_135803_.fieldOf("start_id").forGetter(d -> d.startID), (App)ResourceLocation.f_135803_.fieldOf("active_id").forGetter(d -> d.activeID), (App)ResourceLocation.f_135803_.fieldOf("end_id").forGetter(d -> d.endID)).apply((Applicative)inst, QuestResponses::new));
    }

    record NPCCombat(@Nullable Map<Attribute, Double> baseStats, @Nullable Map<Attribute, Double> statIncrease, int baseLevel, @Nullable List<ResourceLocation> npcAction) {
        public static final Codec<NPCCombat> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ExtraCodecs.f_144629_.optionalFieldOf("base_level").forGetter(d -> d.baseLevel != 1 ? Optional.of(d.baseLevel) : Optional.empty()), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("combat_actions").forGetter(d -> Optional.ofNullable(d.npcAction == null || d.npcAction.isEmpty() ? null : d.npcAction)), (App)Codec.unboundedMap((Codec)Registry.f_122866_.m_194605_(), (Codec)Codec.DOUBLE).optionalFieldOf("base_stats").forGetter(d -> Optional.ofNullable(d.baseStats)), (App)Codec.unboundedMap((Codec)Registry.f_122866_.m_194605_(), (Codec)Codec.DOUBLE).optionalFieldOf("stat_increase").forGetter(d -> Optional.ofNullable(d.statIncrease))).apply((Applicative)inst, (lvl, action, stats, inc) -> new NPCCombat(stats.orElse(null), inc.orElse(null), lvl.orElse(1), action.orElse(null))));

        public boolean isNone() {
            return this.baseLevel == 1 && this.baseStats == null && this.statIncrease == null && this.npcAction == null;
        }
    }

    record RelationStruct(RelationShipState relationShipState, List<ResourceLocation> possibleChildren) {
        public static final Codec<RelationStruct> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CodecUtils.stringEnumCodec(RelationShipState.class, (Enum)RelationShipState.DEFAULT).fieldOf("relation_ship_state").forGetter(d -> d.relationShipState), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("possible_children").forGetter(d -> d.possibleChildren.isEmpty() ? Optional.empty() : Optional.of(d.possibleChildren))).apply((Applicative)inst, (state, childs) -> new RelationStruct((RelationShipState)((Object)((Object)state)), childs.orElse(List.of()))));
    }

    public record Gift(@Nullable ResourceLocation giftID, String responseKey, int xp) {
        public static final Codec<Gift> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.f_135803_.optionalFieldOf("gift_id").forGetter(d -> Optional.ofNullable(d.giftID)), (App)Codec.STRING.fieldOf("response_key").forGetter(d -> d.responseKey), (App)Codec.INT.fieldOf("xp").forGetter(d -> d.xp)).apply((Applicative)inst, (items, respone, xp) -> new Gift(items.orElse(null), (String)respone, (int)xp)));
    }

    public record NPCLookId(ResourceLocation id, Gender gender) {
        public static final Codec<NPCLookId> CODEC = Codec.either((Codec)ResourceLocation.f_135803_, (Codec)RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.f_135803_.fieldOf("look").forGetter(NPCLookId::id), (App)CodecUtils.stringEnumCodec(Gender.class, (Enum)Gender.UNDEFINED).fieldOf("gender").forGetter(NPCLookId::gender)).apply((Applicative)inst, NPCLookId::new))).flatXmap(d -> {
            if (d.left().isPresent()) {
                return DataResult.success((Object)new NPCLookId((ResourceLocation)d.left().get()));
            }
            return d.right().map(DataResult::success).orElse(DataResult.error((String)"Failed to parse npc look id"));
        }, i -> DataResult.success((Object)(i.gender == Gender.UNDEFINED ? Either.left((Object)i.id()) : Either.right((Object)i))));

        public NPCLookId(String namespace, String path) {
            this(new ResourceLocation(namespace, path));
        }

        public NPCLookId(ResourceLocation id) {
            this(id, Gender.UNDEFINED);
        }
    }

    public static class Builder {
        private final String name;
        private final String surname;
        private final Gender gender;
        private final int weight;
        private String neutralGiftResponse;
        private final List<NPCJob> professions = new ArrayList<NPCJob>();
        private final Map<ConversationContext, ResourceLocation> interactions = new LinkedHashMap<ConversationContext, ResourceLocation>();
        private final Map<String, Gift> giftItems = new LinkedHashMap<String, Gift>();
        private Pair<EnumSeason, Integer> birthday;
        private NPCSchedule.Schedule schedule;
        private List<NPCLookId> look;
        private List<ResourceLocation> combatAction;
        private final Map<Attribute, Double> baseStats = new TreeMap<Attribute, Double>(ModAttributes.SORTED);
        private final Map<Attribute, Double> statIncrease = new TreeMap<Attribute, Double>(ModAttributes.SORTED);
        private int baseLevel = 1;
        private int unique;
        private RelationShipState relationShipState = RelationShipState.DEFAULT;
        private final List<ResourceLocation> possibleChildIds = new ArrayList<ResourceLocation>();
        private final Map<ResourceLocation, QuestResponses> responses = new LinkedHashMap<ResourceLocation, QuestResponses>();
        private final Set<ResourceLocation> requiredQuests = new LinkedHashSet<ResourceLocation>();
        private final Map<String, String> translations = new LinkedHashMap<String, String>();

        public Builder(int weight) {
            this(weight, null, null, Gender.UNDEFINED);
        }

        public Builder(int weight, String name, Gender gender) {
            this(weight, name, null, gender);
        }

        public Builder(int weight, String name, String surname, Gender gender) {
            this.weight = weight;
            this.name = name;
            this.surname = surname;
            this.gender = gender;
            if (this.name != null) {
                this.neutralGiftResponse = "npc." + name.toLowerCase(Locale.ROOT) + ".default.gift";
            }
        }

        public Builder setNeutralGiftResponse(String neutralGiftResponse, String translation) {
            this.neutralGiftResponse = neutralGiftResponse;
            this.translations.put(this.neutralGiftResponse, translation);
            return this;
        }

        public Builder withLook(NPCLookId ... looks) {
            this.look = List.of(looks);
            return this;
        }

        public Builder withBirthday(Pair<EnumSeason, Integer> birthday) {
            this.birthday = birthday;
            return this;
        }

        public Builder withProfession(NPCJob ... professions) {
            this.professions.addAll(List.of(professions));
            return this;
        }

        public Builder addInteraction(ConversationContext convCtx, ResourceLocation conversationId) {
            this.interactions.put(convCtx, conversationId);
            return this;
        }

        public Builder addInteractionIfAbsent(ConversationContext convCtx, ResourceLocation conversationId) {
            this.interactions.putIfAbsent(convCtx, conversationId);
            return this;
        }

        public Builder addGiftResponse(String id, Gift gift, String translation) {
            this.giftItems.put(id, gift);
            this.translations.put(gift.responseKey, translation);
            return this;
        }

        public Builder addTranslation(String key, String translation) {
            this.translations.put(key, translation);
            return this;
        }

        public Builder withSchedule(NPCSchedule.Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder setBaseStat(Attribute attribute, double val) {
            this.baseStats.put(attribute, val);
            return this;
        }

        public Builder setStatIncrease(Attribute attribute, double val) {
            this.statIncrease.put(attribute, val);
            return this;
        }

        public Builder setBaseLevel(int level) {
            this.baseLevel = Math.max(1, level);
            return this;
        }

        public Builder setUnique(int amount) {
            this.unique = amount;
            return this;
        }

        public Builder relationState(RelationShipState state) {
            this.relationShipState = state;
            return this;
        }

        public Builder addChild(ResourceLocation child) {
            this.possibleChildIds.add(child);
            return this;
        }

        public Builder withCombatActions(ResourceLocation ... actions) {
            this.combatAction = List.of(actions);
            return this;
        }

        public Builder requiresQuest(ResourceLocation quest) {
            this.requiredQuests.add(quest);
            return this;
        }

        public Builder addQuestResponse(ResourceLocation quest, ResourceLocation startingID, ResourceLocation activeID, ResourceLocation endID) {
            this.responses.put(quest, new QuestResponses(startingID, activeID, endID));
            return this;
        }

        public Map<String, String> getTranslations() {
            return this.translations;
        }

        public NPCData build() {
            if (this.neutralGiftResponse == null) {
                throw new IllegalStateException("Neutral gift response not set.");
            }
            for (ConversationContext convCtx : ConversationContext.getRegistered()) {
                if (this.interactions.containsKey(convCtx)) continue;
                throw new IllegalStateException("Missing interactions for " + String.valueOf(convCtx));
            }
            return new NPCData(this.name, this.surname, this.gender, this.professions, this.look, this.birthday, this.weight, this.neutralGiftResponse, this.interactions, new QuestHandler(this.responses, this.requiredQuests), this.giftItems, this.schedule, this.baseStats.isEmpty() ? null : this.baseStats, this.statIncrease.isEmpty() ? null : this.statIncrease, this.baseLevel, this.combatAction, this.unique, this.relationShipState, this.possibleChildIds);
        }
    }
}

