/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.npc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureHolder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.Nullable;

public record NPCLook(NPCData.Gender gender, @Nullable String playerSkin, int weight, Map<NPCFeatureType<?>, NPCFeatureHolder<?>> additionalFeatures) {
    public static final ResourceLocation DEFAULT_LOOK_ID = new ResourceLocation("runecraftory", "default_look");
    public static final NPCLook DEFAULT_LOOK = new NPCLook(NPCData.Gender.MALE, null, 0, Map.of());
    public static final Codec<NPCLook> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.optionalFieldOf("player_skin").forGetter(d -> Optional.ofNullable(d.playerSkin)), (App)CodecUtils.stringEnumCodec(NPCData.Gender.class, (Enum)NPCData.Gender.UNDEFINED).fieldOf("gender").forGetter(d -> d.gender), (App)ExtraCodecs.f_144628_.fieldOf("weight").forGetter(d -> d.weight), (App)NPCFeature.CODEC.listOf().fieldOf("additional_features").forGetter(d -> List.copyOf(d.additionalFeatures.values()))).apply((Applicative)inst, (skin, gender, weight, features) -> new NPCLook((NPCData.Gender)((Object)((Object)gender)), skin.orElse(null), (int)weight, features.stream().collect(Collectors.toMap(NPCFeatureHolder::getType, h -> h, (e1, e2) -> e1, HashMap::new)))));

    public static NPCLook fromBuffer(FriendlyByteBuf buf) {
        String skin = null;
        if (buf.readBoolean()) {
            skin = buf.m_130277_();
        }
        return new NPCLook((NPCData.Gender)buf.m_130066_(NPCData.Gender.class), skin, buf.readInt(), Map.of());
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.writeBoolean(this.playerSkin != null);
        if (this.playerSkin != null) {
            buf.m_130070_(this.playerSkin);
        }
        buf.m_130068_((Enum)this.gender());
        buf.writeInt(this.weight());
    }
}

