/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GateSpawnData;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GateSpawnProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, GateSpawnData> data = new HashMap<ResourceLocation, GateSpawnData>();
    private final DataGenerator gen;

    public GateSpawnProvider(DataGenerator gen) {
        this.gen = gen;
    }

    protected abstract void add();

    public void m_6865_(HashCache cache) {
        this.add();
        this.data.forEach((res, spawnData) -> {
            Path path = this.gen.m_123916_().resolve("data/" + res.m_135827_() + "/gate_spawning/" + res.m_135815_() + ".json");
            try {
                JsonElement obj = (JsonElement)GateSpawnData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, spawnData).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                DataProvider.m_123920_((Gson)GsonInstances.GSON, (HashCache)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save itemstat {}", (Object)path, (Object)e);
            }
        });
    }

    public String m_6055_() {
        return "GateSpawns";
    }

    public void addGateSpawn(GateSpawnData spawnData) {
        this.addGateSpawn(spawnData.entity(), spawnData);
    }

    public void addGateSpawn(ResourceLocation key, GateSpawnData spawnData) {
        this.data.put(key, spawnData);
    }
}

