/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ItemStatProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, ItemStat.Builder> data = new HashMap<ResourceLocation, ItemStat.Builder>();
    private final Map<ResourceLocation, Consumer<JsonObject>> item = new HashMap<ResourceLocation, Consumer<JsonObject>>();
    private final DataGenerator gen;
    private final String modid;

    public ItemStatProvider(DataGenerator gen, String modid) {
        this.gen = gen;
        this.modid = modid;
    }

    protected abstract void add();

    public void m_6865_(HashCache cache) {
        this.add();
        this.data.forEach((res, builder) -> {
            Path path = this.gen.m_123916_().resolve("data/" + res.m_135827_() + "/item_stats/" + res.m_135815_() + ".json");
            try {
                JsonElement obj = (JsonElement)ItemStat.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)builder.build()).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                if (obj.isJsonObject()) {
                    this.item.get(res).accept(obj.getAsJsonObject());
                }
                DataProvider.m_123920_((Gson)GsonInstances.GSON, (HashCache)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save itemstat {}", (Object)path, (Object)e);
            }
        });
    }

    public String m_6055_() {
        return "ItemStats";
    }

    public void addStat(ItemLike item, int buy, int sell, int upgrade) {
        this.addStat(item, new ItemStat.Builder(buy, sell, upgrade));
    }

    public void addStat(String id, ItemLike item, int buy, int sell, int upgrade) {
        this.addStat(id, item, new ItemStat.Builder(buy, sell, upgrade));
    }

    public void addStat(ItemLike item, ItemStat.Builder builder) {
        this.addStat(Registry.f_122827_.m_7981_((Object)item.m_5456_()).m_135815_(), item, builder);
    }

    public void addStat(String id, ItemLike item, ItemStat.Builder builder) {
        ResourceLocation res = new ResourceLocation(this.modid, id);
        this.data.put(res, builder);
        this.item.put(res, obj -> obj.addProperty("item", Registry.f_122827_.m_7981_((Object)item.m_5456_()).toString()));
    }

    public void addStat(String id, TagKey<Item> tag, int buy, int sell, int upgrade) {
        this.addStat(id, tag, new ItemStat.Builder(buy, sell, upgrade));
    }

    public void addStat(String id, TagKey<Item> tag, ItemStat.Builder builder) {
        ResourceLocation res = new ResourceLocation(this.modid, id);
        this.data.put(res, builder);
        this.item.put(res, obj -> obj.addProperty("item", "#" + String.valueOf(tag.f_203868_())));
    }

    protected int calcBuyOf(double multiplier, ItemLike ... others) {
        return this.calcValueOf(multiplier, b -> b.buyPrice, (ResourceLocation[])Stream.of(others).map(other -> new ResourceLocation(this.modid, Registry.f_122827_.m_7981_((Object)other.m_5456_()).m_135815_())).toArray(ResourceLocation[]::new));
    }

    protected int calcSellOf(double multiplier, ItemLike ... others) {
        return this.calcValueOf(multiplier, b -> b.sellPrice, (ResourceLocation[])Stream.of(others).map(other -> new ResourceLocation(this.modid, Registry.f_122827_.m_7981_((Object)other.m_5456_()).m_135815_())).toArray(ResourceLocation[]::new));
    }

    protected int calcValueOf(double multiplier, ToIntFunction<ItemStat.Builder> agg, ResourceLocation ... others) {
        int price = 0;
        for (ResourceLocation other : others) {
            ItemStat.Builder s = this.data.get(other);
            if (s == null) continue;
            price += agg.applyAsInt(s);
        }
        return (int)((double)price * multiplier);
    }

    public static int truncate(double value) {
        if (value < 10.0) {
            return (int)value;
        }
        return (int)(value / 10.0) * 10;
    }
}

