/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.datapack.npc.ConversationSet;
import io.github.flemmli97.runecraftory.api.datapack.npc.GiftData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import io.github.flemmli97.runecraftory.api.datapack.provider.AdditionalLanguages;
import io.github.flemmli97.runecraftory.api.datapack.provider.FileVerifier;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.actions.NPCAttackActions;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class NPCDataProvider
implements DataProvider,
AdditionalLanguages {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, NPCLook> looks = new HashMap<ResourceLocation, NPCLook>();
    private final Map<ResourceLocation, ConversationSet> conversations = new HashMap<ResourceLocation, ConversationSet>();
    private final Map<ResourceLocation, GiftData> giftData = new LinkedHashMap<ResourceLocation, GiftData>();
    private final Map<ResourceLocation, NPCAttackActions> actions = new HashMap<ResourceLocation, NPCAttackActions>();
    private final Map<ResourceLocation, NPCData> data = new HashMap<ResourceLocation, NPCData>();
    public final Map<String, Map<String, String>> dialogueTranslations = new LinkedHashMap<String, Map<String, String>>();
    private final Map<String, String> translations = new LinkedHashMap<String, String>();
    private final DataGenerator gen;
    private final FileVerifier verifier;
    protected final String modid;

    public NPCDataProvider(DataGenerator gen, FileVerifier verifier, String modid) {
        this.gen = gen;
        this.verifier = verifier;
        this.modid = modid;
    }

    protected abstract void add();

    public void m_6865_(HashCache cache) {
        this.add();
        this.data.forEach((res, val) -> {
            Path path = this.gen.m_123916_().resolve("data/" + res.m_135827_() + "/npc_data/" + res.m_135815_() + ".json");
            this.verifyData((NPCData)val);
            try {
                JsonElement obj = (JsonElement)NPCData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, val).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                DataProvider.m_123920_((Gson)GsonInstances.GSON, (HashCache)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save npc data {}", (Object)path, (Object)e);
            }
        });
        this.looks.forEach((res, val) -> {
            Path path = this.gen.m_123916_().resolve("data/" + res.m_135827_() + "/npc_looks/" + res.m_135815_() + ".json");
            try {
                JsonElement obj = (JsonElement)NPCLook.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, val).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                DataProvider.m_123920_((Gson)GsonInstances.GSON, (HashCache)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save npc looks {}", (Object)path, (Object)e);
            }
        });
        this.conversations.forEach((res, val) -> {
            Path path = this.gen.m_123916_().resolve("data/" + res.m_135827_() + "/conversations/" + res.m_135815_() + ".json");
            try {
                JsonElement obj = (JsonElement)ConversationSet.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, val).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                DataProvider.m_123920_((Gson)GsonInstances.GSON, (HashCache)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save npc conversations {}", (Object)path, (Object)e);
            }
        });
        this.giftData.forEach((res, val) -> {
            Path path = this.gen.m_123916_().resolve("data/" + res.m_135827_() + "/npc_gifts/" + res.m_135815_() + ".json");
            try {
                JsonElement obj = (JsonElement)GiftData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, val).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                DataProvider.m_123920_((Gson)GsonInstances.GSON, (HashCache)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save gift data {}", (Object)path, (Object)e);
            }
        });
        this.actions.forEach((res, val) -> {
            Path path1 = this.gen.m_123916_().resolve("data/" + res.m_135827_() + "/npc_actions/" + res.m_135815_() + ".json");
            try {
                JsonElement obj = (JsonElement)NPCAttackActions.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, val).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                DataProvider.m_123920_((Gson)GsonInstances.GSON, (HashCache)cache, (JsonElement)obj, (Path)path1);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't combat action {}", (Object)path1, (Object)e);
            }
        });
    }

    public String m_6055_() {
        return "NPCData";
    }

    public void addNPCData(String id, NPCData.Builder data, Map<ConversationContext, ConversationSet.Builder> conversations, Map<ResourceLocation, QuestResponseBuilder> questConversations) {
        conversations.forEach((key, value) -> {
            ResourceLocation conversationId = new ResourceLocation(this.modid, id + "/" + key.key().m_135815_());
            this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.getTranslations());
            this.conversations.put(conversationId, value.build());
            data.addInteractionIfAbsent((ConversationContext)key, conversationId);
        });
        questConversations.forEach((key, value) -> {
            ResourceLocation startId = new ResourceLocation(this.modid, id + "/quest_start_" + key.m_135815_());
            for (int i = 0; i < value.start.size(); ++i) {
                Object path = startId.m_135815_();
                if (i != 0) {
                    path = (String)path + "_" + i;
                }
                ResourceLocation runIdI = new ResourceLocation(this.modid, (String)path);
                this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.start.get(i).getTranslations());
                this.conversations.put(runIdI, value.start.get(i).build());
            }
            ResourceLocation runId = new ResourceLocation(this.modid, id + "/quest_active_" + key.m_135815_());
            for (int i = 0; i < value.active.size(); ++i) {
                Object path = runId.m_135815_();
                if (i != 0) {
                    path = (String)path + "_" + i;
                }
                ResourceLocation runIdI = new ResourceLocation(this.modid, (String)path);
                this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.active.get(i).getTranslations());
                this.conversations.put(runIdI, value.active.get(i).build());
            }
            ResourceLocation endId = new ResourceLocation(this.modid, id + "/quest_end_" + key.m_135815_());
            this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.end.getTranslations());
            this.conversations.put(endId, value.end.build());
            data.addQuestResponse((ResourceLocation)key, startId, runId, endId);
        });
        this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(data.getTranslations());
        this.data.put(new ResourceLocation(this.modid, id), data.build());
    }

    public ResourceLocation addLook(ResourceLocation id, NPCLook look) {
        if (this.looks.put(id, look) != null) {
            throw new IllegalStateException("Look already registered");
        }
        this.verifier.track(id, PackType.SERVER_DATA, "npc_looks");
        return id;
    }

    public ResourceLocation addGiftData(ResourceLocation id, GiftData.Builder giftData) {
        if (this.giftData.put(id, giftData.build()) != null) {
            throw new IllegalStateException("GiftData already registered");
        }
        this.translations.putAll(giftData.translations);
        this.verifier.track(id, PackType.SERVER_DATA, "npc_gifts");
        return id;
    }

    public ResourceLocation addAttackActions(ResourceLocation id, NPCAttackActions.Builder actions) {
        if (this.actions.put(id, actions.build()) != null) {
            throw new IllegalStateException("Attack action already registered");
        }
        this.verifier.track(id, PackType.SERVER_DATA, "npc_actions");
        return id;
    }

    private void verifyData(NPCData data) {
        if (data.look() != null) {
            for (NPCData.NPCLookId look : data.look()) {
                if (this.verifier.exists(look.id(), PackType.SERVER_DATA, "npc_looks")) continue;
                throw new IllegalStateException("No look registered for " + String.valueOf(look.id()));
            }
        }
        if (data.combatActions() != null) {
            for (ResourceLocation action : data.combatActions()) {
                if (this.verifier.exists(action, PackType.SERVER_DATA, "npc_actions")) continue;
                throw new IllegalStateException("No npc action registered for " + String.valueOf(action));
            }
        }
        data.giftItems().forEach((s, g) -> {
            if (g.giftID() != null && !this.verifier.exists(g.giftID(), PackType.SERVER_DATA, "npc_gifts")) {
                throw new IllegalStateException("No gift registered for " + String.valueOf(g.giftID()));
            }
        });
    }

    @Override
    public Map<String, String> translations() {
        return this.translations;
    }

    public record QuestResponseBuilder(List<ConversationSet.Builder> start, List<ConversationSet.Builder> active, ConversationSet.Builder end) {
        public QuestResponseBuilder(ConversationSet.Builder start, ConversationSet.Builder active, ConversationSet.Builder end) {
            this(List.of(start), List.of(active), end);
        }
    }
}

