/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class NPCNameDataProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, NameStructure> names = new HashMap<String, NameStructure>();
    private final DataGenerator gen;
    private final String modid;

    public NPCNameDataProvider(DataGenerator gen, String modid) {
        this.gen = gen;
        this.modid = modid;
    }

    protected abstract void add();

    public void m_6865_(HashCache cache) {
        this.add();
        this.names.forEach((key, vals) -> {
            Path dataPath = this.gen.m_123916_().resolve(String.format("data/%1$s/%2$s/%3$s.json", this.modid, "names", key));
            try {
                JsonElement obj = GsonInstances.GSON.toJsonTree(vals);
                DataProvider.m_123920_((Gson)GsonInstances.GSON, (HashCache)cache, (JsonElement)obj, (Path)dataPath);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save npc names {}", (Object)dataPath, (Object)e);
            }
        });
    }

    public String m_6055_() {
        return "NPCNameData";
    }

    public void addFemaleName(String lang, String ... name) {
        this.names.computeIfAbsent((String)lang, (Function<String, NameStructure>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addFemaleName$1(java.lang.String ), (Ljava/lang/String;)Lio/github/flemmli97/runecraftory/api/datapack/provider/NPCNameDataProvider$NameStructure;)()).female_names.addAll(List.of(name));
    }

    public void addMaleName(String lang, String ... name) {
        this.names.computeIfAbsent((String)lang, (Function<String, NameStructure>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addMaleName$2(java.lang.String ), (Ljava/lang/String;)Lio/github/flemmli97/runecraftory/api/datapack/provider/NPCNameDataProvider$NameStructure;)()).male_names.addAll(List.of(name));
    }

    public void addSurname(String lang, String ... name) {
        this.names.computeIfAbsent((String)lang, (Function<String, NameStructure>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addSurname$3(java.lang.String ), (Ljava/lang/String;)Lio/github/flemmli97/runecraftory/api/datapack/provider/NPCNameDataProvider$NameStructure;)()).surnames.addAll(List.of(name));
    }

    private static /* synthetic */ NameStructure lambda$addSurname$3(String k) {
        return new NameStructure();
    }

    private static /* synthetic */ NameStructure lambda$addMaleName$2(String k) {
        return new NameStructure();
    }

    private static /* synthetic */ NameStructure lambda$addFemaleName$1(String k) {
        return new NameStructure();
    }

    private record NameStructure(List<String> surnames, List<String> male_names, List<String> female_names) {
        private NameStructure() {
            this(new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>());
        }
    }
}

