/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.datapack.ShopItemProperties;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ShopItemProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, Collection<ShopItemProperties.IntermediaryShopItem>> props = new HashMap<ResourceLocation, Collection<ShopItemProperties.IntermediaryShopItem>>();
    private final Map<ResourceLocation, Boolean> overwrite = new HashMap<ResourceLocation, Boolean>();
    private final DataGenerator gen;

    public ShopItemProvider(DataGenerator gen) {
        this.gen = gen;
    }

    protected abstract void add();

    public void m_6865_(HashCache cache) {
        this.add();
        this.props.forEach((res, builder) -> {
            Path path = this.gen.m_123916_().resolve("data/" + res.m_135827_() + "/shop_items/" + res.m_135815_() + ".json");
            try {
                JsonObject obj = new JsonObject();
                if (this.overwrite.getOrDefault(res, false).booleanValue()) {
                    obj.addProperty("replace", Boolean.valueOf(true));
                }
                JsonArray arr = new JsonArray();
                builder.forEach(prop -> arr.add((JsonElement)ShopItemProperties.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, prop).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0))));
                obj.add("values", (JsonElement)arr);
                DataProvider.m_123920_((Gson)GsonInstances.GSON, (HashCache)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save itemstat {}", (Object)path, (Object)e);
            }
        });
    }

    public String m_6055_() {
        return "ItemStats";
    }

    public void addItem(NPCJob shop, ItemLike item) {
        this.addItem(shop, item, ShopItemProperties.UnlockType.NEEDS_SHIPPING);
    }

    public void addItem(NPCJob shop, ItemLike item, ShopItemProperties.UnlockType unlockType) {
        this.addItem(shop, item, unlockType, EntityPredicate.f_36550_);
    }

    public void addItem(NPCJob shop, ItemLike item, ShopItemProperties.UnlockType unlockType, EntityPredicate predicate) {
        ResourceLocation res = ModNPCJobs.getIDFrom(shop);
        this.props.computeIfAbsent(new ResourceLocation(res.m_135827_(), res.m_135815_()), r -> new ArrayList()).add(new ShopItemProperties.IntermediaryShopItem(ShopItemProperties.MultiItemValue.of(item.m_5456_()), unlockType, predicate));
    }

    public void addItem(NPCJob shop, ItemStack item) {
        this.addItem(shop, item, ShopItemProperties.UnlockType.NEEDS_SHIPPING);
    }

    public void addItem(NPCJob shop, ItemStack item, ShopItemProperties.UnlockType unlockType) {
        this.addItem(shop, item, unlockType, EntityPredicate.f_36550_);
    }

    public void addItem(NPCJob shop, ItemStack item, ShopItemProperties.UnlockType unlockType, EntityPredicate predicate) {
        ResourceLocation res = ModNPCJobs.getIDFrom(shop);
        this.props.computeIfAbsent(new ResourceLocation(res.m_135827_(), res.m_135815_()), r -> new ArrayList()).add(new ShopItemProperties.IntermediaryShopItem(new ShopItemProperties.MultiItemValue(List.of(item)), unlockType, predicate));
    }

    public void addItem(NPCJob shop, TagKey<Item> tag) {
        this.addItem(shop, tag, ShopItemProperties.UnlockType.NEEDS_SHIPPING);
    }

    public void addItem(NPCJob shop, TagKey<Item> tag, ShopItemProperties.UnlockType unlockType) {
        this.addItem(shop, tag, unlockType, EntityPredicate.f_36550_);
    }

    public void addItem(NPCJob shop, TagKey<Item> tag, ShopItemProperties.UnlockType unlockType, EntityPredicate predicate) {
        ResourceLocation res = ModNPCJobs.getIDFrom(shop);
        this.props.computeIfAbsent(new ResourceLocation(res.m_135827_(), res.m_135815_()), r -> new ArrayList()).add(new ShopItemProperties.IntermediaryShopItem(new ShopItemProperties.MultiItemValue(tag), unlockType, predicate));
    }

    public void overwrite(NPCJob shop, boolean defaults) {
        ResourceLocation res = ModNPCJobs.getIDFrom(shop);
        this.overwrite.put(new ResourceLocation(res.m_135827_(), res.m_135815_() + (defaults ? "_defaults" : "")), true);
    }
}

