/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.datapack.provider.FileVerifier;
import io.github.flemmli97.runecraftory.common.datapack.manager.StructureBossManager;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class StructureBossProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, StructureBossManager.BossSpawnList> data = new HashMap<ResourceLocation, StructureBossManager.BossSpawnList>();
    private final DataGenerator gen;
    private final FileVerifier verifier;

    public StructureBossProvider(DataGenerator gen, FileVerifier verifier) {
        this.gen = gen;
        this.verifier = verifier;
    }

    protected abstract void add();

    public void m_6865_(HashCache cache) {
        this.add();
        this.data.forEach((res, spawnData) -> {
            Path path = this.gen.m_123916_().resolve("data/" + res.m_135827_() + "/runecraftory_bosses/" + res.m_135815_() + ".json");
            try {
                JsonElement obj = (JsonElement)StructureBossManager.BossSpawnList.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, spawnData).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                DataProvider.m_123920_((Gson)GsonInstances.GSON, (HashCache)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save itemstat {}", (Object)path, (Object)e);
            }
        });
    }

    public String m_6055_() {
        return "StructureBosses";
    }

    public void addGateSpawn(ResourceLocation key, StructureBossManager.BossSpawnList spawnData) {
        this.data.put(key, spawnData);
        this.verifier.track(key, PackType.SERVER_DATA, "runecraftory_bosses");
    }
}

