/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.enums;

import com.google.common.base.Suppliers;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public enum EnumElement {
    NONE(ChatFormatting.GRAY, "none", 0xFFFFFF, null),
    WATER(ChatFormatting.DARK_BLUE, "water", 0x101099, (Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.CRYSTAL_WATER.get()))),
    EARTH(ChatFormatting.YELLOW, "earth", 15132176, (Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.CRYSTAL_EARTH.get()))),
    WIND(ChatFormatting.GREEN, "wind", 0x55FF55, (Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.CRYSTAL_WIND.get()))),
    FIRE(ChatFormatting.DARK_RED, "fire", 0x991010, (Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.CRYSTAL_FIRE.get()))),
    LIGHT(ChatFormatting.WHITE, "light", 0xFFFF60, (Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.CRYSTAL_LIGHT.get()))),
    DARK(ChatFormatting.DARK_PURPLE, "dark", 8523906, (Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.CRYSTAL_DARK.get()))),
    LOVE(ChatFormatting.RED, "love", 16539900, (Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.CRYSTAL_LOVE.get())));

    public static final String PREFIX = "runecraftory.element.";
    private final String translation;
    private final ChatFormatting color;
    private final int particleColor;
    public final Supplier<ItemStack> icon;

    private EnumElement(ChatFormatting color, String key, int particleColor, Supplier<ItemStack> icon) {
        this.color = color;
        this.translation = PREFIX + key;
        this.particleColor = particleColor;
        this.icon = icon;
    }

    public static EnumElement opposing(EnumElement element) {
        switch (element) {
            case DARK: {
                return LIGHT;
            }
            case EARTH: {
                return WIND;
            }
            case FIRE: {
                return WATER;
            }
            case LIGHT: {
                return DARK;
            }
            case NONE: {
                return LOVE;
            }
            case WATER: {
                return FIRE;
            }
            case WIND: {
                return EARTH;
            }
        }
        return NONE;
    }

    public String getTranslation() {
        return this.translation;
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public int getParticleColor() {
        return this.particleColor;
    }
}

