/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.registry;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.platform.registry.CustomRegistryEntry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AttackAction
extends CustomRegistryEntry<AttackAction> {
    public static CombatUtils.EntityAttack spinAttack(LivingEntity entity, AnimatedAction anim, double startSec, double endSec, float startRot, float endRot, float range) {
        if (!entity.f_19853_.m_5776_() && anim.isBetween(startSec, endSec)) {
            float start = (float)(startSec * 20.0);
            float end = (float)(endSec * 20.0);
            float f = anim.progress(start, end, 1.0f, 0);
            float fNext = anim.progress(start, end, 1.0f, 1);
            float add = endRot - startRot;
            return CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.circleTargets(startRot + f * add, startRot + fNext * add, range));
        }
        return null;
    }

    public static CombatUtils.EntityAttack spinAttack(LivingEntity entity, AnimatedAction anim, double startSec, double endSec, float startRot, float endRot, CombatUtils.FloatMap xRot, float range) {
        if (!entity.f_19853_.m_5776_() && anim.isBetween(startSec, endSec)) {
            float start = (float)(startSec * 20.0);
            float end = (float)(endSec * 20.0);
            float f = anim.progress(start, end, 1.0f, 0);
            float fNext = anim.progress(start, end, 1.0f, 1);
            float add = endRot - startRot;
            CombatUtils.FloatMap xRot2 = p -> xRot.get(f + (fNext - f) * p);
            return CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.circleTargets(startRot + f * add, startRot + fNext * add, xRot2, range));
        }
        return null;
    }

    public AnimatedAction getAnimation(LivingEntity entity, int comboIdx) {
        return null;
    }

    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimatedAction anim) {
    }

    public void onSetup(LivingEntity entity, AttackActionHandler handler) {
    }

    public void onStart(LivingEntity entity, AttackActionHandler handler) {
        Level level;
        Spell spell = handler.get(DataKey.USED_SPELL);
        if (spell != null && !spell.delayedUse() && (level = entity.m_183503_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            entity.m_6674_(InteractionHand.MAIN_HAND);
            ItemStack stack = handler.get(DataKey.USED_WEAPON);
            if (spell.use(serverLevel, entity, stack) && entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                spell.levelSkill(player);
            }
        }
    }

    public AttackAction onChange(LivingEntity entity, AttackActionHandler handler) {
        this.onEnd(entity, handler);
        return null;
    }

    public void onEnd(LivingEntity entity, AttackActionHandler handler) {
    }

    public boolean isInvulnerable(LivingEntity entity, AttackActionHandler handler) {
        return false;
    }

    public boolean disableItemSwitch() {
        return true;
    }

    public float movementReduction(AnimatedAction current) {
        return 0.0f;
    }

    public Pose getPose(LivingEntity entity, AttackActionHandler handler) {
        return null;
    }

    public ComboContainer combos() {
        return null;
    }

    public boolean usableOnMounts(int targetCombo) {
        return true;
    }

    public static enum OverrideType {
        NONE,
        SCHEDULE,
        REPLACE;

    }
}

