/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.registry;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCAttackGoal;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.tenshilib.platform.registry.CustomRegistryEntry;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.Nullable;

public interface NPCAction {
    public static final NumberProvider CONST_ZERO = ConstantValue.m_165692_((float)0.0f);
    public static final NumberProvider CONST_ONE = ConstantValue.m_165692_((float)1.0f);
    public static final NumberProvider CONST_SEC = ConstantValue.m_165692_((float)20.0f);

    public static Optional<NumberProvider> asOpt(NumberProvider val, NumberProvider def) {
        return val.equals(def) ? Optional.empty() : Optional.of(val);
    }

    public static <T> RecordCodecBuilder<T, Optional<NumberProvider>> optionalNumCooldown(Function<T, NumberProvider> getter) {
        return NPCAction.optionalNum(getter, "cooldown", CONST_ZERO);
    }

    public static <T> RecordCodecBuilder<T, Optional<NumberProvider>> optionalNum(Function<T, NumberProvider> getter, String field, NumberProvider def) {
        Function<Object, Optional> optGetter = t -> {
            NumberProvider provider = (NumberProvider)getter.apply(t);
            if (provider.equals(def)) {
                return Optional.empty();
            }
            return Optional.of(provider);
        };
        return CodecHelper.NUMER_PROVIDER_CODEC.optionalFieldOf(field).forGetter(optGetter);
    }

    public static LootContext createLootContext(EntityNPCBase npc) {
        return new LootContext.Builder((ServerLevel)npc.m_183503_()).m_78972_(LootContextParams.f_81455_, (Object)npc).m_78972_(LootContextParams.f_81460_, (Object)npc.m_20182_()).m_78977_(npc.m_21187_()).m_78975_(LootContextParamSets.f_81419_);
    }

    public Supplier<NPCActionCodec> codec();

    public int getDuration(EntityNPCBase var1);

    public int getCooldown(EntityNPCBase var1);

    default public NPCAttackAction getAction(EntityNPCBase npc) {
        return null;
    }

    default public Spell getSpell() {
        return null;
    }

    public boolean doAction(EntityNPCBase var1, NPCAttackGoal<?> var2, @Nullable NPCAttackAction var3);

    public static class NPCActionCodec
    extends CustomRegistryEntry<NPCActionCodec> {
        public final Codec<NPCAction> codec;

        public NPCActionCodec(Codec<? extends NPCAction> codec) {
            this.codec = codec;
        }
    }

    public record NPCAttackAction(AttackAction action, int comboCount) {
        public static NPCAttackAction of(AttackAction action) {
            return new NPCAttackAction(action, 1);
        }
    }
}

