/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.registry;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.platform.registry.CustomRegistryEntry;
import java.util.Map;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class Spell
extends CustomRegistryEntry<Spell> {
    public static boolean tryUseWithCost(LivingEntity entity, ItemStack stack, Spell spell) {
        return Spell.tryUseWithCost(entity, stack, spell, 1.0f);
    }

    public static boolean tryUseWithCost(LivingEntity entity, ItemStack stack, Spell spell, float costMultiplier) {
        return Spell.tryUseWithCost(entity, stack, spell, costMultiplier, stack.m_41720_() instanceof ItemStaffBase);
    }

    public static boolean tryUseWithCost(LivingEntity entity, ItemStack stack, Spell spell, float costMultiplier, boolean hurt) {
        ServerPlayer player;
        return !(entity instanceof ServerPlayer) || Platform.INSTANCE.getPlayerData((Player)(player = (ServerPlayer)entity)).map(data -> {
            if (!LevelCalc.useRP((Player)player, data, (float)spell.rpCost() * costMultiplier, hurt, spell.percentageCost(), true, spell.costReductionSkills())) {
                if (!hurt) {
                    player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12507_, SoundSource.PLAYERS, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, 1.0f, 1.0f));
                }
                return false;
            }
            return true;
        }).orElse(false) != false;
    }

    public static void playSound(LivingEntity entity, SoundEvent sound, float volume, float pitch) {
        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), sound, entity.m_5720_(), volume, pitch);
    }

    public void update(Player player, ItemStack stack) {
    }

    public void levelSkill(ServerPlayer player) {
        Map<EnumSkills, Float> skillXp = DataPackHandler.INSTANCE.spellPropertiesManager().getPropertiesFor((Spell)this).skillXP;
        if (!skillXp.isEmpty()) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> skillXp.forEach((skill, xp) -> LevelCalc.levelSkill(player, data, EnumSkills.DARK, xp.floatValue())));
        }
    }

    public int coolDown() {
        return DataPackHandler.INSTANCE.spellPropertiesManager().getPropertiesFor((Spell)this).cooldown;
    }

    public int rpCost() {
        return DataPackHandler.INSTANCE.spellPropertiesManager().getPropertiesFor((Spell)this).rpCost;
    }

    public float percentageCost() {
        return DataPackHandler.INSTANCE.spellPropertiesManager().getPropertiesFor((Spell)this).percentage;
    }

    public EnumSkills[] costReductionSkills() {
        return (EnumSkills[])DataPackHandler.INSTANCE.spellPropertiesManager().getPropertiesFor((Spell)this).skills.toArray(EnumSkills[]::new);
    }

    public boolean use(LivingEntity entity) {
        Level level = entity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return this.use(serverLevel, entity, ItemStack.f_41583_);
        }
        return false;
    }

    public boolean use(LivingEntity entity, boolean ignoreSeal) {
        Level level = entity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return this.use(serverLevel, entity, ItemStack.f_41583_, ignoreSeal);
        }
        return false;
    }

    public boolean use(ServerLevel world, LivingEntity entity, ItemStack stack) {
        return this.use(world, entity, stack, false);
    }

    public boolean use(ServerLevel world, LivingEntity entity, ItemStack stack, boolean ignoreSeal) {
        if (!ignoreSeal && EntityUtils.sealed(entity)) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12507_, entity.m_5720_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1.0f, 0.7f));
            }
            return false;
        }
        return this.use(world, entity, stack, 1.0f, 1, CombatUtils.getSpellLevelFromStack(stack));
    }

    public abstract boolean use(ServerLevel var1, LivingEntity var2, ItemStack var3, float var4, int var5, int var6);

    public AttackAction useAction() {
        return (AttackAction)((Object)ModAttackActions.STAFF_USE.get());
    }

    public boolean canUse(ServerLevel world, LivingEntity entity, ItemStack stack) {
        return entity.m_20202_() == null || this.usableOnMounts();
    }

    public boolean delayedUse() {
        return true;
    }

    public boolean usableOnMounts() {
        return this.useAction().usableOnMounts(0);
    }

    public String toString() {
        return this.getRegistryName().toString();
    }
}

