/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.model.ArmorSimpleItemModel;
import io.github.flemmli97.runecraftory.client.model.armor.PiyoSandals;
import io.github.flemmli97.runecraftory.client.model.armor.RingsArmorModel;
import io.github.flemmli97.runecraftory.common.items.equipment.ItemArmorBase;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArmorModels {
    public static final Map<ResourceLocation, ArmorModelGetter> ARMOR_GETTER = ArmorModels.getArmorRenderer();
    private static final Map<ResourceLocation, FirstPersonArmorRenderer> FIRST_PERSON_GETTER = ArmorModels.getFirstPersonHandRenderer();
    private static final Map<String, ResourceLocation> ARMOR_TEXT_CACHE = new HashMap<String, ResourceLocation>();
    private static final ArmorSimpleItemModel ITEM_MODEL = new ArmorSimpleItemModel();
    private static PiyoSandals PIYO_SANDALS_MODEL;
    private static RingsArmorModel RINGS_MODEL;
    private static HumanoidModel<?> INNER;
    private static HumanoidModel<?> OUTER;

    private static Map<ResourceLocation, ArmorModelGetter> getArmorRenderer() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ModItems.MAGIC_EARRINGS.getID(), (entityLiving, itemStack, slot, origin) -> {
            origin.m_8009_(false);
            origin.f_102808_.f_104207_ = true;
            origin.f_102809_.f_104207_ = true;
            return null;
        });
        ArmorModelGetter bracelet = (entityLiving, itemStack, slot, origin) -> {
            AbstractClientPlayer clientPlayer;
            origin.m_8009_(false);
            boolean right = entityLiving.m_5737_() == HumanoidArm.RIGHT;
            ModelPart model = right ? origin.f_102811_ : origin.f_102812_;
            model.f_104207_ = true;
            if (entityLiving instanceof AbstractClientPlayer && (clientPlayer = (AbstractClientPlayer)entityLiving).m_108564_().equals("slim")) {
                model.f_104200_ = (float)((double)model.f_104200_ + (right ? 0.5 : -0.5));
            }
            return null;
        };
        for (RegistryEntrySupplier<Item> registryEntrySupplier : ArmorModels.bracelets()) {
            builder.put((Object)registryEntrySupplier.getID(), (Object)bracelet);
        }
        ArmorModelGetter normalItemModel = (entityLiving, itemStack, slot, origin) -> {
            ITEM_MODEL.setProperties(entityLiving, itemStack, origin.m_5585_(), ArmorSimpleItemModel.TRANSLATE_TO_HEAD);
            return ITEM_MODEL;
        };
        for (RegistryEntrySupplier<Item> registryEntrySupplier : ModItems.ribbons()) {
            builder.put((Object)registryEntrySupplier.getID(), (Object)normalItemModel);
        }
        builder.put((Object)ModItems.PIYO_SANDALS.getID(), (entityLiving, itemStack, slot, origin) -> {
            origin.m_102872_((HumanoidModel)PIYO_SANDALS_MODEL);
            PIYO_SANDALS_MODEL.m_8009_(false);
            ArmorModels.PIYO_SANDALS_MODEL.f_102814_.f_104207_ = true;
            ArmorModels.PIYO_SANDALS_MODEL.f_102813_.f_104207_ = true;
            return PIYO_SANDALS_MODEL;
        });
        for (RegistryEntrySupplier<Item> registryEntrySupplier : ModItems.hatItems()) {
            builder.put((Object)registryEntrySupplier.getID(), (Object)normalItemModel);
        }
        ArmorModelGetter armorModelGetter = (entityLiving, itemStack, slot, origin) -> {
            AbstractClientPlayer clientPlayer;
            origin.m_102872_((HumanoidModel)RINGS_MODEL);
            RINGS_MODEL.m_8009_(false);
            boolean right = entityLiving.m_5737_() == HumanoidArm.RIGHT;
            ModelPart model = right ? ArmorModels.RINGS_MODEL.f_102811_ : ArmorModels.RINGS_MODEL.f_102812_;
            model.f_104207_ = true;
            if (entityLiving instanceof AbstractClientPlayer && (clientPlayer = (AbstractClientPlayer)entityLiving).m_108564_().equals("slim")) {
                model.f_104200_ = (float)((double)model.f_104200_ + (right ? 0.5 : -0.5));
            }
            return RINGS_MODEL;
        };
        for (RegistryEntrySupplier<Item> sup : ArmorModels.rings()) {
            builder.put((Object)sup.getID(), (Object)armorModelGetter);
        }
        return builder.build();
    }

    private static Map<ResourceLocation, FirstPersonArmorRenderer> getFirstPersonHandRenderer() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        FirstPersonArmorRenderer bracelet = (player, stack, right, origin, poseStack, buffer, light) -> {
            origin.m_102872_(OUTER);
            OUTER.m_8009_(false);
            ModelPart model = right ? ArmorModels.OUTER.f_102811_ : ArmorModels.OUTER.f_102812_;
            model.f_104207_ = true;
            if (player.m_108564_().equals("slim")) {
                model.f_104200_ = (float)((double)model.f_104200_ + (right ? 0.5 : -0.5));
            }
            ArmorModels.renderModelPart(model, player, right, buffer, stack, poseStack, light);
        };
        for (RegistryEntrySupplier<Item> sup : ArmorModels.bracelets()) {
            builder.put((Object)sup.getID(), (Object)bracelet);
        }
        FirstPersonArmorRenderer rings = (player, stack, right, origin, poseStack, buffer, light) -> {
            origin.m_102872_((HumanoidModel)RINGS_MODEL);
            RINGS_MODEL.m_8009_(false);
            ModelPart model = right ? ArmorModels.RINGS_MODEL.f_102811_ : ArmorModels.RINGS_MODEL.f_102812_;
            model.f_104207_ = true;
            if (player.m_108564_().equals("slim")) {
                model.f_104200_ = (float)((double)model.f_104200_ + (right ? 0.5 : -0.5));
            }
            ArmorModels.renderModelPart(model, player, right, buffer, stack, poseStack, light);
        };
        for (RegistryEntrySupplier<Item> sup : ArmorModels.rings()) {
            builder.put((Object)sup.getID(), (Object)rings);
        }
        return builder.build();
    }

    private static VertexConsumer forArmor(MultiBufferSource buffer, ItemStack stack, Player player) {
        Item item = stack.m_41720_();
        if (item instanceof ItemArmorBase) {
            ItemArmorBase armor = (ItemArmorBase)item;
            return ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110431_((ResourceLocation)ARMOR_TEXT_CACHE.computeIfAbsent(armor.getArmorTexture(stack, (Entity)player, armor.m_40402_(), null), ResourceLocation::new)), (boolean)false, (boolean)stack.m_41790_());
        }
        return null;
    }

    private static void renderModelPart(ModelPart model, AbstractClientPlayer player, boolean right, MultiBufferSource buffer, ItemStack stack, PoseStack poseStack, int light) {
        VertexConsumer cons = ArmorModels.forArmor(buffer, stack, (Player)player);
        if (cons != null) {
            model.m_104301_(poseStack, cons, light, OverlayTexture.f_118083_);
        }
    }

    public static ArmorModelGetter fromItemStack(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ItemArmorBase) {
            ItemArmorBase armor = (ItemArmorBase)item;
            return ARMOR_GETTER.get(armor.registryID);
        }
        return null;
    }

    public static FirstPersonArmorRenderer getFirstPersonRenderer(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ItemArmorBase) {
            ItemArmorBase armor = (ItemArmorBase)item;
            return FIRST_PERSON_GETTER.get(armor.registryID);
        }
        return null;
    }

    public static HumanoidModel<?> getDefaultArmorModel(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS ? INNER : OUTER;
    }

    public static void initArmorModels(EntityRendererProvider.Context ctx) {
        INNER = new HumanoidModel(ctx.m_174023_(ModelLayers.f_171164_));
        OUTER = new HumanoidModel(ctx.m_174023_(ModelLayers.f_171165_));
        PIYO_SANDALS_MODEL = new PiyoSandals(ctx.m_174023_(PiyoSandals.LAYER_LOCATION));
        RINGS_MODEL = new RingsArmorModel(ctx.m_174023_(RingsArmorModel.LAYER_LOCATION));
    }

    private static List<RegistryEntrySupplier<Item>> bracelets() {
        return List.of(ModItems.CHEAP_BRACELET, ModItems.BRONZE_BRACELET, ModItems.SILVER_BRACELET, ModItems.GOLD_BRACELET, ModItems.PLATINUM_BRACELET);
    }

    private static List<RegistryEntrySupplier<Item>> rings() {
        return List.of(ModItems.SILVER_RING, ModItems.GOLD_RING, ModItems.PLATINUM_RING, ModItems.ENGAGEMENT_RING, ModItems.SHIELD_RING, ModItems.CRITICAL_RING, ModItems.SILENT_RING, ModItems.PARALYSIS_RING, ModItems.POISON_RING, ModItems.MAGIC_RING, ModItems.THROWING_RING, ModItems.STAY_UP_RING, ModItems.AQUAMARINE_RING, ModItems.AMETHYST_RING, ModItems.EMERALD_RING, ModItems.SAPPHIRE_RING, ModItems.RUBY_RING, ModItems.CURSED_RING, ModItems.DIAMOND_RING, ModItems.FIRE_RING, ModItems.WIND_RING, ModItems.WATER_RING, ModItems.EARTH_RING, ModItems.HAPPY_RING);
    }

    public static interface ArmorModelGetter {
        public Model getModel(LivingEntity var1, ItemStack var2, EquipmentSlot var3, HumanoidModel<?> var4);
    }

    public static interface FirstPersonArmorRenderer {
        public void render(AbstractClientPlayer var1, ItemStack var2, boolean var3, PlayerModel<?> var4, PoseStack var5, MultiBufferSource var6, int var7);
    }
}

