/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.mixin.SoundManagerAccessor;
import io.github.flemmli97.runecraftory.mixinhelper.SoundEngineUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import org.jetbrains.annotations.Nullable;

public class BossBarTracker {
    private static final Map<ResourceLocation, ClientBossBarType> BOSS_BARS = new HashMap<ResourceLocation, ClientBossBarType>();
    private static final Map<UUID, BossBarData> ACTIVE_BOSS_BARS = new HashMap<UUID, BossBarData>();
    private static final Map<UUID, BossSoundInstance> ACTIVE_BOSS_BGM = new HashMap<UUID, BossSoundInstance>();
    private static final Map<UUID, BossSoundInstance> FADING_CHANNEL = new HashMap<UUID, BossSoundInstance>();
    private static SoundInstance activeMusic;
    private static int lastPlay;
    private static int tick;

    public static void registerCustomBossbarType(ResourceLocation id, ClientBossBarType type) {
        BOSS_BARS.put(id, type);
    }

    public static void register() {
    }

    public static void tickSounds() {
        ++tick;
        FADING_CHANNEL.values().removeIf(BossSoundInstance::done);
    }

    public static void addActiveBossbar(UUID id, UUID musicID, ResourceLocation type, SoundEvent music) {
        BossBarData old = ACTIVE_BOSS_BARS.get(id);
        if (old != null) {
            BossSoundInstance sound;
            if (!(old.music == null || (sound = ACTIVE_BOSS_BGM.get(old.music)) == null || music != null && sound.m_7904_().equals((Object)music.m_11660_()))) {
                sound.instances.remove(id);
                if (sound.instances.isEmpty()) {
                    ACTIVE_BOSS_BGM.remove(old.music);
                }
                Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)sound);
                BossSoundInstance bgm = BossBarTracker.createSound(musicID, music);
                old.music = musicID;
                ACTIVE_BOSS_BGM.put(musicID, bgm);
                BossBarTracker.playMusic(bgm);
            }
            return;
        }
        BossSoundInstance inst = FADING_CHANNEL.get(musicID);
        if (inst != null) {
            inst.reverse(true);
        } else {
            BossSoundInstance existing = ACTIVE_BOSS_BGM.get(musicID);
            if (existing == null) {
                inst = BossBarTracker.createSound(musicID, music);
                BossBarTracker.playMusic(inst);
                inst.instances.add(id);
                ACTIVE_BOSS_BGM.put(musicID, inst);
            } else {
                existing.instances.add(id);
            }
        }
        BossBarData data = new BossBarData(type, musicID);
        ACTIVE_BOSS_BARS.put(id, data);
    }

    public static void updateMusic(UUID id, UUID musicID, boolean stop) {
        BossSoundInstance bgm = ACTIVE_BOSS_BGM.get(musicID);
        if (bgm != null) {
            if (stop) {
                bgm.instances.remove(id);
                if (bgm.instances.isEmpty()) {
                    BossBarTracker.stopMusic(bgm);
                }
            } else {
                boolean empty = bgm.instances.isEmpty();
                bgm.instances.add(id);
                if (empty) {
                    BossBarTracker.playMusic(bgm);
                }
            }
        }
    }

    public static void removeActiveBossbar(UUID id, boolean immediate) {
        BossBarData data = ACTIVE_BOSS_BARS.remove(id);
        if (data != null && data.music != null) {
            BossSoundInstance sound = ACTIVE_BOSS_BGM.get(data.music);
            if (sound == null) {
                return;
            }
            sound.instances.remove(id);
            if (!sound.instances.isEmpty()) {
                return;
            }
            ACTIVE_BOSS_BGM.remove(data.music);
            if (immediate || ClientConfig.bossMusicFadeDelay == 0) {
                FADING_CHANNEL.remove(data.music);
                BossBarTracker.stopMusic(sound);
            } else {
                BossSoundInstance inst = FADING_CHANNEL.get(data.music);
                if (inst != null) {
                    inst.reverse(false);
                } else {
                    FADING_CHANNEL.put(data.music, sound.reverse(false));
                }
            }
        }
    }

    public static int tryRenderCustomBossbar(PoseStack poseStack, int x, int y, BossEvent bossEvent, boolean withName) {
        ClientBossBarType type;
        BossBarData data = ACTIVE_BOSS_BARS.get(bossEvent.m_18860_());
        if (data != null && (type = BOSS_BARS.get(data.type)) != null) {
            return type.renderFrom(poseStack, x, y, bossEvent, withName);
        }
        return 0;
    }

    public static BossSoundInstance createSound(UUID id, SoundEvent sound) {
        if (sound == null || !ClientConfig.bossMusic) {
            return null;
        }
        return new BossSoundInstance(id, sound, SoundSource.RECORDS, 1.0f, 1.0f, ClientConfig.bossMusicFadeDelay);
    }

    private static void playMusic(BossSoundInstance sound) {
        if (lastPlay == tick) {
            return;
        }
        lastPlay = tick;
        if (activeMusic != null) {
            Minecraft.m_91087_().m_91106_().m_120399_(activeMusic);
        }
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
        activeMusic = sound;
    }

    private static void stopMusic(BossSoundInstance sound) {
        if (activeMusic == sound && sound.instances.isEmpty()) {
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)sound);
            ACTIVE_BOSS_BGM.values().stream().filter(bgm -> bgm != sound && !bgm.instances.isEmpty()).findFirst().ifPresent(bgm -> {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)bgm);
                activeMusic = bgm;
            });
        }
    }

    public static class BossBarData {
        public final ResourceLocation type;
        public UUID music;

        public BossBarData(ResourceLocation type, UUID music) {
            this.type = type;
            this.music = music;
        }
    }

    public static class BossSoundInstance
    extends AbstractTickableSoundInstance {
        public final UUID id;
        private final int fadeTime;
        private final float defaultVol;
        private final float volDecrease;
        private int tick = 1;
        private boolean reverse;
        private boolean fade;
        private final Set<UUID> instances = new HashSet<UUID>();

        public BossSoundInstance(UUID id, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch, int fadeTime) {
            super(soundEvent, soundSource);
            this.id = id;
            this.f_119573_ = volume;
            this.f_119574_ = pitch;
            this.fadeTime = fadeTime;
            this.defaultVol = Mth.m_14036_((float)(volume * BossSoundInstance.getVolume(soundSource)), (float)0.0f, (float)1.0f);
            this.volDecrease = 1.0f / (float)this.fadeTime;
            this.f_119578_ = true;
            this.f_119582_ = true;
        }

        private static float getVolume(@Nullable SoundSource category) {
            if (category == null || category == SoundSource.MASTER) {
                return 1.0f;
            }
            return Minecraft.m_91087_().f_91066_.m_92147_(category);
        }

        public BossSoundInstance reverse(boolean reverse) {
            this.reverse = reverse;
            this.tick = Mth.m_14045_((int)this.tick, (int)0, (int)this.fadeTime);
            this.fade = true;
            return this;
        }

        public boolean done() {
            return this.tick > this.fadeTime || this.tick < 0 || this.instances.isEmpty();
        }

        public void m_7788_() {
            if (!this.fade) {
                return;
            }
            if (this.instances.isEmpty()) {
                this.m_119609_();
                return;
            }
            boolean done = this.done();
            this.tick = this.reverse ? --this.tick : ++this.tick;
            this.f_119573_ = this.defaultVol * Mth.m_14036_((float)(1.0f - this.volDecrease * (float)this.tick), (float)0.0f, (float)1.0f);
            if (done) {
                if (!this.reverse) {
                    BossBarTracker.stopMusic(this);
                    this.f_119578_ = false;
                }
                this.fade = false;
            }
        }
    }

    public record ClientBossBarType(BossbarTexture texture, BossbarTexture overlay) {
        public int renderFrom(PoseStack poseStack, int x, int y, BossEvent bossEvent, boolean withName) {
            Minecraft mc = Minecraft.m_91087_();
            if (withName) {
                int screenX = mc.m_91268_().m_85445_();
                Component component = bossEvent.m_18861_();
                int len = mc.f_91062_.m_92852_((FormattedText)component);
                int txtX = screenX / 2 - len / 2;
                mc.f_91062_.m_92763_(poseStack, component, (float)txtX, (float)(y - 9), 0xFFFFFF);
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture.texture);
            GuiComponent.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)0, (float)this.texture.offsetX, (float)this.texture.offsetY, (int)this.texture.width, (int)this.texture.height, (int)256, (int)256);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.overlay.texture);
            int overlayWidth = (int)(bossEvent.m_142717_() * (float)this.overlay.width);
            GuiComponent.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)0, (float)this.overlay.offsetX, (float)this.overlay.offsetY, (int)overlayWidth, (int)this.overlay.height, (int)256, (int)256);
            Objects.requireNonNull(mc.f_91062_);
            return y + 9 + Math.max(this.texture.height, this.overlay.height) + 5;
        }
    }

    public record BossbarTexture(ResourceLocation texture, int width, int height, int offsetX, int offsetY) {
    }

    public static class TickingSoundChannel {
        private final SoundInstance inst;
        private final ChannelAccess.ChannelHandle channel;
        private final int fadeTime;
        private final float defaultVol;
        private final float volDecrease;
        private int tick;
        private boolean reverse;

        public TickingSoundChannel(SoundInstance inst, int fadeTime) {
            this.inst = inst;
            SoundEngineUtil engine = (SoundEngineUtil)((SoundManagerAccessor)Minecraft.m_91087_().m_91106_()).getSoundEngine();
            this.channel = engine.runecraftory$getHandle(inst);
            this.fadeTime = fadeTime;
            this.tick = 0;
            this.volDecrease = 1.0f / (float)this.fadeTime;
            this.defaultVol = TickingSoundChannel.calculateVolume(inst);
        }

        private static float calculateVolume(SoundInstance sound) {
            return Mth.m_14036_((float)(sound.m_7769_() * TickingSoundChannel.getVolume(sound.m_8070_())), (float)0.0f, (float)1.0f);
        }

        private static float getVolume(@Nullable SoundSource category) {
            if (category == null || category == SoundSource.MASTER) {
                return 1.0f;
            }
            return Minecraft.m_91087_().f_91066_.m_92147_(category);
        }

        public boolean tick() {
            boolean done;
            if (this.channel == null) {
                return true;
            }
            boolean bl = done = this.tick > this.fadeTime || this.tick < 0;
            this.tick = this.reverse ? --this.tick : ++this.tick;
            float vol = this.defaultVol * Mth.m_14036_((float)(1.0f - this.volDecrease * (float)this.tick), (float)0.0f, (float)1.0f);
            this.channel.m_120154_(ch -> ch.m_83666_(vol));
            if (!done || !this.reverse) {
                // empty if block
            }
            return done;
        }

        public void reverse(boolean reverse) {
            this.reverse = reverse;
        }
    }
}

