/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.enums.EnumWeather;
import io.github.flemmli97.runecraftory.client.AttackAABBRender;
import io.github.flemmli97.runecraftory.client.BossBarTracker;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.ShakeHandler;
import io.github.flemmli97.runecraftory.client.gui.widgets.SkillButton;
import io.github.flemmli97.runecraftory.client.tooltips.UpgradeTooltipComponent;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.items.MultiBlockItem;
import io.github.flemmli97.runecraftory.common.items.tools.ItemFertilizer;
import io.github.flemmli97.runecraftory.common.network.C2SOpenInfo;
import io.github.flemmli97.runecraftory.common.network.C2SRideJump;
import io.github.flemmli97.runecraftory.common.network.C2SSpellKey;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.mixin.ContainerScreenAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClientCalls {
    public static void clientTick() {
        BossBarTracker.tickSounds();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && Platform.INSTANCE.getPlayerData((Player)player).map(d -> d.getWeaponHandler().isItemSwapBlocked()).orElse(false).booleanValue()) {
            Options options = Minecraft.m_91087_().f_91066_;
            for (int i = 0; i < 9; ++i) {
                while (options.f_92056_[i].m_90859_()) {
                }
            }
            while (options.f_92093_.m_90859_()) {
            }
        }
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        switch (ClientHandlers.SPELL_1.onPress()) {
            case PRESSING: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(0, false));
                break;
            }
            case RELEASE: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(0, true));
            }
        }
        switch (ClientHandlers.SPELL_2.onPress()) {
            case PRESSING: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(1, false));
                break;
            }
            case RELEASE: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(1, true));
            }
        }
        switch (ClientHandlers.SPELL_3.onPress()) {
            case PRESSING: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(2, false));
                break;
            }
            case RELEASE: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(2, true));
            }
        }
        switch (ClientHandlers.SPELL_4.onPress()) {
            case PRESSING: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(3, false));
                break;
            }
            case RELEASE: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(3, true));
            }
        }
    }

    public static void initSkillTab(Screen screen, Consumer<AbstractWidget> cons) {
        if (ClientConfig.inventoryButton && (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen)) {
            int x = ((ContainerScreenAccessor)screen).getLeft();
            int y = ((ContainerScreenAccessor)screen).getTop();
            if (screen instanceof InventoryScreen) {
                x += ClientConfig.inventoryOffsetX;
                y += ClientConfig.inventoryOffsetY;
            } else {
                x += ClientConfig.creativeInventoryOffsetX;
                y += ClientConfig.creativeInventoryOffsetY;
            }
            cons.accept((AbstractWidget)new SkillButton(x, y, screen, b -> Platform.INSTANCE.sendToServer(new C2SOpenInfo(C2SOpenInfo.Type.MAIN))));
        }
    }

    public static void handleInputUpdate(Player player, Input input) {
        float reduction;
        if (EntityUtils.isDisabled((LivingEntity)player)) {
            input.f_108566_ = 0.0f;
            input.f_108567_ = 0.0f;
            input.f_108568_ = false;
            input.f_108569_ = false;
            input.f_108570_ = false;
            input.f_108571_ = false;
            input.f_108572_ = false;
            input.f_108573_ = false;
        }
        if ((reduction = Platform.INSTANCE.getPlayerData(player).map(d -> Float.valueOf(d.getWeaponHandler().movementReduction())).orElse(Float.valueOf(1.0f)).floatValue()) != 1.0f) {
            input.f_108566_ *= reduction;
            input.f_108567_ *= reduction;
            input.f_108572_ = false;
            if (reduction == 0.0f) {
                input.f_108568_ = false;
                input.f_108569_ = false;
                input.f_108570_ = false;
                input.f_108571_ = false;
                input.f_108573_ = false;
            }
        }
    }

    public static void renderScreenOverlays(PoseStack stack, float partialTicks) {
        if (ClientHandlers.OVERLAY != null) {
            ClientHandlers.OVERLAY.renderBar(stack);
        }
        if (ClientHandlers.SPELL_DISPLAY != null && ClientConfig.inventoryButton) {
            ClientHandlers.SPELL_DISPLAY.render(stack, partialTicks);
        }
        if (ClientHandlers.FARM_DISPLAY != null) {
            ClientHandlers.FARM_DISPLAY.render(stack);
        }
    }

    public static void tooltipEvent(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.m_41619_()) {
            boolean showTooltip = true;
            if (stack.m_41782_()) {
                Component component;
                CompoundTag tag = stack.m_41783_();
                if (tag.m_128425_("HideFlags", 99)) {
                    boolean bl = showTooltip = (stack.m_41783_().m_128451_("HideFlags") & 0x20) == 0;
                }
                if (tag.m_128469_("runecraftory").m_128441_("CraftingBonus") && (component = tooltip.get(0)) instanceof MutableComponent) {
                    MutableComponent mut = (MutableComponent)component;
                    mut.m_130940_(ChatFormatting.AQUA);
                }
            }
            if (showTooltip) {
                Pair<List<Component>, List<Component>> p = ClientCalls.injectAdditionalTooltip(stack, flag);
                tooltip.addAll(1, (Collection)p.getFirst());
                tooltip.addAll((Collection)p.getSecond());
            }
        }
    }

    private static Pair<List<Component>, List<Component>> injectAdditionalTooltip(ItemStack stack, TooltipFlag flag) {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        boolean shift = Screen.m_96638_();
        ArrayList<MutableComponent> debug = new ArrayList<MutableComponent>();
        DataPackHandler.INSTANCE.itemStatManager().get(stack.m_41720_()).ifPresent(stat -> {
            tooltip.addAll(stat.texts(stack, shift));
            if (flag.m_7050_()) {
                debug.add(new TranslatableComponent("runecraftory.tooltip.debug.stat", new Object[]{stat.getId().toString()}).m_130940_(ChatFormatting.GRAY));
            }
        });
        CropProperties props = DataPackHandler.INSTANCE.cropManager().get(stack.m_41720_());
        if (props != null) {
            tooltip.addAll(props.texts());
            if (flag.m_7050_()) {
                debug.add(new TranslatableComponent("runecraftory.tooltip.debug.crop", new Object[]{props.getId().toString()}).m_130940_(ChatFormatting.GRAY));
            }
        }
        if (shift) {
            FoodProperties food = DataPackHandler.INSTANCE.foodManager().get(stack.m_41720_());
            if (food != null) {
                tooltip.addAll(food.texts(stack));
                if (flag.m_7050_()) {
                    debug.add(new TranslatableComponent("runecraftory.tooltip.debug.food", new Object[]{food.getId().toString()}).m_130940_(ChatFormatting.GRAY));
                }
            } else if (stack.m_41614_()) {
                tooltip.add(new TranslatableComponent("runecraftory.tooltip.item.eaten").m_130940_(ChatFormatting.GRAY));
                MutableComponent comp = new TextComponent(" ").m_7220_((Component)new TranslatableComponent(((Attribute)ModAttributes.RPGAIN.get()).m_22087_())).m_7220_((Component)new TextComponent(": " + EntityUtils.getRPFromVanillaFood(stack)));
                tooltip.add(comp.m_130940_(ChatFormatting.AQUA));
            }
        }
        return Pair.of(tooltip, debug);
    }

    public static void tooltipComponentEvent(ItemStack stack, Consumer<TooltipComponent> elements, int screenWidth, int screenHeight) {
        if (UpgradeTooltipComponent.shouldAdd(stack)) {
            elements.accept(new UpgradeTooltipComponent.UpgradeComponent(stack));
        }
    }

    public static void worldRender(PoseStack stack) {
        BlockHitResult result;
        BlockHitResult hitResult;
        MultiBlockItem multiBlockItem;
        if (GeneralConfig.debugAttack) {
            AttackAABBRender.INST.render(stack, Minecraft.m_91087_().m_91269_().m_110108_());
        }
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBlockItem item = null;
        ItemStack main = minecraft.f_91074_.m_21205_();
        ItemStack off = minecraft.f_91074_.m_21205_();
        ItemStack toUse = main;
        InteractionHand hand = InteractionHand.MAIN_HAND;
        Item item2 = off.m_41720_();
        if (item2 instanceof MultiBlockItem) {
            multiBlockItem = (MultiBlockItem)item2;
            if (!(main.m_41720_() instanceof BlockItem)) {
                item = multiBlockItem;
                toUse = off;
                hand = InteractionHand.OFF_HAND;
            }
        }
        if ((item2 = main.m_41720_()) instanceof MultiBlockItem) {
            item = multiBlockItem = (MultiBlockItem)item2;
            toUse = main;
            hand = InteractionHand.OFF_HAND;
        }
        if (item == null) {
            return;
        }
        HitResult hitResult2 = minecraft.f_91077_;
        BlockHitResult blockHitResult = hitResult = hitResult2 instanceof BlockHitResult && (result = (BlockHitResult)hitResult2).m_6662_() != HitResult.Type.MISS ? result : null;
        if (hitResult != null) {
            BlockPlaceContext ctx = new BlockPlaceContext((Player)minecraft.f_91074_, hand, toUse, hitResult);
            BlockPos pos = ctx.m_8083_();
            Vec3 camPos = minecraft.f_91063_.m_109153_().m_90583_();
            double x = camPos.m_7096_();
            double y = camPos.m_7098_();
            double z = camPos.m_7094_();
            MultiBufferSource.BufferSource buffer = minecraft.m_91269_().m_110104_();
            VertexConsumer consumer = buffer.m_6299_(RenderType.m_110504_());
            boolean invalid = false;
            ArrayList<Pair> list = new ArrayList<Pair>();
            Rotation rot = EntityUtils.fromDirection(minecraft.f_91074_.m_6350_());
            for (Pair<BlockPos, BlockState> p : item.getBlocks()) {
                BlockPos offset = ((BlockPos)p.getFirst()).m_7954_(rot).m_141952_((Vec3i)pos);
                BlockState current = minecraft.f_91073_.m_8055_(offset);
                if (!current.m_60629_(ctx)) {
                    invalid = true;
                    list.add(Pair.of((Object)offset, (Object)Shapes.m_83040_()));
                    continue;
                }
                list.add(Pair.of((Object)offset, (Object)((BlockState)p.getSecond()).m_60717_(rot).m_60808_((BlockGetter)minecraft.f_91073_, offset).m_83216_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_())));
            }
            float gb = invalid ? 0.3f : 1.0f;
            for (Pair p : list) {
                if (p.getSecond() == Shapes.m_83040_()) continue;
                ClientCalls.renderBlockAt(stack, consumer, (VoxelShape)p.getSecond(), x, y, z, 1.0f, gb, gb, 1.0f, invalid);
            }
            buffer.m_109912_(RenderType.m_110504_());
        }
    }

    private static void renderBlockAt(PoseStack stack, VertexConsumer consumer, VoxelShape shape, double camX, double camY, double camZ, float r, float g, float b, float alpha, boolean invalid) {
        PoseStack.Pose pose = stack.m_85850_();
        shape.m_83224_((k, l, m, n, o, p) -> {
            float dX = (float)(n - k);
            float dY = (float)(o - l);
            float dZ = (float)(p - m);
            float len = Mth.m_14116_((float)(dX * dX + dY * dY + dZ * dZ));
            consumer.m_85982_(pose.m_85861_(), (float)(k - camX), (float)(l - camY), (float)(m - camZ)).m_85950_(r, g, b, alpha).m_85977_(pose.m_85864_(), dX /= len, dY /= len, dZ /= len).m_5752_();
            consumer.m_85982_(pose.m_85861_(), (float)(n - camX), (float)(o - camY), (float)(p - camZ)).m_85950_(r, g, b, alpha).m_85977_(pose.m_85864_(), dX, dY, dZ).m_5752_();
        });
    }

    public static void tick(LivingEntity entity) {
        Platform.INSTANCE.getEntityData(entity).ifPresent(data -> {
            int mod = entity.f_19797_ % 20;
            if (mod == 0 && data.isSleeping()) {
                entity.f_19853_.m_7106_((ParticleOptions)ModParticles.SLEEP.get(), entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() + 0.5, entity.m_20189_(), 0.0, 0.0, 0.0);
            }
            if (mod == 5 && data.isPoisoned()) {
                entity.f_19853_.m_7106_((ParticleOptions)ModParticles.POISON.get(), entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() + 0.1, entity.m_20189_(), 0.0, 0.0, 0.0);
            }
            if (data.isParalysed()) {
                boolean bl2;
                boolean bl = entity.m_20145_() ? entity.m_21187_().nextInt(25) == 0 : (bl2 = entity.m_21187_().nextInt(5) == 0);
                if (bl2) {
                    entity.f_19853_.m_7106_((ParticleOptions)ModParticles.PARALYSIS.get(), entity.m_20208_(0.5), entity.m_20187_(), entity.m_20262_(0.5), 0.05, 0.05, 0.05);
                }
            }
        });
        if (entity == Minecraft.m_91087_().f_91074_) {
            --ShakeHandler.shakeTick;
            if (entity.m_20202_() instanceof BaseMonster && Minecraft.m_91087_().f_91074_.f_108618_.f_108572_) {
                Platform.INSTANCE.sendToServer(new C2SRideJump());
            }
        }
        if (entity == Minecraft.m_91087_().f_91075_ && ClientHandlers.CLIENT_CALENDAR.currentWeather() == EnumWeather.RUNEY) {
            int tries = Minecraft.m_91087_().f_91066_.f_92073_ != ParticleStatus.ALL ? 1 : 2;
            for (int i = 0; i < tries; ++i) {
                entity.f_19853_.m_7106_((ParticleOptions)ModParticles.RUNEY.get(), entity.m_20185_() + (entity.m_21187_().nextDouble() - 0.5) * 24.0, entity.m_20186_() + (entity.m_21187_().nextDouble() - 0.5) * 12.0, entity.m_20189_() + (entity.m_21187_().nextDouble() - 0.5) * 24.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static boolean invis(LivingEntity entity) {
        return Platform.INSTANCE.getEntityData(entity).map(EntityData::isInvis).orElse(false);
    }

    public static void renderShaking(Camera camera, float yaw, float pitch, float roll, float partialTicks, Consumer<Float> setYaw, Consumer<Float> setPitch, Consumer<Float> setRoll) {
        int t;
        boolean stunned = Minecraft.m_91087_().f_91074_.m_21023_((MobEffect)ModEffects.STUNNED.get());
        if (stunned) {
            float pT = (float)(Minecraft.m_91087_().f_91074_.f_19797_ * 10) - partialTicks;
            setYaw.accept(Float.valueOf(yaw + Mth.m_14031_((float)pT) * 0.5f));
            setPitch.accept(Float.valueOf(pitch + Mth.m_14031_((float)(pT * 2.0f)) * 1.0f));
        }
        if ((t = ShakeHandler.shakeTick) <= 0) {
            return;
        }
        float strengthPitch = ShakeHandler.shakeStrength;
        float strengthRoll = ShakeHandler.shakeStrength;
        float pT = (float)(t * 24) - partialTicks;
        setPitch.accept(Float.valueOf(pitch + Mth.m_14031_((float)(pT * 2.0f)) * strengthPitch));
        setRoll.accept(Float.valueOf(roll + Mth.m_14031_((float)pT) * strengthRoll));
    }

    public static void renderEntityShake(LivingEntity entity, PoseStack stack, float partialTicks) {
        boolean stunned = Platform.INSTANCE.getEntityData(entity).map(EntityData::isStunned).orElse(false);
        if (!stunned) {
            return;
        }
        Vec3 dir = Vec3.m_82498_((float)0.0f, (float)(entity.m_5675_(partialTicks) + 90.0f)).m_82490_(0.1);
        float pT = (float)(Minecraft.m_91087_().f_91074_.f_19797_ * 10) - partialTicks;
        stack.m_85837_((double)Mth.m_14031_((float)pT) * dir.m_7096_(), 0.0, (double)Mth.m_14031_((float)pT) * dir.m_7094_());
    }

    public static boolean onBlockHighlightRender(Level level, PoseStack poseStack, VertexConsumer consumer, Entity entity, double camX, double camY, double camZ, BlockPos pos, BlockState state) {
        LivingEntity living;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_().m_41720_() instanceof ItemFertilizer) {
            boolean targetingCrop = level.m_8055_(pos).m_60734_() instanceof BushBlock;
            ItemFertilizer.getOtherForTargeted(entity.m_6350_(), pos).forEach(p -> {
                BlockState state1 = level.m_8055_(p);
                if (targetingCrop && state1.m_60795_()) {
                    p = p.m_7495_();
                    state1 = level.m_8055_(p);
                }
                if (!state1.m_60795_() && level.m_6857_().m_61937_(p)) {
                    ClientCalls.renderShape(poseStack, consumer, state1.m_60651_((BlockGetter)level, p, CollisionContext.m_82750_((Entity)entity)), (double)p.m_123341_() - camX, (double)p.m_123342_() - camY, (double)p.m_123343_() - camZ, 0.0f, 0.0f, 0.0f, 0.4f);
                }
            });
        }
        return false;
    }

    private static void renderShape(PoseStack poseStack, VertexConsumer consumer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        PoseStack.Pose pose = poseStack.m_85850_();
        shape.m_83224_((k, l, m, n, o, p) -> {
            float q = (float)(n - k);
            float r = (float)(o - l);
            float s = (float)(p - m);
            float t = Mth.m_14116_((float)(q * q + r * r + s * s));
            consumer.m_85982_(pose.m_85861_(), (float)(k + x), (float)(l + y), (float)(m + z)).m_85950_(red, green, blue, alpha).m_85977_(pose.m_85864_(), q /= t, r /= t, s /= t).m_5752_();
            consumer.m_85982_(pose.m_85861_(), (float)(n + x), (float)(o + y), (float)(p + z)).m_85950_(red, green, blue, alpha).m_85977_(pose.m_85864_(), q, r, s).m_5752_();
        });
    }
}

