/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import io.github.flemmli97.runecraftory.common.world.farming.FarmlandDataContainer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;

public class ClientFarmlandHandler {
    public static final ClientFarmlandHandler INSTANCE = new ClientFarmlandHandler();
    private final Long2ObjectMap<FarmlandDataContainer> farmland = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<Set<FarmlandDataContainer>> farmlandChunks = new Long2ObjectOpenHashMap();

    private ClientFarmlandHandler() {
    }

    @Nullable
    public FarmlandDataContainer getData(BlockPos pos) {
        return (FarmlandDataContainer)this.farmland.get(pos.m_121878_());
    }

    public void updateChunk(long packedChunk, List<FarmlandDataContainer> list) {
        Set chunkMap = (Set)this.farmlandChunks.computeIfAbsent(packedChunk, key -> new HashSet());
        list.forEach(d -> {
            this.farmland.put(d.pos().m_121878_(), d);
            chunkMap.add(d);
        });
    }

    public void onChunkUnLoad(ChunkPos pos) {
        Set farms = (Set)this.farmlandChunks.get(pos.m_45588_());
        if (farms != null) {
            farms.forEach(d -> this.farmland.remove(d.pos().m_121878_()));
            this.farmlandChunks.remove(pos.m_45588_());
        }
    }

    public void onFarmBlockRemove(BlockPos pos) {
        long packedChunk;
        Set farms;
        FarmlandDataContainer cont = (FarmlandDataContainer)this.farmland.remove(pos.m_121878_());
        if (cont != null && (farms = (Set)this.farmlandChunks.get(packedChunk = new ChunkPos(pos).m_45588_())) != null) {
            farms.remove(cont);
            if (farms.isEmpty()) {
                this.farmlandChunks.remove(packedChunk);
            }
        }
    }

    public void onDisconnect() {
        this.farmland.clear();
        this.farmlandChunks.clear();
    }
}

