/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.runecraftory.client.ArmorModels;
import io.github.flemmli97.runecraftory.client.TriggerKeyBind;
import io.github.flemmli97.runecraftory.client.gui.CraftingGui;
import io.github.flemmli97.runecraftory.client.gui.FarmlandInfo;
import io.github.flemmli97.runecraftory.client.gui.InfoScreen;
import io.github.flemmli97.runecraftory.client.gui.MonsterCompanionGui;
import io.github.flemmli97.runecraftory.client.gui.NPCCompanionGui;
import io.github.flemmli97.runecraftory.client.gui.NPCDialogueGui;
import io.github.flemmli97.runecraftory.client.gui.NPCGui;
import io.github.flemmli97.runecraftory.client.gui.NPCShopGui;
import io.github.flemmli97.runecraftory.client.gui.OverlayGui;
import io.github.flemmli97.runecraftory.client.gui.QuestGui;
import io.github.flemmli97.runecraftory.client.gui.SpawnEggScreen;
import io.github.flemmli97.runecraftory.client.gui.SpellInvOverlayGui;
import io.github.flemmli97.runecraftory.client.gui.widgets.QuestToast;
import io.github.flemmli97.runecraftory.client.model.AnimatedPlayerModel;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.client.render.ScaledRenderer;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.job.ShopState;
import io.github.flemmli97.runecraftory.common.network.S2CTriggers;
import io.github.flemmli97.runecraftory.common.quests.ClientSideQuestDisplay;
import io.github.flemmli97.runecraftory.common.utils.CalendarImpl;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.world.family.SyncedFamilyData;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.toasts.RecipeToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;

public class ClientHandlers {
    public static final CalendarImpl CLIENT_CALENDAR = new CalendarImpl();
    public static OverlayGui OVERLAY;
    public static SpellInvOverlayGui SPELL_DISPLAY;
    public static FarmlandInfo FARM_DISPLAY;
    public static TriggerKeyBind SPELL_1;
    public static TriggerKeyBind SPELL_2;
    public static TriggerKeyBind SPELL_3;
    public static TriggerKeyBind SPELL_4;
    private static AnimatedPlayerModel<?> ANIMATED_PLAYER_MODEL;
    private static CameraType pastType;
    private static boolean paused;
    private static float pausedPartial;

    public static Player getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static float getPartialTicks() {
        boolean isPaused = Minecraft.m_91087_().m_91104_();
        if (isPaused && !paused) {
            pausedPartial = Minecraft.m_91087_().m_91296_();
        }
        paused = isPaused;
        return isPaused ? pausedPartial : Minecraft.m_91087_().m_91296_();
    }

    public static void updateClientCalendar(FriendlyByteBuf buffer) {
        EnumSeason prev = CLIENT_CALENDAR.currentSeason();
        CLIENT_CALENDAR.fromPacket(buffer);
        if (CLIENT_CALENDAR.currentSeason() != prev) {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            if (mc.f_91073_ != null) {
                int renderDist = mc.f_91066_.m_193772_();
                for (int x = -renderDist; x <= renderDist; ++x) {
                    for (int y = level.m_151560_(); y < level.m_151559_(); ++y) {
                        for (int z = -renderDist; z <= renderDist; ++z) {
                            mc.f_91060_.m_109770_(x, y, z);
                        }
                    }
                }
            }
        }
    }

    public static void grabMouse(LivingEntity entity, boolean sleeping) {
        if (entity == Minecraft.m_91087_().f_91074_ && Minecraft.m_91087_().f_91080_ == null) {
            Minecraft.m_91087_().f_91067_.m_91601_();
            if (sleeping) {
                KeyMapping.m_90847_();
            }
        }
    }

    public static boolean disableMouseMove() {
        Minecraft mc = Minecraft.m_91087_();
        return !(mc.f_91074_ == null || !EntityUtils.isDisabled((LivingEntity)mc.f_91074_) && Platform.INSTANCE.getPlayerData((Player)mc.f_91074_).map(d -> d.getWeaponHandler().get(DataKey.FIXED_LOOK)).orElse(false) == false || mc.f_91080_ != null && !(mc.f_91080_ instanceof AbstractContainerScreen));
    }

    public static boolean disableMouseClick() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91074_ != null && EntityUtils.isDisabled((LivingEntity)mc.f_91074_) && (mc.f_91080_ == null || mc.f_91080_ instanceof AbstractContainerScreen);
    }

    public static boolean disableScrollMouse() {
        Minecraft mc = Minecraft.m_91087_();
        return !(mc.f_91074_ == null || !EntityUtils.isDisabled((LivingEntity)mc.f_91074_) && Platform.INSTANCE.getPlayerData((Player)mc.f_91074_).map(d -> d.getWeaponHandler().isItemSwapBlocked()).orElse(false) == false || mc.f_91080_ != null && !(mc.f_91080_ instanceof AbstractContainerScreen));
    }

    public static boolean disableKeys(int key, int scanCode) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91080_ instanceof ChatScreen) {
            return false;
        }
        return key != 256 && !mc.f_91066_.f_92092_.m_90832_(key, scanCode) && !mc.f_91066_.f_92098_.m_90832_(key, scanCode) && !mc.f_91066_.f_92100_.m_90832_(key, scanCode) && EntityUtils.isDisabled((LivingEntity)mc.f_91074_);
    }

    public static void recipeToast(Collection<ResourceLocation> recipes) {
        recipes.forEach(res -> Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(res).ifPresent(rec -> RecipeToast.m_94817_((ToastComponent)Minecraft.m_91087_().m_91300_(), (Recipe)rec)));
    }

    public static void simpleToast(Component title, Component subtitle) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new QuestToast(title, subtitle));
    }

    public static void setToThirdPerson(boolean reset) {
        if (reset) {
            Minecraft.m_91087_().f_91066_.m_92157_(pastType);
        } else {
            pastType = Minecraft.m_91087_().f_91066_.m_92176_();
            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
        }
    }

    public static void trySetPerspective(LivingEntity entity, boolean flag) {
        if (entity == Minecraft.m_91087_().m_91288_()) {
            ClientHandlers.setToThirdPerson(!flag);
        }
    }

    public static boolean orthorgraphicCam() {
        Entity entity = Minecraft.m_91087_().m_91288_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return Platform.INSTANCE.getEntityData(living).map(EntityData::isOrthoView).orElse(false);
        }
        return false;
    }

    public static void openCompanionGui(int id, boolean fullParty, boolean hasHome) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(id);
        if (entity instanceof BaseMonster) {
            BaseMonster monster = (BaseMonster)entity;
            if (!Minecraft.m_91087_().f_91074_.m_142081_().equals(monster.m_142504_())) {
                return;
            }
            Minecraft.m_91087_().m_91152_((Screen)new MonsterCompanionGui(monster, fullParty, hasHome));
        }
    }

    public static void openNPCChat(int id, ShopState isShopOpen, SyncedFamilyData family, int followState, Map<String, List<Component>> actions, ResourceLocation quest) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(id);
        if (entity instanceof EntityNPCBase) {
            EntityNPCBase npc = (EntityNPCBase)entity;
            if (followState == 1) {
                Minecraft.m_91087_().m_91152_((Screen)new NPCCompanionGui(npc, isShopOpen == ShopState.OPEN, quest));
            } else {
                Minecraft.m_91087_().m_91152_(new NPCGui<EntityNPCBase>(npc, isShopOpen, followState == 0, family, actions, quest));
            }
        }
    }

    public static void drawCenteredScaledString(PoseStack stack, Font font, Component component, float x, float y, float scale, int color) {
        if (scale != 1.0f) {
            stack.m_85836_();
            stack.m_85837_((double)x, (double)y, 0.0);
            stack.m_85841_(scale, scale, scale);
            stack.m_85837_((double)(-font.m_92852_((FormattedText)component)) * 0.5, 0.0, 0.0);
            font.m_92889_(stack, component, 0.0f, 0.0f, color);
            stack.m_85849_();
        } else {
            x = (float)((double)x - (double)font.m_92852_((FormattedText)component) * 0.5);
            font.m_92889_(stack, component, x, y, color);
        }
    }

    public static void drawCenteredScaledString(PoseStack stack, Font font, String string, float x, float y, float scale, int color) {
        if (scale != 1.0f) {
            stack.m_85836_();
            stack.m_85837_((double)x, (double)y, 0.0);
            stack.m_85841_(scale, scale, scale);
            stack.m_85837_((double)(-font.m_92895_(string)) * 0.5, 0.0, 0.0);
            font.m_92883_(stack, string, 0.0f, 0.0f, color);
            stack.m_85849_();
        } else {
            x = (float)((double)x - (double)font.m_92895_(string) * 0.5);
            font.m_92883_(stack, string, x, y, color);
        }
    }

    public static void drawRightAlignedScaledString(PoseStack stack, Font font, Component string, float x, float y, float scale, int color) {
        if (scale != 1.0f) {
            stack.m_85836_();
            stack.m_85837_((double)x, (double)y, 0.0);
            stack.m_85841_(scale, scale, scale);
            stack.m_85837_((double)(-font.m_92852_((FormattedText)string)), 0.0, 0.0);
            font.m_92889_(stack, string, 0.0f, 0.0f, color);
            stack.m_85849_();
        } else {
            font.m_92889_(stack, string, x -= (float)font.m_92852_((FormattedText)string), y, color);
        }
    }

    public static void drawRightAlignedScaledString(PoseStack stack, Font font, String string, float x, float y, float scale, int color) {
        if (scale != 1.0f) {
            stack.m_85836_();
            stack.m_85837_((double)x, (double)y, 0.0);
            stack.m_85841_(scale, scale, scale);
            stack.m_85837_((double)(-font.m_92895_(string)), 0.0, 0.0);
            font.m_92883_(stack, string, 0.0f, 0.0f, color);
            stack.m_85849_();
        } else {
            font.m_92883_(stack, string, x -= (float)font.m_92895_(string), y, color);
        }
    }

    public static void handleShopRespone(Component txt) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof NPCShopGui) {
            NPCShopGui shop = (NPCShopGui)screen;
            if (txt != null) {
                shop.drawBubble(txt);
            } else {
                shop.updateButtons();
            }
        }
    }

    public static AnimatedPlayerModel<?> getAnimatedPlayerModel() {
        return ANIMATED_PLAYER_MODEL;
    }

    public static void initNonRendererModels(EntityRendererProvider.Context ctx) {
        ANIMATED_PLAYER_MODEL = new AnimatedPlayerModel(ctx.m_174023_(AnimatedPlayerModel.LAYER_LOCATION));
        ArmorModels.initArmorModels(ctx);
    }

    public static void updateCurrentRecipeIndex(int index) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof CraftingGui) {
            CraftingGui gui = (CraftingGui)screen;
            gui.setScrollValue(index);
        }
    }

    public static void onAttributePkt() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof InfoScreen) {
            InfoScreen screen2 = (InfoScreen)screen;
            screen2.onAttributePkt();
        }
    }

    public static void handleTriggers(S2CTriggers.Type type, BlockPos pos) {
        switch (type) {
            case FERTILIZER: {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                double x = (double)pos.m_123341_() + 0.5;
                double y = (double)pos.m_123342_() + 1.25;
                double z = (double)pos.m_123343_() + 0.5;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 0.0, 0.0, 0.0);
                Random random = level.m_5822_();
                for (int i = 0; i < 15; ++i) {
                    double nZ;
                    double nY;
                    double nX = x - 0.5 + random.nextDouble();
                    if (level.m_8055_(new BlockPos(nX, nY = y - 0.35 + random.nextDouble() * 0.5, nZ = z - 0.5 + random.nextDouble()).m_7495_()).m_60795_()) continue;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123748_, nX, nY, nZ, random.nextGaussian() * 0.02, random.nextGaussian() * 0.02, random.nextGaussian() * 0.02);
                }
                break;
            }
        }
    }

    public static void updateNPCDialogue(EntityNPCBase npc, ConversationContext convCtx, String conversationID, Component component, Map<String, Component> data, List<Component> actions) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof NPCDialogueGui) {
            NPCDialogueGui gui = (NPCDialogueGui)screen;
            gui.updateConversation(Minecraft.m_91087_(), convCtx, conversationID, component, data, actions);
        } else {
            NPCDialogueGui<EntityNPCBase> gui = new NPCDialogueGui<EntityNPCBase>(npc);
            gui.updateConversation(Minecraft.m_91087_(), convCtx, conversationID, component, data, actions);
            Minecraft.m_91087_().m_91152_(gui);
        }
    }

    public static void openQuestGui(boolean hasActive, List<ClientSideQuestDisplay> quests) {
        Minecraft.m_91087_().m_91152_((Screen)new QuestGui(hasActive, quests));
    }

    public static void openSpawneggGui(InteractionHand hand) {
        Minecraft.m_91087_().m_91152_((Screen)new SpawnEggScreen(hand));
    }

    public static void translateRider(EntityRenderer<?> entityRenderer, Entity rider, EntityModel<?> model, PoseStack poseStack) {
        LivingEntity living;
        float scale = 1.0f;
        if (entityRenderer instanceof ScaledRenderer) {
            ScaledRenderer scaledRender = (ScaledRenderer)entityRenderer;
            scale = scaledRender.getScale();
        }
        if (scale != 1.0f) {
            poseStack.m_85841_(1.0f / scale, 1.0f / scale, 1.0f / scale);
        }
        if (model instanceof SittingModel) {
            SittingModel sittingModel = (SittingModel)model;
            sittingModel.translateSittingPosition(poseStack);
        } else if (rider instanceof LivingEntity && (living = (LivingEntity)rider).m_6162_()) {
            poseStack.m_85837_(0.0, 0.3125, 0.0);
        } else {
            poseStack.m_85837_(0.0, 0.6875, 0.0);
        }
        if (scale != 1.0f) {
            poseStack.m_85841_(scale, scale, scale);
        }
    }

    static {
        pastType = CameraType.FIRST_PERSON;
    }
}

