/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class NPCDialogueLanguageManager {
    public static final NPCDialogueLanguageManager INSTANCE = new NPCDialogueLanguageManager();
    public static final String DIRECTORY = "lang/npc_conversations";
    private Map<String, String> translations = new HashMap<String, String>();

    private NPCDialogueLanguageManager() {
    }

    private static Map<String, String> loadFrom(ResourceManager resourceManager, List<LanguageInfo> languageInfo) {
        HashMap translations = new HashMap();
        HashMap result = new HashMap();
        List<String> codes = languageInfo.stream().map(LanguageInfo::getCode).toList();
        for (ResourceLocation res : resourceManager.m_6540_(DIRECTORY, p -> p.endsWith(".json"))) {
            String[] dirs = res.m_135815_().split("/");
            String lang = dirs[dirs.length - 1].replace(".json", "");
            if (!codes.contains(lang)) continue;
            HashMap map = new HashMap();
            try {
                for (Resource resource : resourceManager.m_7396_(res)) {
                    InputStream inputStream = resource.m_6679_();
                    try {
                        Language.m_128108_((InputStream)inputStream, map::put);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
            }
            catch (IOException iOException) {
                RuneCraftory.LOGGER.warn("Failed to load dialog translations for language {}", (Object)lang, (Object)iOException);
            }
            translations.computeIfAbsent(lang, k -> new HashMap()).putAll(map);
        }
        for (String code : codes) {
            result.putAll(translations.getOrDefault(code, Map.of()));
        }
        return ImmutableMap.copyOf(result);
    }

    public void onResourceManagerReload(ResourceManager resourceManager, List<LanguageInfo> infos) {
        this.translations = NPCDialogueLanguageManager.loadFrom(resourceManager, infos);
    }

    public String getOrDefault(String key) {
        return this.translations.getOrDefault(key, key);
    }
}

