/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public abstract class CompanionGui<T extends LivingEntity>
extends Screen {
    protected static final ResourceLocation TEXTURE_PATH = new ResourceLocation("runecraftory", "textures/gui/companion_gui.png");
    protected static final ResourceLocation BARS = new ResourceLocation("runecraftory", "textures/gui/bars.png");
    private final int textureX = 190;
    private final int textureY = 183;
    private final Component levelTxt = new TranslatableComponent("runecraftory.gui.level");
    protected int leftPos;
    protected int topPos;
    protected final T entity;

    public CompanionGui(T entity) {
        super(entity.m_5446_());
        this.entity = entity;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.textureX) / 2;
        this.topPos = (this.f_96544_ - this.textureY) / 2;
        this.buttons();
    }

    protected void renderBg(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture());
        this.m_93228_(stack, this.leftPos, this.topPos, 0, 0, this.textureX, this.textureY);
        int iconX = 86;
        int iconY = 42;
        this.m_93228_(stack, this.leftPos + iconX, this.topPos + iconY, 226, 2, 8, 8);
        this.m_93228_(stack, this.leftPos + iconX, this.topPos + iconY + 13, 226, 13, 8, 8);
        this.m_93228_(stack, this.leftPos + iconX, this.topPos + iconY + 26, 226, 24, 8, 8);
        this.m_93228_(stack, this.leftPos + iconX, this.topPos + iconY + 39, 226, 35, 8, 8);
        this.m_93228_(stack, this.leftPos + iconX, this.topPos + iconY + 52, 226, 46, 8, 8);
        int healthWidth = Math.min(100, (int)((double)(this.entity.m_21223_() / this.entity.m_21233_()) * 100.0));
        int exp = Math.min(100, (int)((double)((IBaseMob)this.entity).level().getProgress() * 100.0));
        RenderSystem.m_157456_((int)0, (ResourceLocation)BARS);
        int barX = 81;
        this.m_93228_(stack, this.leftPos + barX, this.topPos + 14, 2, 51, healthWidth, 6);
        this.m_93228_(stack, this.leftPos + barX, this.topPos + 25, 2, 66, exp, 9);
        ClientHandlers.drawCenteredScaledString(stack, this.f_96547_, (int)this.entity.m_21223_() + "/" + (int)this.entity.m_21233_(), (float)(this.leftPos + barX + 50), (float)(this.topPos + 15), 0.7f, 0xFFFFFF);
        this.f_96547_.m_92889_(stack, this.levelTxt, (float)(this.leftPos + barX + 3), (float)(this.topPos + 26), 0);
        ClientHandlers.drawRightAlignedScaledString(stack, this.f_96547_, "" + ((IBaseMob)this.entity).level().getLevel(), (float)(this.leftPos + barX + 99), (float)(this.topPos + 26), 1.0f, 0);
        int statX = 179;
        int statY = 43;
        ClientHandlers.drawRightAlignedScaledString(stack, this.f_96547_, "" + (int)CombatUtils.getAttributeValue(this.entity, Attributes.f_22281_), (float)(this.leftPos + statX), (float)(this.topPos + statY), 1.0f, 0);
        ClientHandlers.drawRightAlignedScaledString(stack, this.f_96547_, "" + (int)CombatUtils.getAttributeValue(this.entity, (Attribute)ModAttributes.DEFENCE.get()), (float)(this.leftPos + statX), (float)(this.topPos + statY + 13), 1.0f, 0);
        ClientHandlers.drawRightAlignedScaledString(stack, this.f_96547_, "" + (int)CombatUtils.getAttributeValue(this.entity, (Attribute)ModAttributes.MAGIC.get()), (float)(this.leftPos + statX), (float)(this.topPos + statY + 26), 1.0f, 0);
        ClientHandlers.drawRightAlignedScaledString(stack, this.f_96547_, "" + (int)CombatUtils.getAttributeValue(this.entity, (Attribute)ModAttributes.MAGIC_DEFENCE.get()), (float)(this.leftPos + statX), (float)(this.topPos + statY + 39), 1.0f, 0);
        ClientHandlers.drawRightAlignedScaledString(stack, this.f_96547_, "" + ((IBaseMob)this.entity).friendPoints((Player)this.f_96541_.f_91074_), (float)(this.leftPos + statX), (float)(this.topPos + statY + 52), 1.0f, 0);
        float scale = 1.0f;
        if ((double)this.entity.m_20205_() > 1.2) {
            scale = 1.2f / this.entity.m_20205_();
        }
        if ((double)this.entity.m_20206_() > 1.6) {
            scale = Math.min(scale, 1.6f / this.entity.m_20206_());
        }
        InventoryScreen.m_98850_((int)(this.leftPos + 39), (int)(this.topPos + 77), (int)((int)(29.0f * scale)), (float)(this.leftPos + 40 - mouseX), (float)(this.topPos + 27 - mouseY), this.entity);
    }

    protected abstract void buttons();

    protected ResourceLocation texture() {
        return TEXTURE_PATH;
    }

    protected void drawCenteredScaledString(PoseStack stack, Component txt, float x, float y, float scale, int color) {
        stack.m_85836_();
        stack.m_85837_((double)x, (double)y, 0.0);
        stack.m_85841_(scale, scale, scale);
        int yOffset = 0;
        for (FormattedCharSequence sub : this.f_96547_.m_92923_((FormattedText)txt, 64)) {
            stack.m_85836_();
            stack.m_85837_((double)(-this.f_96547_.m_92724_(sub)) * 0.5, 0.0, 0.0);
            this.f_96547_.m_92877_(stack, sub, 0.0f, (float)yOffset, color);
            yOffset += 9;
            stack.m_85849_();
        }
        stack.m_85849_();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        this.renderBg(stack, partialTicks, mouseX, mouseY);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.drawCenteredScaledString(stack, this.f_96539_, this.leftPos + 38, this.topPos + 88, 0.8f, 0);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return true;
    }
}

