/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerCrafting;
import io.github.flemmli97.runecraftory.common.network.C2SSelectRecipeCrafting;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class CraftingGui
extends AbstractContainerScreen<ContainerCrafting> {
    private static final ResourceLocation BARS = new ResourceLocation("runecraftory", "textures/gui/bars.png");
    private static final ResourceLocation FORGING = new ResourceLocation("runecraftory", "textures/gui/forging.png");
    private static final ResourceLocation CRAFTING = new ResourceLocation("runecraftory", "textures/gui/crafting.png");
    private static final ResourceLocation COOKING = new ResourceLocation("runecraftory", "textures/gui/cooking.png");
    private static final ResourceLocation CHEMISTRY = new ResourceLocation("runecraftory", "textures/gui/chemistry.png");
    private Rect scrollBar = new Rect(195, 12, 8, 142);
    private Rect scrollArea = new Rect(172, 12, 31, 142);
    private final RecipeSelectButton[] selectButtons = new RecipeSelectButton[7];
    private int scrollValue;
    private boolean isDragging;
    private final EnumSkills skill;

    public CraftingGui(ContainerCrafting container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.f_97726_ = 209;
        this.f_97727_ = 166;
        this.skill = switch (((ContainerCrafting)this.f_97732_).craftingType()) {
            default -> throw new IncompatibleClassChangeError();
            case EnumCrafting.FORGE -> EnumSkills.FORGING;
            case EnumCrafting.ARMOR -> EnumSkills.CRAFTING;
            case EnumCrafting.CHEM -> EnumSkills.CHEMISTRY;
            case EnumCrafting.COOKING -> EnumSkills.COOKING;
        };
    }

    protected void m_7856_() {
        super.m_7856_();
        for (int i = 0; i < 7; ++i) {
            this.selectButtons[i] = new RecipeSelectButton(this.f_97735_ + 173, this.f_97736_ + 13 + i * 20, i, b -> {
                if (b instanceof RecipeSelectButton) {
                    RecipeSelectButton but = (RecipeSelectButton)b;
                    Platform.INSTANCE.sendToServer(new C2SSelectRecipeCrafting(but.getActualIndex()));
                }
            });
            this.m_142416_((GuiEventListener)this.selectButtons[i]);
        }
        this.scrollBar = new Rect(this.f_97735_ + this.scrollBar.x, this.f_97736_ + this.scrollBar.y, this.scrollBar.width, this.scrollBar.height);
        this.scrollArea = new Rect(this.f_97735_ + this.scrollArea.x, this.f_97736_ + this.scrollArea.y, this.scrollArea.width, this.scrollArea.height);
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation texture = switch (((ContainerCrafting)this.f_97732_).craftingType()) {
            default -> throw new IncompatibleClassChangeError();
            case EnumCrafting.ARMOR -> CRAFTING;
            case EnumCrafting.COOKING -> COOKING;
            case EnumCrafting.FORGE -> FORGING;
            case EnumCrafting.CHEM -> CHEMISTRY;
        };
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        this.m_93228_(stack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        PlayerData data = Platform.INSTANCE.getPlayerData((Player)this.f_96541_.f_91074_).orElse(null);
        if (((ContainerCrafting)this.f_97732_).rpCost() >= 0) {
            int rpMax = data != null ? data.getMaxRunePoints() : 0;
            TextComponent cost = new TextComponent("" + ((ContainerCrafting)this.f_97732_).rpCost());
            if (rpMax < ((ContainerCrafting)this.f_97732_).rpCost() && !this.f_96541_.f_91074_.m_7500_()) {
                cost = new TranslatableComponent("runecraftory.gui.crafting.rpMax.missing").m_130940_(ChatFormatting.DARK_RED);
            }
            ClientHandlers.drawCenteredScaledString(stack, this.f_96547_, (Component)cost, (float)(this.f_97735_ + 123), (float)(this.f_97736_ + 20), 1.0f, 0);
        }
        if (data != null) {
            stack.m_85836_();
            float scale = 0.8f;
            int xPos = this.f_97735_;
            int yPos = this.f_97736_ - 12;
            stack.m_85837_((double)xPos, (double)yPos, 0.0);
            stack.m_85841_(scale, scale, scale);
            RenderSystem.m_157456_((int)0, (ResourceLocation)BARS);
            this.m_93228_(stack, 0, 0, 131, 74, 96, 29);
            int runePointsWidth = Math.min(76, (int)((float)data.getRunePoints() / (float)data.getMaxRunePoints() * 76.0f));
            this.m_93228_(stack, 17, 3, 18, 40, runePointsWidth, 9);
            ClientHandlers.drawCenteredScaledString(stack, this.f_96547_, data.getRunePoints() + "/" + data.getMaxRunePoints(), 55.5f, 5.0f, 0.7f, 0xFFFFFF);
            stack.m_85849_();
            this.f_96547_.m_92889_(stack, (Component)new TranslatableComponent("runecraftory.gui.display.level", new Object[]{data.getSkillLevel(this.skill).getLevel()}), (float)(this.f_97735_ + this.f_97728_ + this.f_96547_.m_92852_((FormattedText)this.f_96539_) + 6), (float)(this.f_97736_ + this.f_97729_), 0x404040);
        }
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.m_7025_(stack, mouseX, mouseY);
        List<Pair<Integer, ItemStack>> recipes = ((ContainerCrafting)this.f_97732_).getMatchingRecipesClient();
        for (int i = this.scrollValue; i < this.scrollValue + 7; ++i) {
            if (i >= recipes.size()) continue;
            this.f_96542_.f_115093_ = 100.0f;
            this.f_96542_.m_115218_((ItemStack)recipes.get(i).getSecond(), this.f_97735_ + 176, this.f_97736_ + 15 + 20 * (i - this.scrollValue));
        }
        for (RecipeSelectButton button : this.selectButtons) {
            button.f_93624_ = button.index < ((ContainerCrafting)this.f_97732_).getMatchingRecipesClient().size();
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)BARS);
        this.renderScroller(stack, this.scrollBar.x + 1, this.scrollBar.y + 1);
    }

    private void renderScroller(PoseStack poseStack, int posX, int posY) {
        int steps = ((ContainerCrafting)this.f_97732_).getMatchingRecipesClient().size() - 7;
        int widgetHeight = 27;
        if (steps > 0) {
            int barHeight = this.scrollBar.height - 2;
            int moveableHeight = barHeight - widgetHeight;
            int k = moveableHeight / steps;
            int yOffset = Mth.m_14045_((int)(this.scrollValue * k), (int)0, (int)moveableHeight);
            this.m_93228_(poseStack, posX, posY + yOffset, 185, 0, 6, widgetHeight);
        } else {
            this.m_93228_(poseStack, posX, posY, 191, 0, 6, widgetHeight);
        }
    }

    private boolean canScroll() {
        return ((ContainerCrafting)this.f_97732_).getMatchingRecipesClient().size() > 7;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.canScroll() && this.scrollArea.isMouseOver(mouseX, mouseY)) {
            this.setScrollValue((int)((double)this.scrollValue - delta));
        }
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging) {
            int maxY = this.scrollBar.y + this.scrollBar.height - 3;
            int max = ((ContainerCrafting)this.f_97732_).getMatchingRecipesClient().size() - 7;
            float amount = ((float)mouseY - (float)this.scrollBar.y - 13.5f) / ((float)(maxY - this.scrollBar.y) - 27.0f);
            amount = amount * (float)max + 0.5f;
            this.scrollValue = Mth.m_14045_((int)((int)amount), (int)0, (int)max);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.isDragging = this.canScroll() && this.scrollBar.isMouseOver(mouseX, mouseY);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public EnumCrafting type() {
        return ((ContainerCrafting)this.f_97732_).craftingType();
    }

    public int getLeft() {
        return this.f_97735_;
    }

    public int getTop() {
        return this.f_97736_;
    }

    public void setScrollValue(int val) {
        this.scrollValue = Mth.m_14045_((int)val, (int)0, (int)Math.max(0, ((ContainerCrafting)this.f_97732_).getMatchingRecipesClient().size() - 7));
    }

    record Rect(int x, int y, int width, int height) {
        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
        }
    }

    private class RecipeSelectButton
    extends Button {
        private final int index;

        public RecipeSelectButton(int i, int j, int k, Button.OnPress onPress) {
            super(i, j, 22, 20, TextComponent.f_131282_, onPress);
            this.index = k;
            this.f_93624_ = false;
        }

        public int getActualIndex() {
            return this.index + CraftingGui.this.scrollValue;
        }

        public void m_7428_(PoseStack poseStack, int relativeMouseX, int relativeMouseY) {
            if (this.f_93622_ && this.getActualIndex() < ((ContainerCrafting)CraftingGui.this.f_97732_).getMatchingRecipesClient().size()) {
                ItemStack itemStack = (ItemStack)((ContainerCrafting)CraftingGui.this.f_97732_).getMatchingRecipesClient().get(this.getActualIndex()).getSecond();
                CraftingGui.this.m_6057_(poseStack, itemStack, relativeMouseX, relativeMouseY);
            }
        }
    }
}

