/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.client.ClientFarmlandHandler;
import io.github.flemmli97.runecraftory.common.blocks.Growable;
import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandDataContainer;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class FarmlandInfo
extends GuiComponent {
    private static final ResourceLocation TEXTURE_PATH = new ResourceLocation("runecraftory", "textures/gui/farmland_view.png");
    private final Minecraft mc;

    public FarmlandInfo(Minecraft mc) {
        this.mc = mc;
    }

    public void render(PoseStack stack) {
        TextComponent growth;
        if (!EntityUtils.shouldShowFarmlandView((LivingEntity)this.mc.f_91074_)) {
            return;
        }
        HitResult res = this.mc.f_91077_;
        if (res == null || res.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)res;
        BlockPos pos = blockHitResult.m_82425_();
        BlockState blockState = this.mc.f_91073_.m_8055_(pos);
        boolean cropBlock = false;
        FarmlandDataContainer data = null;
        if (blockState.m_60734_() instanceof BushBlock) {
            pos = pos.m_7495_();
            cropBlock = blockState.m_60734_() instanceof Growable;
            blockState = this.mc.f_91073_.m_8055_(pos);
        }
        if (FarmlandHandler.isFarmBlock(blockState)) {
            data = ClientFarmlandHandler.INSTANCE.getData(pos);
        }
        if (data == null) {
            return;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_PATH);
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int sY = 60 + (cropBlock ? 40 : 0);
        int xPos = ClientConfig.farmlandPosition.positionX(this.mc.m_91268_().m_85445_(), 100, ClientConfig.farmlandX);
        int yPos = ClientConfig.farmlandPosition.positionY(this.mc.m_91268_().m_85446_(), sY, ClientConfig.farmlandY);
        this.m_93228_(stack, xPos, yPos, 0, 0, 100, sY - 5);
        this.m_93228_(stack, xPos, yPos + sY - 5, 0, 95, 100, 5);
        RenderSystem.m_69453_();
        yPos += 5;
        xPos += 5;
        if (cropBlock) {
            growth = new TextComponent(data.ageProgress() + "%");
            if (data.ageProgress() == 100) {
                growth.m_130940_(ChatFormatting.GREEN);
            }
            this.mc.f_91062_.m_92889_(stack, (Component)new TranslatableComponent("runecraftory.magnifying_glass.view.crop.growth", new Object[]{growth}), (float)xPos, (float)yPos, 0);
            this.mc.f_91062_.m_92889_(stack, (Component)new TranslatableComponent("runecraftory.magnifying_glass.view.crop.level", new Object[]{Float.valueOf(data.cropLevel())}), (float)xPos, (float)(yPos + 10), 0);
            TextComponent giant = new TextComponent(data.cropSizeProgress() + "%");
            if (data.cropSizeProgress() == 100) {
                giant.m_130940_(ChatFormatting.GREEN);
            }
            this.mc.f_91062_.m_92889_(stack, (Component)new TranslatableComponent("runecraftory.magnifying_glass.view.crop.giant", new Object[]{giant}), (float)xPos, (float)(yPos + 20), 0);
            yPos += 40;
        }
        growth = new TextComponent(this.formattedValue(data.growth()));
        if ((double)data.growth() <= 0.5) {
            growth.m_130940_(ChatFormatting.RED);
        }
        this.mc.f_91062_.m_92889_(stack, (Component)new TranslatableComponent("runecraftory.magnifying_glass.view.speed", new Object[]{growth}), (float)xPos, (float)yPos, 0);
        TextComponent health = new TextComponent("" + data.health());
        if (data.health() <= 10) {
            health.m_130940_(ChatFormatting.RED);
        }
        this.mc.f_91062_.m_92889_(stack, (Component)new TranslatableComponent("runecraftory.magnifying_glass.view.health", new Object[]{health}), (float)xPos, (float)(yPos + 10), 0);
        this.mc.f_91062_.m_92889_(stack, (Component)new TranslatableComponent("runecraftory.magnifying_glass.view.level", new Object[]{this.formattedValue(data.quality())}), (float)xPos, (float)(yPos + 20), 0);
        this.mc.f_91062_.m_92889_(stack, (Component)new TranslatableComponent("runecraftory.magnifying_glass.view.giant", new Object[]{this.formattedValue(data.size())}), (float)xPos, (float)(yPos + 30), 0);
        this.mc.f_91062_.m_92889_(stack, (Component)new TranslatableComponent("runecraftory.magnifying_glass.view.defence", new Object[]{this.formattedValue(data.defence())}), (float)xPos, (float)(yPos + 40), 0);
    }

    private String formattedValue(float f) {
        return String.format("%.2f", Float.valueOf(f));
    }
}

