/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import io.github.flemmli97.runecraftory.client.gui.CompanionGui;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.network.C2SSetMonsterBehaviour;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class MonsterCompanionGui
extends CompanionGui<BaseMonster> {
    private BaseMonster.Behaviour updatedBehaviour;
    private final boolean fullParty;
    private final boolean hasHome;

    public MonsterCompanionGui(BaseMonster entity, boolean fullParty, boolean hasHome) {
        super(entity);
        this.fullParty = fullParty;
        this.updatedBehaviour = ((BaseMonster)this.entity).behaviourState();
        this.hasHome = hasHome;
    }

    @Override
    protected void buttons() {
        int x = 2;
        int xSize = 90;
        int y = 115;
        int buttonIndex = 0;
        ArrayList<C2SSetMonsterBehaviour.Type> buttonTypes = new ArrayList<C2SSetMonsterBehaviour.Type>();
        switch (this.updatedBehaviour) {
            case WANDER_HOME: {
                if (!this.fullParty) {
                    buttonTypes.add(C2SSetMonsterBehaviour.Type.FOLLOW);
                }
                buttonTypes.add(C2SSetMonsterBehaviour.Type.FARM);
                break;
            }
            case FOLLOW: {
                buttonTypes.add(C2SSetMonsterBehaviour.Type.RIDE);
                if (this.hasHome) {
                    buttonTypes.add(C2SSetMonsterBehaviour.Type.HOME);
                }
                buttonTypes.add(C2SSetMonsterBehaviour.Type.FOLLOW_DISTANCE);
                buttonTypes.add(C2SSetMonsterBehaviour.Type.STAY);
                buttonTypes.add(C2SSetMonsterBehaviour.Type.WANDER);
                buttonTypes.add(C2SSetMonsterBehaviour.Type.FARM);
                break;
            }
            case FOLLOW_DISTANCE: {
                buttonTypes.add(C2SSetMonsterBehaviour.Type.RIDE);
                if (this.hasHome) {
                    buttonTypes.add(C2SSetMonsterBehaviour.Type.HOME);
                }
                buttonTypes.add(C2SSetMonsterBehaviour.Type.FOLLOW);
                buttonTypes.add(C2SSetMonsterBehaviour.Type.STAY);
                buttonTypes.add(C2SSetMonsterBehaviour.Type.WANDER);
                buttonTypes.add(C2SSetMonsterBehaviour.Type.FARM);
                break;
            }
            case STAY: {
                buttonTypes.add(C2SSetMonsterBehaviour.Type.RIDE);
                if (this.hasHome) {
                    buttonTypes.add(C2SSetMonsterBehaviour.Type.HOME);
                }
                buttonTypes.add(C2SSetMonsterBehaviour.Type.FOLLOW_DISTANCE);
                buttonTypes.add(C2SSetMonsterBehaviour.Type.FOLLOW);
                buttonTypes.add(C2SSetMonsterBehaviour.Type.WANDER);
                buttonTypes.add(C2SSetMonsterBehaviour.Type.FARM);
                break;
            }
            case WANDER: {
                if (this.hasHome) {
                    buttonTypes.add(C2SSetMonsterBehaviour.Type.HOME);
                }
                if (!this.fullParty) {
                    buttonTypes.add(C2SSetMonsterBehaviour.Type.FOLLOW);
                }
                buttonTypes.add(C2SSetMonsterBehaviour.Type.FARM);
                break;
            }
            case FARM: {
                if (this.hasHome) {
                    buttonTypes.add(C2SSetMonsterBehaviour.Type.HOME);
                }
                if (!this.fullParty) {
                    buttonTypes.add(C2SSetMonsterBehaviour.Type.FOLLOW);
                }
                buttonTypes.add(C2SSetMonsterBehaviour.Type.WANDER);
            }
        }
        for (C2SSetMonsterBehaviour.Type type : buttonTypes) {
            if (buttonIndex + 1 == buttonTypes.size() && buttonTypes.size() % 2 == 1) {
                this.m_142416_((GuiEventListener)new Button(this.leftPos + x + (int)((double)(xSize + 5) * 0.5), this.topPos + y + buttonIndex / 2 * 23, xSize, 20, (Component)new TranslatableComponent(type.translation), b -> this.handlePress(type)));
            } else {
                this.m_142416_((GuiEventListener)new Button(this.leftPos + x + (buttonIndex % 2 == 0 ? 0 : xSize + 6), this.topPos + y + buttonIndex / 2 * 23, xSize, 20, (Component)new TranslatableComponent(type.translation), b -> this.handlePress(type)));
            }
            ++buttonIndex;
        }
        if (this.f_96541_.f_91074_.m_21205_().m_41720_() == ModItems.MOB_STAFF.get()) {
            if (this.updatedBehaviour == BaseMonster.Behaviour.WANDER) {
                this.m_142416_((GuiEventListener)new Button(this.leftPos + x + (int)((double)(xSize + 5) * 0.5), this.topPos + y + buttonIndex / 2 * 23, xSize, 20, (Component)new TranslatableComponent(C2SSetMonsterBehaviour.Type.CENTER.translation), b -> this.handlePress(C2SSetMonsterBehaviour.Type.CENTER)));
            }
            if (this.updatedBehaviour == BaseMonster.Behaviour.FARM) {
                this.m_142416_((GuiEventListener)new Button(this.leftPos + x + (int)((double)(xSize + 5) * 0.5), this.topPos + y + buttonIndex / 2 * 23, xSize, 20, (Component)new TranslatableComponent(C2SSetMonsterBehaviour.Type.CENTER_FARM.translation), b -> this.handlePress(C2SSetMonsterBehaviour.Type.CENTER_FARM)));
                this.m_142416_((GuiEventListener)new Button(this.leftPos + x, this.topPos + y + (buttonIndex += 2) / 2 * 23, xSize, 20, (Component)new TranslatableComponent(C2SSetMonsterBehaviour.Type.HARVESTINV.translation), b -> this.handlePress(C2SSetMonsterBehaviour.Type.HARVESTINV)));
                this.m_142416_((GuiEventListener)new Button(this.leftPos + x + xSize + 6, this.topPos + y + buttonIndex / 2 * 23, xSize, 20, (Component)new TranslatableComponent(C2SSetMonsterBehaviour.Type.SEEDINV.translation), b -> this.handlePress(C2SSetMonsterBehaviour.Type.SEEDINV)));
            }
        }
    }

    private void handlePress(C2SSetMonsterBehaviour.Type type) {
        Platform.INSTANCE.sendToServer(new C2SSetMonsterBehaviour(((BaseMonster)this.entity).m_142049_(), type));
        this.updatedBehaviour = type.behaviour;
        this.f_96541_.m_91152_(null);
        this.f_96541_.f_91073_.m_6263_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20185_(), this.f_96541_.f_91074_.m_20186_(), this.f_96541_.f_91074_.m_20189_(), SoundEvents.f_12216_, SoundSource.PLAYERS, 1.0f, 1.2f);
    }
}

