/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.client.gui.widgets.DialogueOptionButton;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.PlaceHolderComponent;
import io.github.flemmli97.runecraftory.common.network.C2SDialogueAction;
import io.github.flemmli97.runecraftory.common.network.C2SNPCInteraction;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class NPCDialogueGui<T extends EntityNPCBase>
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("runecraftory", "textures/gui/npc_dialogue.png");
    public static final int MAX_WIDTH = 200;
    public static final int MAX_HEIGHT = 73;
    public static final int BORDER_SIZE = 7;
    public static final int LINE_WIDTH = 186;
    public static final int ACTION_WIDTH = 90;
    public static final int LINES_PER_PAGE = 5;
    private final int offSetX = 100;
    private final int offSetY = 30;
    protected int leftPos;
    protected int topPos;
    private int pageIndex;
    private int lineProgress;
    private int textProgress;
    protected final T entity;
    private ConversationContext convCtx;
    private String conversationID;
    private List<ConversationLine> conversation;
    private Map<String, Component> replacements = Map.of();
    private List<Component> actions;
    private final List<DialogueOptionButton> buttons = new ArrayList<DialogueOptionButton>();
    private boolean reset;
    private boolean calculateButtonVisiblity;
    private boolean removed;

    public NPCDialogueGui(T entity) {
        super(entity.m_5446_());
        this.entity = entity;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = this.f_96543_ / 2 - this.offSetX;
        this.topPos = this.f_96544_ / 2 + this.offSetY;
        this.buttons();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTick) {
        if (this.removed) {
            this.m_7379_();
            return;
        }
        if (this.reset) {
            this.buttons();
            this.reset = false;
        }
        if (this.calculateButtonVisiblity) {
            if (this.buttonsVisible()) {
                this.showAllButtons();
            }
            this.calculateButtonVisiblity = false;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
        this.m_93228_(stack, this.leftPos, this.topPos, 5, 5, 200, 73);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int lines = Math.min(this.conversation.size(), (this.pageIndex + 1) * 5);
        for (int i = this.pageIndex * 5; i < lines; ++i) {
            if (i > this.lineProgress) continue;
            ConversationLine txt = this.conversation.get(i);
            FormattedCharSequence txtRender = this.lineProgress == i ? Language.m_128107_().m_5536_(this.f_96547_.m_92854_(txt.raw(), this.textProgress)) : txt.txt();
            this.f_96547_.m_92877_(stack, txtRender, (float)(this.leftPos + 7), (float)(this.topPos + 7 + 13 * (i % 5)), 0xFFFFFF);
        }
        super.m_6305_(stack, mouseX, mouseY, partialTick);
    }

    protected void buttons() {
        this.buttons.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.buttons.clear();
        boolean visible = this.buttonsVisible();
        int y = 0;
        for (int i = this.actions.size() - 1; i >= 0; --i) {
            int actionIdx = i;
            DialogueOptionButton btn = new DialogueOptionButton(this.f_96543_ / 2, this.topPos - 20 + y, this.f_96547_, PlaceHolderComponent.parseDialogueComponent(this.actions.get(i), this.replacements), b -> {
                if (this.convCtx != null && this.conversationID != null) {
                    Platform.INSTANCE.sendToServer(new C2SDialogueAction(this.entity.m_142049_(), this.convCtx, this.conversationID, actionIdx));
                }
            });
            btn.f_93621_ -= btn.m_93694_();
            btn.f_93624_ = visible;
            this.buttons.add(btn);
            this.m_142416_((GuiEventListener)btn);
            y -= btn.m_93694_() + 8;
        }
    }

    public void m_96624_() {
        super.m_96624_();
        int max = this.maxCurrentLineIndex();
        if (this.lineProgress <= max) {
            this.textProgress += 4;
            ConversationLine txt = this.conversation.get(this.lineProgress);
            if (this.textProgress > txt.width()) {
                ++this.lineProgress;
                if (this.lineProgress > this.conversation.size() - 1) {
                    this.showAllButtons();
                }
                this.textProgress = 0;
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int id = this.maxCurrentLineIndex();
        if (this.lineProgress < id || this.lineProgress / 5 == this.pageIndex && this.lineProgress < this.conversation.size() && this.textProgress < this.conversation.get(this.lineProgress).width()) {
            this.lineProgress = id + 1;
            this.calculateButtonVisiblity = true;
        } else if (this.pageIndex + 1 <= (this.conversation.size() - 1) / 5) {
            ++this.pageIndex;
            this.textProgress = 0;
            this.calculateButtonVisiblity = true;
        } else if (this.buttons.isEmpty()) {
            this.removed = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void showAllButtons() {
        this.buttons.forEach(b -> {
            b.f_93624_ = true;
        });
    }

    private int maxCurrentLineIndex() {
        return Math.min(4 + this.pageIndex * 5, this.conversation.size() - 1);
    }

    private boolean buttonsVisible() {
        return this.lineProgress >= this.conversation.size() - 1;
    }

    public void m_7861_() {
        super.m_7861_();
        Minecraft.m_91087_().f_91066_.f_92095_.m_90859_();
        Minecraft.m_91087_().f_91066_.f_92095_.m_7249_(false);
        Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.m_142049_(), this.convCtx == null ? C2SNPCInteraction.Type.CLOSE_QUEST : C2SNPCInteraction.Type.CLOSE, this.conversationID));
        if (this.convCtx == ConversationContext.GREETING) {
            Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.m_142049_(), C2SNPCInteraction.Type.TALK));
        }
    }

    public void updateConversation(Minecraft mc, ConversationContext convCtx, String conversationID, Component conversation, Map<String, Component> data, List<Component> actions) {
        conversation = PlaceHolderComponent.parseDialogueComponent(conversation, data);
        this.conversation = mc.f_91062_.m_92865_().m_92414_((FormattedText)conversation, 186, conversation.m_7383_()).stream().map(txt -> new ConversationLine(mc.f_91062_.m_92852_(txt), (FormattedText)txt, Language.m_128107_().m_5536_(txt))).toList();
        this.actions = actions;
        this.convCtx = convCtx;
        this.conversationID = conversationID;
        this.replacements = data;
        this.lineProgress = 0;
        this.textProgress = 0;
        this.pageIndex = 0;
        this.reset = true;
    }

    record ConversationLine(int width, FormattedText raw, FormattedCharSequence txt) {
    }
}

