/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.job.ShopState;
import io.github.flemmli97.runecraftory.common.network.C2SNPCInteraction;
import io.github.flemmli97.runecraftory.common.network.C2SProcreationRequest;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import io.github.flemmli97.runecraftory.common.registry.ModPoiTypes;
import io.github.flemmli97.runecraftory.common.world.family.SyncedFamilyData;
import io.github.flemmli97.runecraftory.mixin.PoiTypeAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class NPCGui<T extends EntityNPCBase>
extends Screen {
    private static final ResourceLocation TEXTURE_PATH = new ResourceLocation("runecraftory", "textures/gui/view.png");
    private final int offSetX = 140;
    private final int offSetY = 50;
    protected int leftPos;
    protected int topPos;
    private int lines;
    protected final T entity;
    private final ShopState isShopOpen;
    private final boolean canFollow;
    private List<FormattedCharSequence> components;
    private final Map<String, List<Component>> actions;
    private final ResourceLocation quest;
    private final SyncedFamilyData family;
    private final List<ToolTipRenderer> tooltipComponents = new ArrayList<ToolTipRenderer>();

    public NPCGui(T entity, ShopState isShopOpen, boolean canFollow, SyncedFamilyData family, Map<String, List<Component>> actions, ResourceLocation quest) {
        super(entity.m_5446_());
        this.entity = entity;
        this.isShopOpen = isShopOpen;
        this.canFollow = canFollow;
        this.actions = actions;
        this.quest = quest;
        this.family = family;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = this.f_96543_ - this.offSetX;
        this.topPos = this.offSetY;
        this.buttons();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_PATH);
        int posX = 25;
        int posY = 25;
        int texY = this.lines * 13 + 10;
        boolean renderParents = this.family.father() != null || this.family.mother() != null;
        this.m_93228_(stack, posX, posY, 0, 0, 150, texY - 5);
        this.m_93228_(stack, posX, posY + texY - 5, 0, 251, 160, 5);
        int txtOffX = posX + 5;
        int txtOffY = posY + 5;
        ClientHandlers.drawCenteredScaledString(stack, this.f_96547_, this.entity.m_7755_(), (float)(posX + 75), (float)txtOffY, 1.0f, 0);
        int y = 1;
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_PATH);
        this.m_93228_(stack, posX + 65, txtOffY + 13 * y, 152, 2, 8, 8);
        this.f_96547_.m_92883_(stack, "" + this.entity.friendPoints((Player)this.f_96541_.f_91074_), (float)(posX + 65 + 10), (float)(txtOffY + 13 * y), 0);
        ++y;
        if (renderParents) {
            if (this.family.father() == null) {
                this.f_96547_.m_92889_(stack, (Component)new TranslatableComponent("runecraftory.gui.npc.parent"), (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                ++y;
                for (FormattedCharSequence ch : this.f_96547_.m_92923_((FormattedText)this.family.mother(), 140)) {
                    this.f_96547_.m_92877_(stack, ch, (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                    ++y;
                }
            } else if (this.family.mother() == null) {
                this.f_96547_.m_92889_(stack, (Component)new TranslatableComponent("runecraftory.gui.npc.parent"), (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                ++y;
                for (FormattedCharSequence ch : this.f_96547_.m_92923_((FormattedText)this.family.father(), 140)) {
                    this.f_96547_.m_92877_(stack, ch, (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                    ++y;
                }
            } else {
                this.f_96547_.m_92889_(stack, (Component)new TranslatableComponent("runecraftory.gui.npc.parents"), (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                ++y;
                for (FormattedCharSequence ch : this.f_96547_.m_92923_((FormattedText)this.family.father(), 140)) {
                    this.f_96547_.m_92877_(stack, ch, (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                    ++y;
                }
                for (FormattedCharSequence ch : this.f_96547_.m_92923_((FormattedText)this.family.mother(), 140)) {
                    this.f_96547_.m_92877_(stack, ch, (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                    ++y;
                }
            }
        }
        if (!this.entity.m_6162_()) {
            switch (this.family.relationship()) {
                case NONE: {
                    break;
                }
                case DATING: {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_PATH);
                    this.m_93228_(stack, txtOffX, txtOffY + 13 * y, 152, 41, 10, 8);
                    this.f_96547_.m_92889_(stack, this.family.partner(), (float)(txtOffX + 12), (float)(txtOffY + 13 * y), 0);
                    ++y;
                    break;
                }
                case MARRIED: {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_PATH);
                    this.m_93228_(stack, txtOffX, txtOffY + 13 * y, 152, 54, 10, 8);
                    this.f_96547_.m_92889_(stack, this.family.partner(), (float)(txtOffX + 12), (float)(txtOffY + 13 * y), 0);
                    ++y;
                }
            }
            ++y;
        }
        int shopY = txtOffY + 13 * y;
        int shopSizeY = -5;
        if (!this.entity.m_6162_()) {
            TranslatableComponent shopComp = null;
            if (((EntityNPCBase)this.entity).getShop() == ModNPCJobs.GENERAL.getSecond()) {
                shopComp = new TranslatableComponent("runecraftory.gui.npc.shop.owner", new Object[]{new TranslatableComponent(((EntityNPCBase)this.entity).getShop().getTranslationKey())});
            } else if (((EntityNPCBase)this.entity).getShop().hasWorkSchedule) {
                shopComp = new TranslatableComponent(((EntityNPCBase)this.entity).getShop().getTranslationKey());
            }
            if (shopComp != null) {
                if (this.isShopOpen == ShopState.NOBED || this.isShopOpen == ShopState.NOWORKPLACE) {
                    shopComp.m_130940_(ChatFormatting.DARK_RED);
                }
                for (Component comp : this.f_96547_.m_92923_((FormattedText)shopComp, 140)) {
                    float xCenter = (float)(posX + 75) - (float)this.f_96541_.f_91062_.m_92724_((FormattedCharSequence)comp) * 0.5f;
                    this.f_96547_.m_92877_(stack, (FormattedCharSequence)comp, xCenter, (float)(txtOffY + 13 * y), 0);
                    ++y;
                    shopSizeY += 13;
                }
            }
            if (((EntityNPCBase)this.entity).getShop().hasWorkSchedule) {
                for (Component comp : ((EntityNPCBase)this.entity).getSchedule().viewSchedule()) {
                    for (FormattedCharSequence formatted : this.f_96547_.m_92923_((FormattedText)comp, 140)) {
                        this.f_96547_.m_92877_(stack, formatted, (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                        ++y;
                    }
                }
            }
        }
        if (this.components != null && this.isHovering(txtOffX, shopY, 145, shopSizeY, mouseX, mouseY)) {
            this.m_96617_(stack, this.components, mouseX, mouseY);
        }
        this.tooltipComponents.forEach(r -> r.render(stack, mouseX, mouseY));
        this.lines = y;
        super.m_6305_(stack, mouseX, mouseY, partialTick);
    }

    protected void buttons() {
        int x = -52;
        int xSize = 150;
        int y = 0;
        this.m_142416_((GuiEventListener)new Button(this.leftPos + x, this.topPos + y, xSize, 20, (Component)new TranslatableComponent(C2SNPCInteraction.Type.TALK.translation), b -> {
            Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.m_142049_(), C2SNPCInteraction.Type.TALK));
            this.f_96541_.m_91152_(null);
        }));
        if (this.canFollow) {
            this.m_142416_((GuiEventListener)new Button(this.leftPos + x, this.topPos + (y += 30), xSize, 20, (Component)new TranslatableComponent(C2SNPCInteraction.Type.FOLLOW.translation), b -> {
                Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.m_142049_(), C2SNPCInteraction.Type.FOLLOW));
                this.f_96541_.m_91152_(null);
            }));
        }
        if (!this.entity.m_6162_() && this.isShopOpen == ShopState.OPEN) {
            if (((EntityNPCBase)this.entity).getShop().hasShop) {
                this.m_142416_((GuiEventListener)new Button(this.leftPos + x, this.topPos + (y += 30), xSize, 20, (Component)new TranslatableComponent(C2SNPCInteraction.Type.SHOP.translation), b -> {
                    Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.m_142049_(), C2SNPCInteraction.Type.SHOP));
                    this.f_96541_.m_91152_(null);
                }));
            }
            for (Map.Entry<String, List<Component>> action : this.actions.entrySet()) {
                this.m_142416_((GuiEventListener)new Button(this.leftPos + x, this.topPos + (y += 30), xSize, 20, (Component)new TranslatableComponent(action.getKey()), b -> {
                    Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.m_142049_(), (String)action.getKey()));
                    this.f_96541_.m_91152_(null);
                }));
                int tooltipX = this.leftPos + x;
                int tooltipY = this.topPos + y;
                this.tooltipComponents.add((stack, mouseX, mouseY) -> {
                    if (this.isHovering(tooltipX, tooltipY, xSize, 20, mouseX, mouseY)) {
                        this.m_169388_(stack, (List)action.getValue(), Optional.empty(), mouseX, mouseY);
                    }
                });
            }
        }
        if (this.quest != null) {
            this.m_142416_((GuiEventListener)new Button(this.leftPos + x, this.topPos + (y += 30), xSize, 20, (Component)new TranslatableComponent(C2SNPCInteraction.Type.QUEST.translation), b -> {
                Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.m_142049_(), C2SNPCInteraction.Type.QUEST, this.quest.toString()));
                this.f_96541_.m_91152_(null);
            }));
        }
        if (!this.entity.m_6162_() && this.family.canProcreate()) {
            this.m_142416_((GuiEventListener)new Button(this.leftPos + x, this.topPos + (y += 30), xSize, 20, (Component)new TranslatableComponent("runecraftory.gui.npc.procreate"), b -> {
                Platform.INSTANCE.sendToServer(new C2SProcreationRequest(this.entity.m_142049_()));
                this.f_96541_.m_91152_(null);
            }));
        }
        if (this.isShopOpen == ShopState.NOBED) {
            this.components = new ArrayList<FormattedCharSequence>();
            this.components.addAll(this.f_96547_.m_92923_((FormattedText)new TranslatableComponent("runecraftory.gui.npc.bed.no"), 150));
        }
        if (!this.entity.m_6162_() && this.isShopOpen == ShopState.NOWORKPLACE && ((EntityNPCBase)this.entity).getShop().poiType != null && ((EntityNPCBase)this.entity).getShop().poiType.get() != null) {
            this.components = new ArrayList<FormattedCharSequence>();
            this.components.addAll(this.f_96547_.m_92923_((FormattedText)new TranslatableComponent("runecraftory.gui.npc.workplace.no", new Object[]{this.formatShopPoi(((EntityNPCBase)this.entity).getShop().poiType.get())}), 150));
        }
    }

    private Component formatShopPoi(PoiType poiType) {
        HashSet<BlockState> set = new HashSet<BlockState>(((PoiTypeAccessor)poiType).matches());
        if (((EntityNPCBase)this.entity).getShop().predicate != null && ((EntityNPCBase)this.entity).getShop().predicate.test((PoiType)ModPoiTypes.CASH_REGISTER.get())) {
            set.addAll(((PoiTypeAccessor)ModPoiTypes.CASH_REGISTER.get()).matches());
        }
        TextComponent comp = new TextComponent("");
        set.stream().map(BlockBehaviour.BlockStateBase::m_60734_).distinct().map(Block::m_49954_).forEach(arg_0 -> NPCGui.lambda$formatShopPoi$8((MutableComponent)comp, arg_0));
        return comp.m_130940_(ChatFormatting.AQUA);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return true;
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)(x - 1) && mouseX < (double)(x + width + 1) && mouseY >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public void m_7861_() {
        super.m_7861_();
        Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.m_142049_(), C2SNPCInteraction.Type.CLOSE));
    }

    private static /* synthetic */ void lambda$formatShopPoi$8(MutableComponent comp, MutableComponent c) {
        if (comp.m_7360_().isEmpty()) {
            comp.m_7220_((Component)c);
        } else {
            comp.m_7220_((Component)new TextComponent(", ").m_7220_((Component)c));
        }
    }

    static interface ToolTipRenderer {
        public void render(PoseStack var1, int var2, int var3);
    }
}

