/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.gui.widgets.PageButton;
import io.github.flemmli97.runecraftory.client.gui.widgets.SpeechBubble;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerShop;
import io.github.flemmli97.runecraftory.common.network.C2SNPCInteraction;
import io.github.flemmli97.runecraftory.common.network.C2SShopButton;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;

public class NPCShopGui
extends AbstractContainerScreen<ContainerShop> {
    protected static final ResourceLocation TEXTURE_PATH = new ResourceLocation("runecraftory", "textures/gui/shop.png");
    private final Inventory inventory;
    private Slot lastClickSlotShop;
    private boolean isLeftClickDown;
    private boolean isRightClickDown;
    private int clickDelay;
    private int rightDelay = 50;
    private int leftDelay = 50;
    private PageButton next;
    private PageButton prev;
    private SpeechBubble speech;

    public NPCShopGui(ContainerShop abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.inventory = inventory;
    }

    protected void m_7856_() {
        this.f_97726_ = 245;
        this.f_97727_ = 217;
        super.m_7856_();
        this.next = new PageButton(this.f_97735_ + 123, this.f_97736_ + 8, (Component)new TextComponent(">"), b -> Platform.INSTANCE.sendToServer(new C2SShopButton(true)));
        this.m_142416_((GuiEventListener)this.next);
        this.prev = new PageButton(this.f_97735_ + 12, this.f_97736_ + 8, (Component)new TextComponent("<"), b -> Platform.INSTANCE.sendToServer(new C2SShopButton(false)));
        this.m_142416_((GuiEventListener)this.prev);
        this.updateButtons();
        this.speech = new SpeechBubble(this.f_96541_, this.f_97735_ + 148, this.f_97736_ + 10, 98, 30);
        this.m_169394_(this.speech);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.m_7025_(stack, mouseX, mouseY);
        if (this.lastClickSlotShop != this.f_97734_) {
            this.lastClickSlotShop = null;
            this.isLeftClickDown = false;
            this.isRightClickDown = false;
        }
        if (this.lastClickSlotShop != null) {
            --this.clickDelay;
            if (this.isLeftClickDown) {
                this.rightDelay = 50;
                if (--this.leftDelay <= 0 && this.clickDelay <= 0) {
                    ClickType click = NPCShopGui.m_96638_() ? ClickType.QUICK_MOVE : ClickType.PICKUP;
                    this.m_6597_(this.lastClickSlotShop, this.lastClickSlotShop.f_40219_, 0, click);
                    this.clickDelay = 4;
                }
            } else if (this.isRightClickDown) {
                this.leftDelay = 50;
                if (--this.rightDelay <= 0 && this.clickDelay <= 0) {
                    ClickType click = NPCShopGui.m_96638_() ? ClickType.QUICK_MOVE : ClickType.PICKUP;
                    this.m_6597_(this.lastClickSlotShop, this.lastClickSlotShop.f_40219_, 1, click);
                    this.clickDelay = 4;
                }
            } else {
                this.leftDelay = 50;
                this.rightDelay = 50;
            }
        }
    }

    protected void m_7286_(PoseStack stack, float partialTick, int mouseX, int mouseY) {
        InventoryScreen.m_98850_((int)(this.f_97735_ + 200), (int)(this.f_97736_ + 150), (int)50, (float)(this.f_97735_ + 200 - mouseX), (float)(this.f_97736_ + 65 - mouseY), (LivingEntity)((ContainerShop)this.f_97732_).getShopOwner());
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_PATH);
        this.m_93228_(stack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        Platform.INSTANCE.getPlayerData((Player)this.f_96541_.f_91074_).ifPresent(data -> ClientHandlers.drawRightAlignedScaledString(stack, this.f_96547_, (Component)new TextComponent("" + data.getMoney()), (float)(this.f_97735_ + 237), (float)(this.f_97736_ + 197), 1.0f, 0));
        if (((ContainerShop)this.f_97732_).getCurrentCost() > 0) {
            ClientHandlers.drawRightAlignedScaledString(stack, this.f_96547_, (Component)new TextComponent("" + ((ContainerShop)this.f_97732_).getCurrentCost()), (float)(this.f_97735_ + 237), (float)(this.f_97736_ + 175), 1.0f, 0);
        }
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.m_6597_(slot, slotId, mouseButton, type);
        this.lastClickSlotShop = slot != null && slot.f_40218_ != this.inventory ? slot : null;
        this.isLeftClickDown = mouseButton == 0;
        this.isRightClickDown = mouseButton == 1;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isLeftClickDown = false;
        this.isRightClickDown = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        ClientHandlers.drawCenteredScaledString(poseStack, this.f_96547_, this.f_96539_, 74.0f, 10.0f, 1.0f, 0);
    }

    public void m_7861_() {
        super.m_7861_();
        Platform.INSTANCE.sendToServer(new C2SNPCInteraction(((ContainerShop)this.f_97732_).getShopOwner().m_142049_(), C2SNPCInteraction.Type.CLOSE));
    }

    public void drawBubble(Component txt) {
        this.speech.showBubble(txt, 200);
    }

    public void updateButtons() {
        if (this.next != null) {
            this.next.f_93624_ = ((ContainerShop)this.f_97732_).hasNext();
        }
        if (this.prev != null) {
            this.prev.f_93624_ = ((ContainerShop)this.f_97732_).hasPrev();
        }
    }
}

