/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.common.utils.CalendarImpl;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class OverlayGui
extends GuiComponent {
    private static final ResourceLocation TEXTURE_PATH = new ResourceLocation("runecraftory", "textures/gui/bars.png");
    private final Minecraft mc;

    public OverlayGui(Minecraft mc) {
        this.mc = mc;
    }

    public void renderBar(PoseStack stack) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_PATH);
        int guiWidth = this.mc.m_91268_().m_85445_();
        int guiHeight = this.mc.m_91268_().m_85446_();
        if (ClientConfig.renderHealthRpBar != ClientConfig.HealthRPRenderType.NONE) {
            PlayerData data = Platform.INSTANCE.getPlayerData((Player)this.mc.f_91074_).orElse(null);
            int barWidth = 76;
            int yHeight = ClientConfig.renderHealthRpBar == ClientConfig.HealthRPRenderType.BOTH ? 32 : 11;
            int xPos = ClientConfig.healthBarWidgetPosition.positionX(guiWidth, barWidth + 20 + 2, ClientConfig.healthBarWidgetX) + 1;
            int yPos = ClientConfig.healthBarWidgetPosition.positionY(guiHeight, yHeight, ClientConfig.healthBarWidgetY) + 1;
            this.renderHead(stack, xPos, yPos);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_PATH);
            xPos += 20;
            if (data != null && !this.mc.f_91074_.m_7500_()) {
                if (ClientConfig.renderHealthRpBar == ClientConfig.HealthRPRenderType.BOTH) {
                    this.m_93228_(stack, xPos, yPos, 19, 3, barWidth, 9);
                    int healthWidth = Math.min(barWidth, (int)(this.mc.f_91074_.m_21223_() / this.mc.f_91074_.m_21233_() * (float)barWidth));
                    this.m_93228_(stack, xPos, yPos, 19, 28, healthWidth, 9);
                    yPos += 12;
                }
                this.m_93228_(stack, xPos, yPos, 19, 15, barWidth, 9);
                int runePointsWidth = Math.min(barWidth, (int)((float)data.getRunePoints() / (float)data.getMaxRunePoints() * (float)barWidth));
                this.m_93228_(stack, xPos, yPos, 19, 40, runePointsWidth, 9);
            }
        }
        if (ClientConfig.renderCalendar) {
            CalendarImpl calendar = ClientHandlers.CLIENT_CALENDAR;
            EnumSeason season = calendar.currentSeason();
            int xPos = ClientConfig.seasonDisplayPosition.positionX(guiWidth, 37, ClientConfig.seasonDisplayX);
            int yPos = ClientConfig.seasonDisplayPosition.positionY(guiHeight, 36, ClientConfig.seasonDisplayY);
            this.m_93228_(stack, xPos, yPos, 50, 176, 37, 36);
            this.m_93228_(stack, xPos + 3, yPos + 3, season.ordinal() * 32, 226, 32, 30);
            this.m_93228_(stack, xPos, yPos + 39, 0, 176, 48, 17);
            ClientHandlers.drawCenteredScaledString(stack, this.mc.f_91062_, (Component)new TranslatableComponent(calendar.currentDay().translation()).m_7220_((Component)new TranslatableComponent(" " + calendar.date())), (float)(ClientConfig.seasonDisplayX + 26), (float)(ClientConfig.seasonDisplayY + 39 + 5), 1.0f, 12391936);
        }
    }

    private void renderHead(PoseStack stack, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.mc.f_91074_.m_108560_());
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        int sizeX = 16;
        int sizeY = 16;
        OverlayGui.m_93160_((PoseStack)stack, (int)x, (int)y, (int)sizeX, (int)sizeY, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        RenderSystem.m_69478_();
        OverlayGui.m_93160_((PoseStack)stack, (int)x, (int)y, (int)sizeX, (int)sizeY, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        RenderSystem.m_69461_();
    }
}

