/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.npc.NPCTextureLayer;
import io.github.flemmli97.runecraftory.client.npc.RenderNPC;
import io.github.flemmli97.runecraftory.common.network.C2SQuestSelect;
import io.github.flemmli97.runecraftory.common.network.C2SSubmitQuestBoard;
import io.github.flemmli97.runecraftory.common.quests.ClientSideQuestDisplay;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class QuestGui
extends Screen {
    protected static final ResourceLocation TEXTUREPATH = new ResourceLocation("runecraftory", "textures/gui/quest_gui.png");
    protected static final ResourceLocation TEXTUREPATH_WIDGETS = new ResourceLocation("runecraftory", "textures/gui/quest_gui_widgets.png");
    private final int textureX = 238;
    private final int textureY = 175;
    protected int leftPos;
    protected int topPos;
    protected final List<ClientSideQuestDisplay> quests;
    protected final List<Pair<String, List<Pair<Integer, ResourceLocation>>>> heads;
    private Rect scrollBar = new Rect(212, 14, 12, 147);
    private Rect scrollArea = new Rect(14, 14, 210, 147);
    private final QuestButton[] questButtons = new QuestButton[7];
    private QuestSelectButton yesButton;
    private QuestSelectButton noButton;
    private int scrollValue;
    private boolean isDragging;
    private ClientSideQuestDisplay selectedQuest;
    private final boolean hasActive;

    public QuestGui(boolean hasActive, List<ClientSideQuestDisplay> quests) {
        super((Component)new TextComponent(""));
        this.hasActive = hasActive;
        this.quests = quests;
        this.heads = this.quests.stream().map(display -> {
            ArrayList<Pair> textures = new ArrayList<Pair>();
            if (display.features() != null) {
                for (NPCTextureLayer.LayerType layerType : NPCTextureLayer.LayerType.values()) {
                    ResourceLocation text = RenderNPC.getTextureFromLook(display.features(), display.features().view.containsKey(ModNPCLooks.SLIM.get()), layerType, null);
                    if (text.equals((Object)RenderNPC.EMPTY)) continue;
                    textures.add(Pair.of((Object)NPCTextureLayer.color(display.features(), layerType), (Object)text));
                }
            }
            return Pair.of((Object)display.npcSkin(), textures);
        }).toList();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.textureX) / 2;
        this.topPos = (this.f_96544_ - this.textureY) / 2;
        this.yesButton = new QuestSelectButton(this.leftPos + 57, this.topPos + 92, false, b -> {
            Platform.INSTANCE.sendToServer(new C2SQuestSelect(this.selectedQuest.id(), this.selectedQuest.active()));
            Minecraft.m_91087_().m_91152_(null);
        });
        this.m_142416_((GuiEventListener)this.yesButton);
        this.noButton = new QuestSelectButton(this.leftPos + 137, this.topPos + 92, true, b -> {
            this.selectedQuest = null;
            this.yesButton.f_93624_ = false;
            this.noButton.f_93624_ = false;
        });
        this.m_142416_((GuiEventListener)this.noButton);
        ((SubmitButton)this.m_142416_((GuiEventListener)(QuestGui)this.new SubmitButton((int)(this.leftPos + 238), (int)(this.topPos + 153), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$3(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)()))).f_93623_ = this.hasActive;
        for (int i = 0; i < 7; ++i) {
            this.questButtons[i] = new QuestButton(this.leftPos + 14, this.topPos + 14 + i * 21, i, b -> {
                if (b instanceof QuestButton) {
                    QuestButton but = (QuestButton)b;
                    this.selectedQuest = this.quests.get(but.getActualIndex());
                    this.yesButton.f_93624_ = true;
                    this.noButton.f_93624_ = true;
                }
            });
            this.m_142416_((GuiEventListener)this.questButtons[i]);
        }
        this.scrollBar = new Rect(this.leftPos + this.scrollBar.x, this.topPos + this.scrollBar.y, this.scrollBar.width, this.scrollBar.height);
        this.scrollArea = new Rect(this.leftPos + this.scrollArea.x, this.topPos + this.scrollArea.y, this.scrollArea.width, this.scrollArea.height);
    }

    public void m_7333_(PoseStack stack) {
        super.m_7333_(stack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTUREPATH);
        this.m_93228_(stack, this.leftPos, this.topPos, 0, 0, this.textureX, this.textureY);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        for (QuestButton button : this.questButtons) {
            button.f_93624_ = button.index < this.quests.size();
            button.f_93623_ = this.selectedQuest == null;
        }
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        if (this.selectedQuest != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTUREPATH_WIDGETS);
            this.m_93228_(stack, this.leftPos + 52, this.topPos + 56, 13, 25, 134, 63);
            ClientHandlers.drawCenteredScaledString(stack, this.f_96547_, (Component)(this.selectedQuest.active() ? new TranslatableComponent("runecraftory.gui.quests.reset").m_130940_(ChatFormatting.RED) : new TranslatableComponent("runecraftory.gui.quests.accept")), (float)(this.leftPos + 52 + 67), (float)(this.topPos + 61), 1.0f, 0);
        }
        this.yesButton.renderButtonSelect(stack);
        this.noButton.renderButtonSelect(stack);
        this.renderScroller(stack, this.scrollBar.x, this.scrollBar.y);
    }

    public boolean m_7043_() {
        return false;
    }

    private void renderScroller(PoseStack poseStack, int posX, int posY) {
        int steps = this.quests.size() - 7;
        int widgetHeight = 21;
        if (steps > 0) {
            int barHeight = this.scrollBar.height - 2;
            int moveableHeight = barHeight - widgetHeight;
            int k = moveableHeight / steps;
            int yOffset = Mth.m_14045_((int)(this.scrollValue * k), (int)0, (int)moveableHeight);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTUREPATH_WIDGETS);
            this.m_93228_(poseStack, posX, posY + yOffset, 0, 51, 12, widgetHeight);
        }
    }

    private boolean canScroll() {
        return this.quests.size() > 7;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.canScroll() && this.scrollArea.isMouseOver(mouseX, mouseY)) {
            this.setScrollValue((int)((double)this.scrollValue - delta));
        }
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging) {
            int maxY = this.scrollBar.y + this.scrollBar.height - 3;
            int max = this.quests.size() - 7;
            float amount = ((float)mouseY - (float)this.scrollBar.y - 13.5f) / ((float)(maxY - this.scrollBar.y) - 27.0f);
            amount = amount * (float)max + 0.5f;
            this.scrollValue = Mth.m_14045_((int)((int)amount), (int)0, (int)max);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.isDragging = this.canScroll() && this.scrollBar.isMouseOver(mouseX, mouseY);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return true;
    }

    public void m_7861_() {
        super.m_7861_();
        Platform.INSTANCE.sendToServer(new C2SQuestSelect());
    }

    public void setScrollValue(int val) {
        this.scrollValue = Mth.m_14045_((int)val, (int)0, (int)Math.max(0, this.quests.size() - 7));
    }

    private static /* synthetic */ void lambda$init$3(Button b) {
        Platform.INSTANCE.sendToServer(new C2SSubmitQuestBoard());
        Minecraft.m_91087_().m_91152_(null);
    }

    record Rect(int x, int y, int width, int height) {
        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
        }
    }

    private class QuestButton
    extends Button {
        private final int index;

        public QuestButton(int i, int j, int k, Button.OnPress onPress) {
            super(i, j, 198, 21, TextComponent.f_131282_, onPress);
            this.index = k;
            this.f_93624_ = false;
        }

        public int getActualIndex() {
            return this.index + QuestGui.this.scrollValue;
        }

        public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            if (this.getActualIndex() >= QuestGui.this.quests.size()) {
                return;
            }
            if (this.m_198029_() && QuestGui.this.selectedQuest == null) {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTUREPATH_WIDGETS);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_69482_();
                this.m_93228_(poseStack, this.f_93620_, this.f_93621_, 0, 0, this.f_93618_, this.f_93619_);
            }
            ClientSideQuestDisplay display = QuestGui.this.quests.get(this.getActualIndex());
            Pair<String, List<Pair<Integer, ResourceLocation>>> head = QuestGui.this.heads.get(this.getActualIndex());
            int offset = RenderNPC.renderForTooltip(poseStack, this.f_93620_ + 2, this.f_93621_ + 2, (String)head.getFirst(), (List)head.getSecond()) ? 18 : 0;
            Minecraft.m_91087_().f_91062_.m_92889_(poseStack, display.task(), (float)(this.f_93620_ + 2 + offset), (float)(this.f_93621_ + 6), display.active() ? 5341699 : 0);
            this.m_7428_(poseStack, mouseX, mouseY);
        }

        public void m_7428_(PoseStack poseStack, int relativeMouseX, int relativeMouseY) {
            List<? extends Component> description;
            if (this.f_93622_ && this.getActualIndex() < QuestGui.this.quests.size() && QuestGui.this.selectedQuest == null && !(description = QuestGui.this.quests.get(this.getActualIndex()).description()).isEmpty()) {
                QuestGui.this.m_169388_(poseStack, description, Optional.empty(), relativeMouseX, relativeMouseY + 24);
            }
        }
    }

    private static class QuestSelectButton
    extends Button {
        private final boolean red;

        public QuestSelectButton(int i, int j, boolean red, Button.OnPress onPress) {
            super(i, j, 44, 22, (Component)(red ? new TranslatableComponent("runecraftory.generic.no") : new TranslatableComponent("runecraftory.generic.yes")), onPress);
            this.f_93624_ = false;
            this.red = red;
        }

        public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        }

        public void renderButtonSelect(PoseStack poseStack) {
            if (!this.f_93624_) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            Font font = minecraft.f_91062_;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTUREPATH_WIDGETS);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            int i = this.m_198029_() ? 1 : 0;
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            this.m_93228_(poseStack, this.f_93620_, this.f_93621_, 150 + i * 47, 26 + (this.red ? 24 : 0), this.f_93618_, this.f_93619_);
            ClientHandlers.drawCenteredScaledString(poseStack, font, this.m_6035_(), (float)this.f_93620_ + (float)this.f_93618_ / 2.0f, (float)this.f_93621_ + (float)(this.f_93619_ - 8) / 2.0f, 1.0f, 0);
        }
    }

    private class SubmitButton
    extends Button {
        public SubmitButton(int i, int j, Button.OnPress onPress) {
            super(i, j, 20, 22, TextComponent.f_131282_, onPress);
        }

        public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            Minecraft minecraft = Minecraft.m_91087_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTUREPATH_WIDGETS);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            int i = this.m_7202_(this.m_198029_());
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            this.m_93228_(poseStack, this.f_93620_, this.f_93621_, i * 22, 98, this.f_93618_, this.f_93619_);
            this.m_7906_(poseStack, minecraft, mouseX, mouseY);
            this.m_7428_(poseStack, mouseX, mouseY);
        }

        public void m_7428_(PoseStack poseStack, int relativeMouseX, int relativeMouseY) {
            if (this.f_93622_ && this.f_93623_) {
                QuestGui.this.m_96602_(poseStack, (Component)new TranslatableComponent("runecraftory.gui.quest.submit.button"), relativeMouseX, relativeMouseY + 24);
            }
        }
    }
}

