/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.common.entities.EnsembleMonsters;
import io.github.flemmli97.runecraftory.common.items.creative.NPCSpawnEgg;
import io.github.flemmli97.runecraftory.common.items.creative.RuneCraftoryEggItem;
import io.github.flemmli97.runecraftory.common.network.C2SSpawnEgg;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SpawnEggScreen
extends Screen {
    private final Player player;
    protected List<LivingEntity> entities;
    private final InteractionHand hand;
    private int leftPos;
    private int topPos;
    private final int sizeX = 240;
    private final int sizeY = 200;
    private EditBox levelEditor;
    private EditBox npcIDEditor;
    private int level;
    private ResourceLocation npcID;

    public SpawnEggScreen(InteractionHand hand) {
        super((Component)new TextComponent(""));
        this.hand = hand;
        this.player = Minecraft.m_91087_().f_91074_;
    }

    protected void m_7856_() {
        super.m_7856_();
        ItemStack stack = this.player.m_21120_(this.hand);
        Item item = stack.m_41720_();
        if (!(item instanceof SpawnEgg)) {
            Minecraft.m_91087_().m_91152_(null);
            return;
        }
        SpawnEgg egg = (SpawnEgg)item;
        EntityType type = egg.m_43228_(stack.m_41783_());
        Entity e = type.m_20615_((Level)Minecraft.m_91087_().f_91073_);
        if (e instanceof EnsembleMonsters) {
            EnsembleMonsters ensemble = (EnsembleMonsters)e;
            ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
            for (Supplier<EntityType<?>> t : ensemble.entities()) {
                Entity sub = t.get().m_20615_((Level)Minecraft.m_91087_().f_91073_);
                if (!(sub instanceof LivingEntity)) continue;
                LivingEntity livingSub = (LivingEntity)sub;
                list.add(livingSub);
            }
            this.entities = List.copyOf(list);
        } else if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            this.entities = List.of(living);
        } else {
            Minecraft.m_91087_().m_91152_(null);
            return;
        }
        this.leftPos = this.f_96543_ / 2 - this.sizeX / 2;
        this.topPos = this.f_96544_ / 2 - this.sizeY / 2;
        this.buttons();
    }

    public void m_96624_() {
        super.m_96624_();
        this.entities.forEach(entity -> ++entity.f_19797_);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTick) {
        this.m_93179_(stack, this.leftPos, this.topPos, this.leftPos + this.sizeX, this.topPos + this.sizeY, -1072689136, -804253680);
        int xPadding = 16;
        int yOff = 16;
        this.f_96541_.f_91062_.m_92889_(stack, (Component)new TranslatableComponent("runecraftory.gui.level"), (float)(this.leftPos + xPadding), (float)(this.topPos + yOff), 0xFFFFFF);
        this.levelEditor.m_6305_(stack, mouseX, mouseY, partialTick);
        yOff += 96;
        if (this.npcIDEditor != null) {
            this.f_96541_.f_91062_.m_92889_(stack, (Component)new TranslatableComponent("runecraftory.gui.npc.id"), (float)(this.leftPos + xPadding), (float)(this.topPos + yOff), 0xFFFFFF);
            this.npcIDEditor.m_6305_(stack, mouseX, mouseY, partialTick);
        }
        int max = Math.min(4, this.entities.size());
        double middle = (double)(max - 1) / 2.0;
        for (int i = 0; i < max; ++i) {
            LivingEntity entity = this.entities.get(i);
            float scale = 1.0f;
            if ((double)entity.m_20205_() > 1.2) {
                scale = 2.0f / entity.m_20205_();
            }
            if ((double)entity.m_20206_() > 1.6) {
                scale = Math.min(scale, 2.4f / entity.m_20206_());
            }
            int offset = Math.min(Math.abs(i - (int)middle), Math.abs(i - Mth.m_14165_((double)middle)));
            scale = (float)((double)scale * (1.0 - (double)offset * 0.2));
            int posX = 160;
            int posY = 100;
            if (max > 1) {
                posX += (int)(((double)i - middle) * 90.0 * (double)scale);
                posY -= offset * 15;
            }
            InventoryScreen.m_98850_((int)(this.leftPos + posX), (int)(this.topPos + posY), (int)((int)(29.0f * scale)), (float)(this.leftPos + posX - mouseX), (float)(this.topPos + (posY - 35) - mouseY), (LivingEntity)entity);
        }
        super.m_6305_(stack, mouseX, mouseY, partialTick);
    }

    protected void buttons() {
        int padding = 16;
        int yOff = padding + 12;
        this.levelEditor = new EditBox(this.f_96541_.f_91062_, this.leftPos + padding, this.topPos + yOff, 48, 16, (Component)new TextComponent("")){

            public boolean m_5534_(char codePoint, int modifiers) {
                if (Character.isDigit(codePoint)) {
                    return super.m_5534_(codePoint, modifiers);
                }
                return false;
            }
        };
        this.levelEditor.m_94151_(s -> {
            try {
                this.level = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        ItemStack stack = this.player.m_21120_(this.hand);
        this.level = RuneCraftoryEggItem.getMobLevel(stack);
        this.levelEditor.m_94144_("" + this.level);
        this.m_7787_((GuiEventListener)this.levelEditor);
        yOff += 96;
        if (stack.m_41720_() instanceof NPCSpawnEgg) {
            this.npcIDEditor = new EditBox(this.f_96541_.f_91062_, this.leftPos + padding, this.topPos + yOff, this.sizeY - 32, 16, (Component)new TextComponent(""));
            this.npcID = NPCSpawnEgg.getNpcID(stack);
            if (this.npcID != null) {
                this.npcIDEditor.m_94144_(this.npcID.toString());
            }
            this.npcIDEditor.m_94151_(s -> {
                try {
                    this.npcID = new ResourceLocation(s);
                }
                catch (ResourceLocationException resourceLocationException) {
                    // empty catch block
                }
            });
            this.m_7787_((GuiEventListener)this.npcIDEditor);
        }
        this.m_142416_((GuiEventListener)new Button(this.leftPos + this.sizeX / 2 - 50, this.topPos + (yOff += 48), 100, 20, (Component)new TranslatableComponent("runecraftory.gui.save"), b -> {
            Platform.INSTANCE.sendToServer(new C2SSpawnEgg(this.hand, this.level, this.npcID));
            this.f_96541_.m_91152_(null);
        }));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.levelEditor.m_7933_(keyCode, scanCode, modifiers) || this.levelEditor.m_94204_()) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

