/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerUpgrade;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class UpgradeGui
extends AbstractContainerScreen<ContainerUpgrade> {
    private static final ResourceLocation FORGING = new ResourceLocation("runecraftory", "textures/gui/forging_upgrade.png");
    private static final ResourceLocation CRAFTING = new ResourceLocation("runecraftory", "textures/gui/crafting_upgrade.png");
    private final EnumSkills skill;

    public UpgradeGui(ContainerUpgrade container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.skill = switch (((ContainerUpgrade)this.f_97732_).craftingType()) {
            default -> throw new IncompatibleClassChangeError();
            case EnumCrafting.FORGE -> EnumSkills.FORGING;
            case EnumCrafting.ARMOR -> EnumSkills.CRAFTING;
            case EnumCrafting.CHEM -> EnumSkills.CHEMISTRY;
            case EnumCrafting.COOKING -> EnumSkills.COOKING;
        };
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.m_7025_(stack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation texture = FORGING;
        if (((ContainerUpgrade)this.f_97732_).craftingType() == EnumCrafting.ARMOR) {
            texture = CRAFTING;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        this.m_93228_(stack, this.f_97735_, this.f_97736_, 0, 0, 176, 166);
        PlayerData data = Platform.INSTANCE.getPlayerData((Player)this.f_96541_.f_91074_).orElse(null);
        if (((ContainerUpgrade)this.f_97732_).rpCost() >= 0) {
            int rpMax = data != null ? data.getMaxRunePoints() : 0;
            TextComponent cost = new TextComponent("" + ((ContainerUpgrade)this.f_97732_).rpCost());
            int yOffset = 0;
            if (rpMax < ((ContainerUpgrade)this.f_97732_).rpCost() && !this.f_96541_.f_91074_.m_7500_()) {
                cost = new TranslatableComponent("runecraftory.gui.crafting.rpMax.missing").m_130940_(ChatFormatting.DARK_RED);
                yOffset = -25;
            }
            ClientHandlers.drawCenteredScaledString(stack, this.f_96547_, (Component)cost, (float)(this.f_97735_ + 91), (float)(this.f_97736_ + 42 + yOffset), 1.0f, 0);
        }
        if (data != null) {
            stack.m_85836_();
            float scale = 0.8f;
            int xPos = this.f_97735_;
            int yPos = this.f_97736_ - 12;
            stack.m_85837_((double)xPos, (double)yPos, 0.0);
            stack.m_85841_(scale, scale, scale);
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("runecraftory", "textures/gui/bars.png"));
            this.m_93228_(stack, 0, 0, 131, 74, 96, 29);
            int runePointsWidth = Math.min(76, (int)((float)data.getRunePoints() / (float)data.getMaxRunePoints() * 76.0f));
            this.m_93228_(stack, 17, 3, 18, 40, runePointsWidth, 9);
            ClientHandlers.drawCenteredScaledString(stack, this.f_96547_, data.getRunePoints() + "/" + data.getMaxRunePoints(), 55.5f, 5.0f, 0.7f, 0xFFFFFF);
            stack.m_85849_();
            this.f_96547_.m_92889_(stack, (Component)new TranslatableComponent("runecraftory.gui.display.level", new Object[]{data.getSkillLevel(this.skill).getLevel()}), (float)(this.f_97735_ + this.f_97728_ + this.f_96547_.m_92852_((FormattedText)this.f_96539_) + 6), (float)(this.f_97736_ + this.f_97729_), 0x404040);
        }
    }
}

