/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class QuestToast
implements Toast {
    private static final int PAGE_TIME = 2000;
    private final Component title;
    private final Component subtitle;
    private boolean playedSound;
    private List<ToastPage> contents;
    private int page;

    public QuestToast(Component title, Component subtitle) {
        this.title = title;
        this.subtitle = subtitle;
    }

    public Toast.Visibility m_7172_(PoseStack poseStack, ToastComponent toastComponent, long timeSinceLastVisible) {
        int xPadding = 8;
        int yPadding = 6;
        if (this.contents == null) {
            List title = toastComponent.m_94929_().f_91062_.m_92923_((FormattedText)this.title, this.m_7828_() - 30 - xPadding);
            List subtitle = toastComponent.m_94929_().f_91062_.m_92923_((FormattedText)this.subtitle, this.m_7828_() - 30 - xPadding);
            this.contents = QuestToast.getToastPages(title, subtitle);
            return Toast.Visibility.SHOW;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_94893_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        toastComponent.m_93228_(poseStack, 0, 0, 0, 32, this.m_7828_(), this.m_94899_());
        ToastPage content = this.contents.get(this.page);
        toastComponent.m_94929_().f_91062_.m_92877_(poseStack, content.first(), 30.0f, (float)yPadding, 0);
        if (content.second() != null) {
            toastComponent.m_94929_().f_91062_.m_92877_(poseStack, content.second(), 30.0f, (float)(yPadding + 12), 0);
        }
        if (this.page + 1 < this.contents.size() && timeSinceLastVisible >= 2000L * (long)(this.page + 1)) {
            ++this.page;
        }
        if (!this.playedSound && timeSinceLastVisible > 0L) {
            this.playedSound = true;
            toastComponent.m_94929_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12275_, (float)1.0f, (float)1.0f));
        }
        toastComponent.m_94929_().m_91291_().m_115218_(new ItemStack((ItemLike)ModItems.QUEST_BOARD.get()), 8, 8);
        return timeSinceLastVisible >= (long)this.contents.size() * 2000L + 3000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    @NotNull
    private static List<ToastPage> getToastPages(List<FormattedCharSequence> title, List<FormattedCharSequence> subtitle) {
        ArrayList<ToastPage> pages = new ArrayList<ToastPage>();
        if (title.size() == 1 && subtitle.size() == 1) {
            pages.add(new ToastPage(title.get(0), subtitle.get(0)));
        } else {
            int i;
            for (i = 0; i < title.size(); i += 2) {
                if (i + 1 < title.size()) {
                    pages.add(new ToastPage(title.get(i), title.get(i + 1)));
                    continue;
                }
                pages.add(new ToastPage(title.get(i), null));
            }
            for (i = 0; i < subtitle.size(); i += 2) {
                if (i + 1 < subtitle.size()) {
                    pages.add(new ToastPage(subtitle.get(i), subtitle.get(i + 1)));
                    continue;
                }
                pages.add(new ToastPage(subtitle.get(i), null));
            }
        }
        return pages;
    }

    public int m_7828_() {
        return 160;
    }

    public int m_94899_() {
        return 32;
    }

    record ToastPage(FormattedCharSequence first, FormattedCharSequence second) {
    }
}

