/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.client.TransformationHelper;
import io.github.flemmli97.runecraftory.mixinhelper.HumanoidMainHand;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class AnimatedPlayerModel<T extends LivingEntity>
extends EntityModel<T>
implements ExtendedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "animated_player"), "main");
    protected final ModelPartHandler model;
    protected final ModelPartHandler.ModelPartExtended head;
    protected final ModelPartHandler.ModelPartExtended rightArm;
    protected final ModelPartHandler.ModelPartExtended rightArmItem;
    protected final ModelPartHandler.ModelPartExtended leftArm;
    protected final ModelPartHandler.ModelPartExtended leftArmItem;
    protected final ModelPartHandler.ModelPartExtended rightLeg;
    protected final ModelPartHandler.ModelPartExtended leftLeg;
    protected final BlockBenchAnimations anim;

    public AnimatedPlayerModel(ModelPart root) {
        this.model = new ModelPartHandler(root.m_171324_("Body"), "Body");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "player"));
        this.head = this.model.getPart("Head");
        this.rightArm = this.model.getPart("RightArm");
        this.rightArmItem = this.model.getPart("RightItemRoot");
        this.leftArm = this.model.getPart("LeftArm");
        this.leftArmItem = this.model.getPart("LeftItemRoot");
        this.rightLeg = this.model.getPart("RightLeg");
        this.leftLeg = this.model.getPart("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = Body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition LeftItemRoot = LeftArm.m_171599_("LeftItemRoot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)8.0f, (float)0.0f));
        PartDefinition LeftItem = LeftItemRoot.m_171599_("LeftItem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)-8.0f, (float)0.0f));
        PartDefinition RightArm = Body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition RightItemRoot = RightArm.m_171599_("RightItemRoot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)8.0f, (float)0.0f));
        PartDefinition RightItem = RightItemRoot.m_171599_("RightItem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)-8.0f, (float)0.0f));
        PartDefinition LeftLeg = Body.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition RightLeg = Body.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.leftArmItem.visible = false;
        this.rightArmItem.visible = false;
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public boolean setUpModel(LivingEntity entity, HumanoidModel<?> model, @Nullable AttackActionHandler handler, float partialTicks) {
        HumanoidMainHand hands = (HumanoidMainHand)model;
        hands.runecraftory$getLeftHandItem().resetAll();
        hands.runecraftory$getRightHandItem().resetAll();
        if (entity instanceof IAnimated) {
            IAnimated animated = (IAnimated)entity;
            this.setup(model, false);
            return this.anim.doAnimation((ExtendedModel)this, animated.getAnimationHandler(), partialTicks, entity.m_5737_() == HumanoidArm.LEFT);
        }
        if (handler == null) {
            return false;
        }
        this.setup(model, false);
        return this.doAnimation(handler, partialTicks, entity.m_5737_() == HumanoidArm.LEFT);
    }

    private boolean doAnimation(AttackActionHandler handler, float partialTicks, boolean mirror) {
        AnimatedAction current = handler.getAnimation();
        AnimatedAction last = handler.getLastAnimation();
        float interpolationLast = handler.getLastTransitionProgress(partialTicks);
        float interpolation = handler.getCurrentTransitionProgress(partialTicks);
        boolean changed = false;
        if (last != null && interpolationLast > 0.0f) {
            changed = this.anim.doAnimation((ExtendedModel)this, last.getClientIdentifier(), last.getTick(partialTicks), interpolationLast, mirror, false);
        }
        if (current != null && this.anim.doAnimation((ExtendedModel)this, current.getClientIdentifier(), current.getTick(partialTicks), interpolation, mirror, false) && !changed) {
            changed = true;
        }
        return changed;
    }

    private void setup(HumanoidModel<?> model, boolean reset) {
        PartPose body = model.f_102810_.m_171308_();
        this.model.resetPoses();
        this.model.getMainPart().loadPose(body);
        this.leftArm.loadPose(TransformationHelper.withoutParent(body, model.f_102812_.m_171308_()));
        this.rightArm.loadPose(TransformationHelper.withoutParent(body, model.f_102811_.m_171308_()));
        this.leftLeg.loadPose(TransformationHelper.withoutParent(body, model.f_102814_.m_171308_()));
        this.rightLeg.loadPose(TransformationHelper.withoutParent(body, model.f_102813_.m_171308_()));
        this.head.loadPose(TransformationHelper.withoutParent(body, model.f_102808_.m_171308_()));
    }

    public void copyTo(HumanoidModel<?> model) {
        HumanoidMainHand hands = (HumanoidMainHand)model;
        if (model.f_102609_) {
            ModelPartHandler.ModelPartExtended body = this.model.getMainPart();
            body.x = body.getDefaultPose().x;
            body.y = body.getDefaultPose().y;
            body.z = body.getDefaultPose().z;
            PoseStack stack = new PoseStack();
            body.translateAndRotate(stack);
            float bodyLength = -12.0f;
            Vector3f v = new Vector3f(0.0f, bodyLength, 0.0f);
            v.m_122249_(stack.m_85850_().m_85864_());
            body.x += v.m_122239_();
            body.y += v.m_122260_() - bodyLength;
            body.z += v.m_122269_();
        }
        PartPose main = this.model.getMainPart().storePose();
        this.apply(model.f_102808_, main, this.head);
        model.f_102810_.m_171322_(main);
        this.apply(model.f_102812_, main, this.leftArm);
        hands.runecraftory$getLeftHandItem().loadPose(this.leftArmItem.storePose());
        this.apply(model.f_102811_, main, this.rightArm);
        hands.runecraftory$getRightHandItem().loadPose(this.rightArmItem.storePose());
        if (!model.f_102609_) {
            this.apply(model.f_102814_, main, this.leftLeg);
            this.apply(model.f_102813_, main, this.rightLeg);
        }
        model.f_102809_.m_104315_(model.f_102808_);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    private void apply(ModelPart model, PartPose main, ModelPartHandler.ModelPartExtended first) {
        model.m_171322_(TransformationHelper.withParent(main, first.storePose()));
    }
}

