/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntityAmbrosia;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelAmbrosia<T extends EntityAmbrosia>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "ambrosia"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelAmbrosia(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "ambrosia"));
        this.body = this.model.getPart("body");
        this.head = this.model.getPart("head");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171480_().m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0698f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hornFront = head.m_171599_("hornFront", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-0.5f, -5.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)-2.5f, (float)0.6009f, (float)0.0f, (float)0.0f));
        PartDefinition hornLeftStick = head.m_171599_("hornLeftStick", CubeListBuilder.m_171558_().m_171514_(4, 16).m_171480_().m_171488_(-0.5f, -3.0f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.75f, (float)-8.0f, (float)-0.75f, (float)0.1745f, (float)0.0f, (float)-0.0524f));
        PartDefinition hornLeftFlower = hornLeftStick.m_171599_("hornLeftFlower", CubeListBuilder.m_171558_().m_171514_(8, 16).m_171480_().m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition hornRightStick = head.m_171599_("hornRightStick", CubeListBuilder.m_171558_().m_171514_(4, 16).m_171488_(-0.5f, -3.0f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.75f, (float)-8.0f, (float)-0.75f, (float)0.1745f, (float)0.0f, (float)0.0524f));
        PartDefinition hornRightFlower = hornRightStick.m_171599_("hornRightFlower", CubeListBuilder.m_171558_().m_171514_(8, 16).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition leftUpperWing = body.m_171599_("leftUpperWing", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(0.0f, -15.0f, 0.0f, 17.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)2.0f, (float)-0.2618f, (float)0.0f, (float)0.0873f));
        PartDefinition leftLowerWing = body.m_171599_("leftLowerWing", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171480_().m_171488_(0.0f, 0.0f, 0.0f, 17.0f, 14.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)2.0f, (float)0.2618f, (float)0.0f, (float)-0.0873f));
        PartDefinition rightUpperWing = body.m_171599_("rightUpperWing", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-17.0f, -15.0f, 0.0f, 17.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)2.0f, (float)-0.2618f, (float)0.0f, (float)-0.0873f));
        PartDefinition rightLowerWing = body.m_171599_("rightLowerWing", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-17.0f, 0.0f, 0.0f, 17.0f, 14.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)2.0f, (float)0.2618f, (float)0.0f, (float)0.0873f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(33, 1).m_171480_().m_171488_(-1.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)5.0f, (float)2.5f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.1f));
        PartDefinition leftArmDown = leftArm.m_171599_("leftArmDown", CubeListBuilder.m_171558_().m_171514_(33, 11).m_171480_().m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.5f, (float)4.0f, (float)1.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(33, 1).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)2.5f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)-0.1f));
        PartDefinition rightArmDown = rightArm.m_171599_("rightArmDown", CubeListBuilder.m_171558_().m_171514_(33, 11).m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)4.0f, (float)1.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition dressUp = body.m_171599_("dressUp", CubeListBuilder.m_171558_().m_171514_(34, 50).m_171480_().m_171488_(-5.0f, 0.0f, -3.0f, 10.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition dressDown = dressUp.m_171599_("dressDown", CubeListBuilder.m_171558_().m_171514_(24, 57).m_171480_().m_171488_(-5.5f, 0.0f, -3.5f, 11.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(34, 20).m_171480_().m_171488_(-1.9f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.9f, (float)11.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition leftLegDown = leftLeg.m_171599_("leftLegDown", CubeListBuilder.m_171558_().m_171514_(50, 20).m_171480_().m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.1f, (float)7.0f, (float)-2.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(34, 31).m_171488_(-2.1f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.9f, (float)11.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition rightLegDown = rightLeg.m_171599_("rightLegDown", CubeListBuilder.m_171558_().m_171514_(50, 30).m_171480_().m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-0.1f, (float)7.0f, (float)-2.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)66, (int)65);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        AnimatedAction anim = ((EntityAmbrosia)entity).getAnimationHandler().getAnimation();
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityAmbrosia)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.head.yRot += netHeadYaw * ((float)Math.PI / 180);
            this.head.xRot += headPitch * ((float)Math.PI / 180);
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityAmbrosia)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0 && anim == null) {
                this.body.xRot += (float)Math.PI / 90 * ((BaseMonster)entity).interpolatedMoveTick(partialTicks);
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityAmbrosia)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

