/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityAnt;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelAnt<T extends EntityAnt>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "ant"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelAnt(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "ant"));
        this.body = this.model.getPart("body");
        this.head = this.model.getPart("head");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(26, 29).m_171488_(-3.0f, -2.0f, -4.0f, 6.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)-3.0f));
        PartDefinition bodyConnector = body.m_171599_("bodyConnector", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-2.0f, -1.0f, -8.5f, 4.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)3.5f));
        PartDefinition bodyBack = body.m_171599_("bodyBack", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -2.5f, 0.0f, 10.0f, 5.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(23, 19).m_171488_(-3.5f, -3.5f, 1.0f, 7.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-4.0f));
        PartDefinition headFront = head.m_171599_("headFront", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.5f, -2.5f, -7.0f, 9.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-1.0f));
        PartDefinition feelerLeft = headFront.m_171599_("feelerLeft", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171480_().m_171488_(-0.5f, -5.5f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.5f, (float)-2.5f, (float)-6.5f, (float)0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition feelerRight = headFront.m_171599_("feelerRight", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(-0.5f, -5.5f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5f, (float)-2.5f, (float)-6.5f, (float)0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition jawLeft = headFront.m_171599_("jawLeft", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(0.0f, -0.5f, -3.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)1.5f, (float)-6.5f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        PartDefinition jawRight = headFront.m_171599_("jawRight", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -0.5f, -3.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)1.5f, (float)-6.5f, (float)0.0f, (float)0.3491f, (float)0.0f));
        PartDefinition leg1Up1 = body.m_171599_("leg1Up1", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171480_().m_171488_(-7.0f, -1.0f, -1.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)1.0f, (float)1.5f, (float)0.0f, (float)0.6109f, (float)0.2618f));
        PartDefinition leg1Down1 = leg1Up1.m_171599_("leg1Down1", CubeListBuilder.m_171558_().m_171514_(25, 16).m_171480_().m_171488_(-9.0f, -1.0f, -0.5f, 9.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-6.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)-0.6981f));
        PartDefinition leg1Up2 = body.m_171599_("leg1Up2", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171480_().m_171488_(-7.0f, -1.0f, -1.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition leg1Down2 = leg1Up2.m_171599_("leg1Down2", CubeListBuilder.m_171558_().m_171514_(25, 16).m_171480_().m_171488_(-9.0f, -1.0f, -0.5f, 9.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-6.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)-0.6981f));
        PartDefinition leg1Up3 = body.m_171599_("leg1Up3", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171480_().m_171488_(-7.0f, -1.0f, -1.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)1.0f, (float)-1.5f, (float)0.0f, (float)-0.5236f, (float)0.3491f));
        PartDefinition leg1Down3 = leg1Up3.m_171599_("leg1Down3", CubeListBuilder.m_171558_().m_171514_(25, 16).m_171480_().m_171488_(-9.0f, -1.0f, -0.5f, 9.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-6.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)-0.7854f));
        PartDefinition leg1Up4 = body.m_171599_("leg1Up4", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171488_(0.0f, -1.0f, -1.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)1.0f, (float)-1.5f, (float)0.0f, (float)0.5236f, (float)-0.3491f));
        PartDefinition leg1Down4 = leg1Up4.m_171599_("leg1Down4", CubeListBuilder.m_171558_().m_171514_(25, 16).m_171488_(0.0f, -1.0f, -0.5f, 9.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.7854f));
        PartDefinition leg1Up5 = body.m_171599_("leg1Up5", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171488_(0.0f, -1.0f, -1.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition leg1Down5 = leg1Up5.m_171599_("leg1Down5", CubeListBuilder.m_171558_().m_171514_(25, 16).m_171488_(0.0f, -1.0f, -0.5f, 9.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.6981f));
        PartDefinition leg1Up6 = body.m_171599_("leg1Up6", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171488_(0.0f, -1.0f, -1.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)1.0f, (float)1.5f, (float)0.0f, (float)-0.6109f, (float)-0.2618f));
        PartDefinition leg1Down6 = leg1Up6.m_171599_("leg1Down6", CubeListBuilder.m_171558_().m_171514_(25, 16).m_171488_(0.0f, -1.0f, -0.5f, 9.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.6981f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.5f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.5f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityAnt)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityAnt)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityAnt)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityAnt)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

