/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityBeetle;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelBeetle<T extends EntityBeetle>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "beetle"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelBeetle(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "beetle"));
        this.head = this.model.getPart("head");
        this.body = this.model.getPart("body");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -5.0f, -7.0f, 10.0f, 7.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(50, 0).m_171488_(-4.5f, 2.0f, -7.0f, 9.0f, 2.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)3.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(26, 44).m_171488_(-2.0f, -3.1f, -5.0f, 4.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(10, 73).m_171488_(-2.0f, -2.1f, -6.0f, 4.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(32, 80).m_171488_(-1.0f, -1.1f, -7.0f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-7.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition chin = head.m_171599_("chin", CubeListBuilder.m_171558_().m_171514_(0, 80).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.9f, (float)-7.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition headLeft = head.m_171599_("headLeft", CubeListBuilder.m_171558_().m_171514_(44, 44).m_171488_(-2.0f, -3.1f, -5.0f, 2.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(60, 44).m_171488_(-3.0f, -4.1f, -2.0f, 2.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)0.0f));
        PartDefinition headRight = head.m_171599_("headRight", CubeListBuilder.m_171558_().m_171514_(44, 44).m_171480_().m_171488_(0.0f, -3.1f, -5.0f, 2.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(60, 44).m_171480_().m_171488_(1.0f, -4.1f, -2.0f, 2.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f));
        PartDefinition headUp = head.m_171599_("headUp", CubeListBuilder.m_171558_().m_171514_(0, 73).m_171488_(-1.5f, -2.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(54, 64).m_171488_(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(16, 64).m_171488_(-2.5f, -5.0f, 1.0f, 5.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 64).m_171488_(-2.5f, -6.0f, 3.0f, 5.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.1f, (float)-4.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition hornFront = headUp.m_171599_("hornFront", CubeListBuilder.m_171558_().m_171514_(16, 80).m_171488_(-0.5f, -2.0f, -3.25f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-0.75f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition hornFrontTip2 = hornFront.m_171599_("hornFrontTip2", CubeListBuilder.m_171558_().m_171514_(36, 73).m_171488_(-0.5f, -2.0f, -4.25f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-3.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition hornBackBase = body.m_171599_("hornBackBase", CubeListBuilder.m_171558_().m_171514_(62, 73).m_171488_(-1.0f, -4.5f, -1.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.5f, (float)-5.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition hornBack = hornBackBase.m_171599_("hornBack", CubeListBuilder.m_171558_().m_171514_(10, 80).m_171488_(-0.5f, -5.25f, -2.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.25f, (float)0.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition hornBackTip = hornBack.m_171599_("hornBackTip", CubeListBuilder.m_171558_().m_171514_(38, 80).m_171488_(-0.5f, -5.25f, -1.0f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)-1.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition elytronLeft = body.m_171599_("elytronLeft", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-3.0f, -1.0f, 0.0f, 5.0f, 1.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(40, 22).m_171488_(2.0f, 0.0f, 0.0f, 1.0f, 7.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(42, 64).m_171488_(-3.0f, -0.01f, 15.0f, 5.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-5.0f, (float)-7.0f));
        PartDefinition elytronRight = body.m_171599_("elytronRight", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, -1.0f, 0.0f, 5.0f, 1.0f, 15.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(40, 22).m_171480_().m_171488_(-3.0f, 0.0f, 0.0f, 1.0f, 7.0f, 15.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(42, 64).m_171480_().m_171488_(-2.0f, -0.01f, 15.0f, 5.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)-5.0f, (float)-7.0f));
        PartDefinition wingLeft = body.m_171599_("wingLeft", CubeListBuilder.m_171558_().m_171514_(72, 22).m_171488_(-1.0f, 0.0f, -1.0f, 5.0f, 0.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-5.0f, (float)-4.0f));
        PartDefinition wingLeftSide = wingLeft.m_171599_("wingLeftSide", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171480_().m_171488_(0.0f, 0.0f, -6.0f, 0.0f, 7.0f, 13.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)5.0f));
        PartDefinition wingLeftBack = wingLeftSide.m_171599_("wingLeftBack", CubeListBuilder.m_171558_().m_171514_(66, 64).m_171488_(-5.0f, -3.0f, 0.0f, 5.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)7.0f));
        PartDefinition wingRight = body.m_171599_("wingRight", CubeListBuilder.m_171558_().m_171514_(72, 22).m_171480_().m_171488_(-4.0f, 0.0f, -1.0f, 5.0f, 0.0f, 13.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)-5.0f, (float)-4.0f));
        PartDefinition wingRightSide = wingRight.m_171599_("wingRightSide", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(0.0f, 0.0f, -6.0f, 0.0f, 7.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)5.0f));
        PartDefinition wingRightBack = wingRightSide.m_171599_("wingRightBack", CubeListBuilder.m_171558_().m_171514_(66, 64).m_171480_().m_171488_(0.0f, -3.0f, 0.0f, 5.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)7.0f));
        PartDefinition legLeft = body.m_171599_("legLeft", CubeListBuilder.m_171558_().m_171514_(30, 64).m_171488_(0.0f, 0.0f, -1.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)4.0f, (float)5.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftMiddle = legLeft.m_171599_("legLeftMiddle", CubeListBuilder.m_171558_().m_171514_(54, 73).m_171488_(-0.5f, 0.0f, 0.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)5.0f, (float)0.0f, (float)1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftDown = legLeftMiddle.m_171599_("legLeftDown", CubeListBuilder.m_171558_().m_171514_(46, 73).m_171488_(-0.5f, 0.0f, -1.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)1.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftDown2 = legLeftDown.m_171599_("legLeftDown2", CubeListBuilder.m_171558_().m_171514_(24, 80).m_171488_(-0.5f, -1.0f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)0.0f));
        PartDefinition legLeftDown3 = legLeftDown.m_171599_("legLeftDown3", CubeListBuilder.m_171558_().m_171514_(24, 80).m_171488_(-0.5f, -1.0f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f));
        PartDefinition legRight = body.m_171599_("legRight", CubeListBuilder.m_171558_().m_171514_(30, 64).m_171480_().m_171488_(-3.0f, 0.0f, -1.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)4.0f, (float)5.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition legRightMiddle = legRight.m_171599_("legRightMiddle", CubeListBuilder.m_171558_().m_171514_(54, 73).m_171480_().m_171488_(-1.5f, 0.0f, 0.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)5.0f, (float)0.0f, (float)1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition legRightDown = legRightMiddle.m_171599_("legRightDown", CubeListBuilder.m_171558_().m_171514_(46, 73).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)1.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition legRightDown2 = legRightDown.m_171599_("legRightDown2", CubeListBuilder.m_171558_().m_171514_(24, 80).m_171480_().m_171488_(-0.5f, -1.0f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)0.0f));
        PartDefinition legRightDown3 = legRightDown.m_171599_("legRightDown3", CubeListBuilder.m_171558_().m_171514_(24, 80).m_171480_().m_171488_(-0.5f, -1.0f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f));
        PartDefinition armLeft = body.m_171599_("armLeft", CubeListBuilder.m_171558_().m_171514_(28, 73).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)4.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-0.9599f));
        PartDefinition armLeftMiddle = armLeft.m_171599_("armLeftMiddle", CubeListBuilder.m_171558_().m_171514_(42, 83).m_171488_(-1.5f, 0.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 87).m_171488_(-1.0f, 2.0f, 0.5f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(52, 82).m_171488_(-0.5f, 2.0f, 0.0f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)5.0f, (float)0.5f, (float)0.0873f, (float)0.0f, (float)0.7854f));
        PartDefinition leftClaw = armLeftMiddle.m_171599_("leftClaw", CubeListBuilder.m_171558_().m_171514_(52, 80).m_171488_(-0.5f, 0.25f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)4.75f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition armRight = body.m_171599_("armRight", CubeListBuilder.m_171558_().m_171514_(28, 73).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.5f, (float)4.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.9599f));
        PartDefinition armRightMiddle = armRight.m_171599_("armRightMiddle", CubeListBuilder.m_171558_().m_171514_(42, 83).m_171480_().m_171488_(-0.5f, 0.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 87).m_171488_(0.0f, 2.0f, 0.5f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(52, 82).m_171488_(0.5f, 2.0f, 0.0f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)5.0f, (float)0.5f, (float)0.0873f, (float)0.0f, (float)-0.7854f));
        PartDefinition rightClaw = armRightMiddle.m_171599_("rightClaw", CubeListBuilder.m_171558_().m_171514_(52, 80).m_171480_().m_171488_(-0.5f, 0.25f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.5f, (float)4.75f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        PartDefinition armLeft2 = body.m_171599_("armLeft2", CubeListBuilder.m_171558_().m_171514_(20, 73).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.5f, (float)4.0f, (float)-1.0f, (float)0.1745f, (float)0.0f, (float)-0.4363f));
        PartDefinition armLeft2Middle = armLeft2.m_171599_("armLeft2Middle", CubeListBuilder.m_171558_().m_171514_(42, 80).m_171488_(-1.5f, 0.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(56, 80).m_171488_(-1.0f, 2.0f, -0.5f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(48, 82).m_171488_(-0.5f, 2.0f, -1.0f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)5.0f, (float)1.5f, (float)-0.3491f, (float)0.0f, (float)0.7854f));
        PartDefinition leftClaw2 = armLeft2Middle.m_171599_("leftClaw2", CubeListBuilder.m_171558_().m_171514_(48, 80).m_171488_(-0.5f, 0.25f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)4.75f, (float)-0.5f));
        PartDefinition armRight2 = body.m_171599_("armRight2", CubeListBuilder.m_171558_().m_171514_(20, 73).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.5f, (float)4.0f, (float)-1.0f, (float)0.1745f, (float)0.0f, (float)0.4363f));
        PartDefinition armRight2Middle = armRight2.m_171599_("armRight2Middle", CubeListBuilder.m_171558_().m_171514_(42, 80).m_171480_().m_171488_(-0.5f, 0.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(56, 80).m_171488_(0.0f, 2.0f, -0.5f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(48, 82).m_171488_(0.5f, 2.0f, -1.0f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)5.0f, (float)1.5f, (float)-0.3491f, (float)0.0f, (float)-0.7854f));
        PartDefinition rightClaw2 = armRight2Middle.m_171599_("rightClaw2", CubeListBuilder.m_171558_().m_171514_(48, 80).m_171488_(-0.5f, 0.25f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)4.75f, (float)-0.5f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)6.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.5f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.5f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityBeetle)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityBeetle)entity).f_19797_, partialTicks);
            if (!entity.m_20096_()) {
                this.anim.doAnimation((ExtendedModel)this, "fly", ((EntityBeetle)entity).f_19797_, partialTicks);
            } else if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityBeetle)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityBeetle)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

