/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityBigMuck;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelBigMuck<T extends EntityBigMuck>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "big_muck"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended cap;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelBigMuck(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "big_muck"));
        this.body = this.model.getPart("body");
        this.cap = this.model.getPart("mushroomCap");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -14.0f, -5.0f, 11.0f, 14.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(0, 25).m_171488_(-5.0f, -14.0f, -6.0f, 9.0f, 14.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 0).m_171488_(5.0f, -14.0f, -4.0f, 1.0f, 14.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(44, 0).m_171488_(-7.0f, -14.0f, -4.0f, 1.0f, 14.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(20, 25).m_171488_(-5.0f, -14.0f, 6.0f, 9.0f, 14.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)24.0f, (float)-0.5f));
        PartDefinition mushroomCap = body.m_171599_("mushroomCap", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-9.5f, -2.0f, -9.5f, 19.0f, 2.0f, 19.0f, new CubeDeformation(0.0f)).m_171514_(0, 69).m_171488_(-7.5f, -4.0f, -7.5f, 15.0f, 2.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(0, 86).m_171488_(-6.5f, -7.0f, -6.5f, 13.0f, 3.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(0, 102).m_171488_(-5.5f, -10.0f, -5.5f, 11.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(0, 116).m_171488_(-3.5f, -12.0f, -3.5f, 7.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-14.0f, (float)0.5f));
        PartDefinition ridingPos = mushroomCap.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)3.0f));
        PartDefinition handLeft = body.m_171599_("handLeft", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171480_().m_171488_(0.0f, -0.5f, -3.5f, 8.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)6.0f, (float)-8.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition handRight = body.m_171599_("handRight", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171488_(-8.0f, -0.5f, -3.5f, 8.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.0f, (float)-8.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(44, 23).m_171488_(-0.5f, -1.0f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-1.0f, (float)7.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition tailCap = tail.m_171599_("tailCap", CubeListBuilder.m_171558_().m_171514_(50, 23).m_171488_(-1.5f, -1.5f, 2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)76, (int)125);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityBigMuck)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityBigMuck)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityBigMuck)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityBigMuck)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.cap.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

